/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.ClassMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.constantpool.MissingFieldRefConstant;
import com.oracle.truffle.espresso.constantpool.PreResolvedClassConstant;
import com.oracle.truffle.espresso.constantpool.PreResolvedConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedClassConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedClassMethodRefConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedDoubleDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedFailDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedFieldRefConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedFloatDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedIntDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedInterfaceMethodRefConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedInvokeDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedLongDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedMethodHandleConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedMethodTypeConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedObjectDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedStringConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedWithInvokerClassMethodRefConstant;
import com.oracle.truffle.espresso.constantpool.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.methodhandle.MHInvokeGenericNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MHLinkToNode;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.resolver.LinkResolver;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.logging.Level;

public final class Resolution {
    static final DebugCounter CLASS_RESOLVE_COUNT = DebugCounter.create("ClassConstant.resolve calls");
    static final DebugCounter FIELDREF_RESOLVE_COUNT = DebugCounter.create("FieldRef.resolve calls");
    static final DebugCounter METHODREF_RESOLVE_COUNT = DebugCounter.create("MethodRef.resolve calls");

    public static ResolvedStringConstant resolveStringConstant(StringConstant.Index thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        return new ResolvedStringConstant(pool.getContext().getStrings().intern(thiz.getSymbol(pool)));
    }

    public static Resolvable.ResolvedConstant preResolvedConstant(@JavaType(value=Object.class) StaticObject resolved, ConstantPool.Tag tag) {
        return new PreResolvedConstant(resolved, tag);
    }

    /*
     * Exception decompiling
     */
    public static ResolvedClassConstant resolveClassConstant(ClassConstant.Index thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResolvedClassConstant resolveClassConstant(PreResolvedClassConstant thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        return new ResolvedClassConstant(thiz.getResolved());
    }

    public static ResolvedClassConstant resolveClassConstant(ClassConstant.WithString thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        CLASS_RESOLVE_COUNT.inc();
        assert (accessingKlass != null);
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Symbol<Symbol.Name> klassName = thiz.getName(pool);
        EspressoContext context = pool.getContext();
        Meta meta = context.getMeta();
        Klass klass = meta.resolveSymbolOrFail(context.getTypes().fromName(klassName), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
        if (!Klass.checkAccess(klass.getElementalType(), accessingKlass, false)) {
            context.getLogger().log(Level.FINE, "Access check of: " + String.valueOf(klass.getType()) + " from " + String.valueOf(accessingKlass.getType()) + " throws IllegalAccessError");
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(klassName));
        }
        return new ResolvedClassConstant(klass);
    }

    public static Resolvable.ResolvedConstant resolveFieldRefConstant(FieldRefConstant.Indexes thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        Field field;
        block5: {
            FIELDREF_RESOLVE_COUNT.inc();
            Klass holderKlass = Resolution.getResolvedHolderKlass(thiz, pool, accessingKlass);
            Symbol<Symbol.Name> name = thiz.getName(pool);
            Symbol<Symbol.Type> type = thiz.getType(pool);
            Meta meta = pool.getContext().getMeta();
            ClassRedefinition classRedefinition = null;
            try {
                try {
                    field = LinkResolver.resolveFieldSymbol(meta, accessingKlass, name, type, holderKlass, true, true);
                }
                catch (EspressoException e) {
                    classRedefinition = pool.getContext().getClassRedefinition();
                    if (classRedefinition != null) {
                        classRedefinition.check();
                        field = LinkResolver.resolveFieldSymbol(meta, accessingKlass, name, type, holderKlass, true, true);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (EspressoException e) {
                return new MissingFieldRefConstant(e, classRedefinition == null ? Assumption.ALWAYS_VALID : classRedefinition.getMissingFieldAssumption());
            }
        }
        return new ResolvedFieldRefConstant(field);
    }

    public static Klass getResolvedHolderKlass(MemberRefConstant.Indexes thiz, RuntimeConstantPool pool, ObjectKlass accessingKlass) {
        return pool.resolvedKlassAt(accessingKlass, thiz.getClassIndex());
    }

    @CompilerDirectives.TruffleBoundary
    public static void memberDoAccessCheck(ObjectKlass accessingKlass, Klass resolvedKlass, Member<? extends Symbol.Descriptor> member, Meta meta) {
        if (!Resolution.memberCheckAccess(accessingKlass, resolvedKlass, member)) {
            String message = "Class " + accessingKlass.getExternalName() + " cannot access method " + resolvedKlass.getExternalName() + "#" + String.valueOf(member.getName());
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(message));
        }
    }

    static boolean memberCheckAccess(ObjectKlass accessingKlass, Klass resolvedKlass, Member<? extends Symbol.Descriptor> member) {
        if (member.isPublic()) {
            return true;
        }
        ObjectKlass memberKlass = member.getDeclaringKlass();
        if (member instanceof Method && Symbol.Name.clone.equals(member.getName()) && memberKlass.isJavaLangObject() && resolvedKlass.isArray()) {
            return true;
        }
        if (member.isProtected() && (!member.isStatic() ? resolvedKlass.isAssignableFrom(accessingKlass) || accessingKlass.isAssignableFrom(resolvedKlass) : memberKlass.isAssignableFrom(accessingKlass))) {
            return true;
        }
        if ((member.isProtected() || member.isPackagePrivate()) && accessingKlass.sameRuntimePackage(memberKlass)) {
            return true;
        }
        if (member.isPrivate() && Resolution.nestMateTest(accessingKlass, memberKlass)) {
            return true;
        }
        if (accessingKlass.getMeta().sun_reflect_MagicAccessorImpl.isAssignableFrom(accessingKlass)) {
            return true;
        }
        if (accessingKlass.getHostClass() != null) {
            CompilerAsserts.partialEvaluationConstant((Object)accessingKlass);
            return Resolution.memberCheckAccess(accessingKlass.getHostClass(), resolvedKlass, member);
        }
        return false;
    }

    static boolean nestMateTest(Klass k1, Klass k2) {
        return k1 == k2 || k1.nest() == k2.nest();
    }

    public static Resolvable.ResolvedConstant resolveInterfaceMethodRefConstant(InterfaceMethodRefConstant.Indexes thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        METHODREF_RESOLVE_COUNT.inc();
        Klass holderInterface = Resolution.getResolvedHolderKlass(thiz, pool, accessingKlass);
        Symbol<Symbol.Name> name = thiz.getName(pool);
        Symbol<Symbol.Signature> signature = thiz.getSignature(pool);
        Method method = LinkResolver.resolveMethodSymbol(pool.getContext().getMeta(), accessingKlass, name, signature, holderInterface, true, true, true);
        return new ResolvedInterfaceMethodRefConstant(method);
    }

    public static Resolvable.ResolvedConstant resolveClassMethodRefConstant(ClassMethodRefConstant.Indexes thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        METHODREF_RESOLVE_COUNT.inc();
        EspressoContext context = pool.getContext();
        Meta meta = context.getMeta();
        Klass holderKlass = Resolution.getResolvedHolderKlass(thiz, pool, accessingKlass);
        Symbol<Symbol.Name> name = thiz.getName(pool);
        Symbol<Symbol.Signature> signature = thiz.getSignature(pool);
        Method method = LinkResolver.resolveMethodSymbol(meta, accessingKlass, name, signature, holderKlass, false, true, true);
        if (method.isInvokeIntrinsic()) {
            MHInvokeGenericNode.MethodHandleInvoker invoker = MHInvokeGenericNode.linkMethod(meta.getLanguage(), meta, accessingKlass, method, name, signature);
            return new ResolvedWithInvokerClassMethodRefConstant(method, invoker);
        }
        return new ResolvedClassMethodRefConstant(method);
    }

    static StaticObject signatureToMethodType(Symbol<Symbol.Type>[] signature, ObjectKlass accessingKlass, boolean failWithBME, Meta meta) {
        StaticObject rtype;
        Symbol<Symbol.Type> rt = Signatures.returnType(signature);
        int pcount = Signatures.parameterCount(signature);
        StaticObject[] ptypes = new StaticObject[pcount];
        try {
            for (int i = 0; i < pcount; ++i) {
                Symbol<Symbol.Type> paramType = Signatures.parameterType(signature, i);
                ptypes[i] = meta.resolveSymbolAndAccessCheck(paramType, accessingKlass).mirror();
            }
        }
        catch (EspressoException e) {
            if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, e.getGuestMessage());
            }
            throw e;
        }
        try {
            rtype = meta.resolveSymbolAndAccessCheck(rt, accessingKlass).mirror();
        }
        catch (EspressoException e) {
            EspressoException rethrow = e;
            if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                rethrow = EspressoException.wrap(Meta.initExceptionWithMessage(meta.java_lang_NoClassDefFoundError, e.getGuestMessage()), meta);
            }
            if (failWithBME) {
                rethrow = EspressoException.wrap(Meta.initExceptionWithCause(meta.java_lang_BootstrapMethodError, rethrow.getGuestException()), meta);
            }
            throw rethrow;
        }
        return (StaticObject)meta.java_lang_invoke_MethodHandleNatives_findMethodHandleType.invokeDirectStatic(rtype, StaticObject.createArray(meta.java_lang_Class_array, ptypes, meta.getContext()));
    }

    public static ResolvedMethodTypeConstant resolveMethodTypeConstant(MethodTypeConstant.Index thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        Symbol<Symbol.Signature> sig = thiz.getSignature(pool);
        Meta meta = accessingKlass.getContext().getMeta();
        return new ResolvedMethodTypeConstant(Resolution.signatureToMethodType(meta.getSignatures().parsed(sig), accessingKlass, false, meta));
    }

    public static Resolvable.ResolvedConstant resolveInvokeDynamicConstant(InvokeDynamicConstant.Indexes thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        CompilerAsserts.neverPartOfCompilation();
        BootstrapMethodsAttribute bms = (BootstrapMethodsAttribute)accessingKlass.getAttribute(BootstrapMethodsAttribute.NAME);
        BootstrapMethodsAttribute.Entry bsEntry = bms.at(thiz.getBootstrapMethodAttrIndex());
        Meta meta = accessingKlass.getMeta();
        Symbol<Symbol.Signature> invokeSignature = thiz.getSignature(pool);
        Symbol<Symbol.Type>[] parsedInvokeSignature = meta.getSignatures().parsed(invokeSignature);
        return new ResolvedInvokeDynamicConstant(bsEntry, parsedInvokeSignature, thiz.getName(pool));
    }

    private static ResolvedDynamicConstant makeResolved(Klass type, StaticObject result) {
        JavaKind kind = type.getJavaKind();
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: {
                int value = (Integer)MHLinkToNode.rebasic(type.getMeta().unboxGuest(result), kind);
                return new ResolvedIntDynamicConstant(value, kind);
            }
            case Int: {
                int value = type.getMeta().unboxInteger(result);
                return new ResolvedIntDynamicConstant(value, JavaKind.Int);
            }
            case Float: {
                float value = type.getMeta().unboxFloat(result);
                return new ResolvedFloatDynamicConstant(value);
            }
            case Long: {
                long value = type.getMeta().unboxLong(result);
                return new ResolvedLongDynamicConstant(value);
            }
            case Double: {
                double value = type.getMeta().unboxDouble(result);
                return new ResolvedDoubleDynamicConstant(value);
            }
            case Object: {
                return new ResolvedObjectDynamicConstant(result);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    public static Resolvable.ResolvedConstant resolveDynamicConstant(DynamicConstant.Indexes thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        Meta meta = accessingKlass.getMeta();
        BootstrapMethodsAttribute bms = (BootstrapMethodsAttribute)accessingKlass.getAttribute(BootstrapMethodsAttribute.NAME);
        assert (bms != null);
        try {
            BootstrapMethodsAttribute.Entry bsEntry = bms.at(thiz.getBootstrapMethodAttrIndex());
            StaticObject bootstrapmethodMethodHandle = pool.getMethodHandle(bsEntry, accessingKlass);
            StaticObject[] args = pool.getStaticArguments(bsEntry, accessingKlass);
            StaticObject fieldName = meta.toGuestString(thiz.getName(pool));
            Klass fieldType = meta.resolveSymbolOrFail(thiz.getTypeSymbol(pool), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
            Object result = null;
            result = !meta.getJavaVersion().java19OrLater() ? meta.java_lang_invoke_MethodHandleNatives_linkDynamicConstant.invokeDirectStatic(accessingKlass.mirror(), thisIndex, bootstrapmethodMethodHandle, fieldName, fieldType.mirror(), StaticObject.wrap(args, meta)) : meta.java_lang_invoke_MethodHandleNatives_linkDynamicConstant.invokeDirectStatic(accessingKlass.mirror(), bootstrapmethodMethodHandle, fieldName, fieldType.mirror(), StaticObject.wrap(args, meta));
            try {
                return Resolution.makeResolved(fieldType, (StaticObject)result);
            }
            catch (ClassCastException | NullPointerException e) {
                throw meta.throwException(meta.java_lang_BootstrapMethodError);
            }
            catch (EspressoException e) {
                if (meta.java_lang_NullPointerException.isAssignableFrom(e.getGuestException().getKlass()) || meta.java_lang_ClassCastException.isAssignableFrom(e.getGuestException().getKlass())) {
                    throw meta.throwExceptionWithCause(meta.java_lang_BootstrapMethodError, e.getGuestException());
                }
                throw e;
            }
        }
        catch (EspressoException e) {
            return new ResolvedFailDynamicConstant(e);
        }
    }

    public static Resolvable.ResolvedConstant resolveMethodHandleConstant(MethodHandleConstant.Index thiz, RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
        Meta meta = pool.getContext().getMeta();
        if (meta.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT || meta.getJavaVersion().java9OrLater()) {
            return Resolution.specCompliantResolution(thiz, pool, accessingKlass, meta);
        }
        return Resolution.hotspotResolutionBehavior(thiz, pool, accessingKlass, meta);
    }

    private static Resolvable.ResolvedConstant specCompliantResolution(MethodHandleConstant.Index thiz, RuntimeConstantPool pool, ObjectKlass accessingKlass, Meta meta) {
        Symbol<Symbol.Name> refName;
        Klass mklass;
        StaticObject mtype;
        ConstantPool.Tag refTag = pool.tagAt(thiz.getRefIndex());
        if (refTag == ConstantPool.Tag.METHOD_REF || refTag == ConstantPool.Tag.INTERFACE_METHOD_REF) {
            Method target = pool.resolvedMethodAt(accessingKlass, thiz.getRefIndex());
            Symbol<Symbol.Type>[] parsed = target.getParsedSignature();
            mtype = Resolution.signatureToMethodType(parsed, accessingKlass, false, meta);
            MethodRefConstant ref = pool.methodAt(thiz.getRefIndex());
            mklass = pool.resolvedKlassAt(accessingKlass, ((MemberRefConstant.Indexes)((Object)ref)).getClassIndex());
            refName = target.getName();
        } else {
            assert (refTag == ConstantPool.Tag.FIELD_REF);
            Field field = pool.resolvedFieldAt(accessingKlass, thiz.getRefIndex());
            mtype = meta.resolveSymbolAndAccessCheck(field.getType(), accessingKlass).mirror();
            mklass = field.getDeclaringKlass();
            refName = field.getName();
        }
        return Resolution.linkMethodHandleConstant(thiz, accessingKlass, meta, mtype, mklass, refName);
    }

    private static Resolvable.ResolvedConstant hotspotResolutionBehavior(MethodHandleConstant.Index thiz, RuntimeConstantPool pool, ObjectKlass accessingKlass, Meta meta) {
        Symbol<Symbol.Name> refName;
        Klass mklass;
        StaticObject mtype;
        ConstantPool.Tag refTag = pool.tagAt(thiz.getRefIndex());
        if (refTag == ConstantPool.Tag.METHOD_REF || refTag == ConstantPool.Tag.INTERFACE_METHOD_REF) {
            MethodRefConstant ref = pool.methodAt(thiz.getRefIndex());
            Symbol<Symbol.Signature> signature = ref.getSignature(pool);
            Symbol<Symbol.Type>[] parsed = meta.getSignatures().parsed(signature);
            mtype = Resolution.signatureToMethodType(parsed, accessingKlass, false, meta);
            mklass = pool.resolvedKlassAt(accessingKlass, ((MemberRefConstant.Indexes)((Object)ref)).getClassIndex());
            refName = ref.getName(pool);
        } else {
            assert (refTag == ConstantPool.Tag.FIELD_REF);
            assert (pool.fieldAt(thiz.getRefIndex()) instanceof FieldRefConstant.Indexes);
            FieldRefConstant.Indexes ref = (FieldRefConstant.Indexes)pool.fieldAt(thiz.getRefIndex());
            Symbol<Symbol.Type> type = ref.getType(pool);
            mtype = meta.resolveSymbolAndAccessCheck(type, accessingKlass).mirror();
            mklass = Resolution.getResolvedHolderKlass(ref, pool, accessingKlass);
            refName = ref.getName(pool);
        }
        return Resolution.linkMethodHandleConstant(thiz, accessingKlass, meta, mtype, mklass, refName);
    }

    private static Resolvable.ResolvedConstant linkMethodHandleConstant(MethodHandleConstant.Index thiz, Klass accessingKlass, Meta meta, StaticObject mtype, Klass mklass, Symbol<Symbol.Name> refName) {
        StaticObject mname = meta.toGuestString(refName);
        return new ResolvedMethodHandleConstant((StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkMethodHandleConstant.invokeDirectStatic(accessingKlass.mirror(), thiz.getRefKind(), mklass.mirror(), mname, mtype));
    }
}

