/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.constantpool.ResolvedDynamicConstant;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;

public final class ResolvedFloatDynamicConstant
implements ResolvedDynamicConstant {
    final float resolved;

    public ResolvedFloatDynamicConstant(float resolved) {
        this.resolved = resolved;
    }

    @Override
    public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
        EspressoFrame.putFloat((Frame)frame, top, this.resolved);
    }

    @Override
    public Object value() {
        return Float.valueOf(this.resolved);
    }

    @Override
    public JavaKind getKind() {
        return JavaKind.Float;
    }

    @Override
    public String toString(ConstantPool pool) {
        return "ResolvedDynamicConstant(" + this.resolved + ")";
    }
}

