/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.constantpool.ResolvedDynamicConstant;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.constant.Constable;

public final class ResolvedIntDynamicConstant
implements ResolvedDynamicConstant {
    final int resolved;
    final JavaKind kind;

    public ResolvedIntDynamicConstant(int resolved, JavaKind kind) {
        this.resolved = resolved;
        this.kind = kind;
    }

    @Override
    public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
        EspressoFrame.putInt((Frame)frame, top, this.resolved);
    }

    @Override
    public Object value() {
        return this.resolved;
    }

    @Override
    public JavaKind getKind() {
        return this.kind;
    }

    @Override
    public StaticObject guestBoxedValue(Meta meta) {
        Constable value = switch (this.kind) {
            case JavaKind.Boolean -> Boolean.valueOf(this.resolved != 0);
            case JavaKind.Byte -> (byte)this.resolved;
            case JavaKind.Short -> (short)this.resolved;
            case JavaKind.Char -> Character.valueOf((char)this.resolved);
            case JavaKind.Int -> this.resolved;
            default -> throw EspressoError.shouldNotReachHere(this.kind.toString());
        };
        return Meta.box(meta, value);
    }

    @Override
    public String toString(ConstantPool pool) {
        return "ResolvedDynamicConstant(" + this.resolved + ")";
    }
}

