/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.constantpool.CallSiteLink;
import com.oracle.truffle.espresso.constantpool.CallSiteLinkingFailure;
import com.oracle.truffle.espresso.constantpool.LinkableInvokeDynamicConstant;
import com.oracle.truffle.espresso.constantpool.Resolution;
import com.oracle.truffle.espresso.constantpool.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;

public final class ResolvedInvokeDynamicConstant
implements LinkableInvokeDynamicConstant {
    private final BootstrapMethodsAttribute.Entry bootstrapMethod;
    private final Symbol<Symbol.Type>[] parsedInvokeSignature;
    private final Symbol<Symbol.Name> nameSymbol;
    private volatile CallSiteLink[] callSiteLinks;

    public ResolvedInvokeDynamicConstant(BootstrapMethodsAttribute.Entry bootstrapMethod, Symbol<Symbol.Type>[] parsedInvokeSignature, Symbol<Symbol.Name> name) {
        this.bootstrapMethod = bootstrapMethod;
        this.parsedInvokeSignature = parsedInvokeSignature;
        this.nameSymbol = name;
    }

    @Override
    public Object value() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Use indy.link() rather than Resolved.value()");
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallSiteLink link(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
        int existingIndex = this.findCallSiteLinkIndex(method, bci);
        if (existingIndex >= 0) {
            return this.getCallSiteLink(existingIndex);
        }
        CallSiteLink newLink = this.createCallSiteLink(pool, accessingKlass, thisIndex, method, bci);
        ResolvedInvokeDynamicConstant resolvedInvokeDynamicConstant = this;
        synchronized (resolvedInvokeDynamicConstant) {
            CallSiteLink[] existingLinks = this.callSiteLinks;
            if (existingLinks == null) {
                CallSiteLink[] newLinks = new CallSiteLink[]{newLink};
                this.callSiteLinks = newLinks;
                return newLink;
            }
            for (int i = 0; i < existingLinks.length; ++i) {
                CallSiteLink link = existingLinks[i];
                if (link == null) {
                    existingLinks[i] = newLink;
                    return existingLinks[i];
                }
                if (!link.matchesCallSite(method, bci)) continue;
                return link;
            }
            CallSiteLink[] newLinks = Arrays.copyOf(existingLinks, existingLinks.length * 2);
            newLinks[i] = newLink;
            this.callSiteLinks = newLinks;
            return newLink;
        }
    }

    private CallSiteLink createCallSiteLink(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
        CompilerAsserts.neverPartOfCompilation();
        Meta meta = accessingKlass.getMeta();
        try {
            StaticObject bootstrapmethodMethodHandle = pool.getMethodHandle(this.bootstrapMethod, accessingKlass);
            StaticObject[] args = pool.getStaticArguments(this.bootstrapMethod, accessingKlass);
            StaticObject name = meta.toGuestString(this.nameSymbol);
            StaticObject methodType = Resolution.signatureToMethodType(this.parsedInvokeSignature, accessingKlass, meta.getContext().getJavaVersion().java8OrEarlier(), meta);
            StaticObject appendix = StaticObject.createArray(meta.java_lang_Object_array, new StaticObject[1], meta.getContext());
            StaticObject memberName = meta.getJavaVersion().varHandlesEnabled() && !meta.getJavaVersion().java19OrLater() ? (StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkCallSite.invokeDirectStatic(accessingKlass.mirror(), thisIndex, bootstrapmethodMethodHandle, name, methodType, StaticObject.createArray(meta.java_lang_Object_array, args.clone(), meta.getContext()), appendix) : (StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkCallSite.invokeDirectStatic(accessingKlass.mirror(), bootstrapmethodMethodHandle, name, methodType, StaticObject.createArray(meta.java_lang_Object_array, args.clone(), meta.getContext()), appendix);
            StaticObject unboxedAppendix = (StaticObject)appendix.get(meta.getLanguage(), 0);
            return new CallSiteLink(method, bci, memberName, unboxedAppendix, this.parsedInvokeSignature);
        }
        catch (EspressoException e) {
            throw new CallSiteLinkingFailure(e);
        }
    }

    public int findCallSiteLinkIndex(Method method, int bci) {
        CallSiteLink link;
        CallSiteLink[] existingLinks = this.callSiteLinks;
        if (existingLinks == null) {
            return -1;
        }
        for (int i = 0; i < existingLinks.length && (link = existingLinks[i]) != null; ++i) {
            if (!link.matchesCallSite(method, bci)) continue;
            return i;
        }
        return -1;
    }

    public CallSiteLink getCallSiteLink(int index) {
        return this.callSiteLinks[index];
    }

    @Override
    public int getBootstrapMethodAttrIndex() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("String already resolved");
    }

    @Override
    public Symbol<Symbol.Name> getName(ConstantPool pool) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("String already resolved");
    }

    @Override
    public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("String already resolved");
    }

    @Override
    public NameAndTypeConstant getNameAndType(ConstantPool pool) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("String already resolved");
    }

    @Override
    public Symbol<Symbol.Type>[] getParsedSignature() {
        return this.parsedInvokeSignature;
    }
}

