/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.ImmutableConstantPool;
import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.ClassMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.constantpool.CallSiteLink;
import com.oracle.truffle.espresso.constantpool.CallSiteLinkingFailure;
import com.oracle.truffle.espresso.constantpool.LinkableInvokeDynamicConstant;
import com.oracle.truffle.espresso.constantpool.NeedsFreshResolutionException;
import com.oracle.truffle.espresso.constantpool.Resolution;
import com.oracle.truffle.espresso.constantpool.ResolvedClassConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedFieldRefConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedInvokeDynamicConstant;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;

public final class RuntimeConstantPool
extends ConstantPool {
    private final EspressoContext context;
    private final ImmutableConstantPool immutableConstantPool;
    private final StaticObject classLoader;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Resolvable.ResolvedConstant[] resolvedConstants;

    public RuntimeConstantPool(EspressoContext context, ImmutableConstantPool immutableConstantPool, StaticObject classLoader) {
        this.context = context;
        this.immutableConstantPool = immutableConstantPool;
        this.resolvedConstants = new Resolvable.ResolvedConstant[immutableConstantPool.length()];
        this.classLoader = classLoader;
    }

    @Override
    public int length() {
        return this.immutableConstantPool.length();
    }

    @Override
    public byte[] getRawBytes() {
        return this.immutableConstantPool.getRawBytes();
    }

    @Override
    public PoolConstant at(int index, String description) {
        try {
            return this.immutableConstantPool.at(index, description);
        }
        catch (ParserException.ClassFormatError e) {
            throw this.classFormatError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolvable.ResolvedConstant outOfLockResolvedAt(ObjectKlass accessingKlass, int index, String description) {
        Resolvable.ResolvedConstant c = this.resolvedConstants[index];
        if (c == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            c = this.resolvedConstants[index];
            if (c == null) {
                Resolvable resolvable = (Resolvable)this.at(index, description);
                Resolvable.ResolvedConstant locallyResolved = this.resolve(resolvable, index, accessingKlass);
                RuntimeConstantPool runtimeConstantPool = this;
                synchronized (runtimeConstantPool) {
                    c = this.resolvedConstants[index];
                    if (c == null) {
                        this.resolvedConstants[index] = c = locallyResolved;
                    }
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolvable.ResolvedConstant resolvedAt(ObjectKlass accessingKlass, int index, String description) {
        Resolvable.ResolvedConstant c = this.resolvedConstants[index];
        if (c == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                c = this.resolvedConstants[index];
                if (c == null) {
                    Resolvable resolvable = (Resolvable)this.at(index, description);
                    this.resolvedConstants[index] = c = this.resolve(resolvable, index, accessingKlass);
                }
            }
        }
        return c;
    }

    private Resolvable.ResolvedConstant resolvedAtNoCache(ObjectKlass accessingKlass, int index, String description) {
        CompilerAsserts.neverPartOfCompilation();
        Resolvable resolvable = (Resolvable)this.immutableConstantPool.at(index, description);
        return this.resolve(resolvable, index, accessingKlass);
    }

    public StaticObject resolvedStringAt(int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(null, index, "string");
        return (StaticObject)resolved.value();
    }

    public Klass resolvedKlassAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "klass");
        return (Klass)resolved.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resolvedFieldAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "field");
        try {
            return (Field)resolved.value();
        }
        catch (NeedsFreshResolutionException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.resolvedConstants[index] = null;
            }
            return this.resolvedFieldAt(accessingKlass, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resolveFieldAndUpdate(ObjectKlass accessingKlass, int index, Field field) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Resolvable.ResolvedConstant resolved = this.resolvedAtNoCache(accessingKlass, index, "field");
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.resolvedConstants[index] = resolved;
            }
            return (Field)resolved.value();
        }
        catch (EspressoException e) {
            Field realField = field;
            if (realField.hasCompatibleField()) {
                realField = realField.getCompatibleField();
            }
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                Field delegationField = this.context.getClassRedefinition().createDelegationFrom(realField);
                ResolvedFieldRefConstant resolved = new ResolvedFieldRefConstant(delegationField);
                this.resolvedConstants[index] = resolved;
                return delegationField;
            }
        }
    }

    public boolean isResolutionSuccessAt(int index) {
        Resolvable.ResolvedConstant constant = this.resolvedConstants[index];
        return constant != null && constant.isSuccess();
    }

    public Method resolvedMethodAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method");
        return (Method)resolved.value();
    }

    public MethodRefConstant resolvedMethodRefAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method");
        return (MethodRefConstant)((Object)resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method resolveMethodAndUpdate(ObjectKlass accessingKlass, int index) {
        CompilerAsserts.neverPartOfCompilation();
        Resolvable.ResolvedConstant resolved = this.resolvedAtNoCache(accessingKlass, index, "method");
        RuntimeConstantPool runtimeConstantPool = this;
        synchronized (runtimeConstantPool) {
            this.resolvedConstants[index] = resolved;
        }
        return (Method)resolved.value();
    }

    public StaticObject resolvedMethodHandleAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method handle");
        return (StaticObject)resolved.value();
    }

    public StaticObject resolvedMethodTypeAt(ObjectKlass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method type");
        return (StaticObject)resolved.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallSiteLink linkInvokeDynamic(ObjectKlass accessingKlass, int index, int bci, Method method) {
        LinkableInvokeDynamicConstant indy = (LinkableInvokeDynamicConstant)this.resolvedAt(accessingKlass, index, "indy");
        try {
            return indy.link(this, accessingKlass, index, method, bci);
        }
        catch (CallSiteLinkingFailure failure) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.resolvedConstants[index] = failure.failConstant();
            }
            throw failure.cause;
        }
    }

    public ResolvedInvokeDynamicConstant peekResolvedInvokeDynamic(int index) {
        return (ResolvedInvokeDynamicConstant)this.resolvedConstants[index];
    }

    public ResolvedDynamicConstant resolvedDynamicConstantAt(ObjectKlass accessingKlass, int index) {
        ResolvedDynamicConstant dynamicConstant = (ResolvedDynamicConstant)this.outOfLockResolvedAt(accessingKlass, index, "dynamic constant");
        dynamicConstant.checkFail();
        return dynamicConstant;
    }

    public StaticObject getClassLoader() {
        return this.classLoader;
    }

    public EspressoContext getContext() {
        return this.context;
    }

    public void setKlassAt(int index, ObjectKlass klass) {
        this.resolvedConstants[index] = new ResolvedClassConstant(klass);
    }

    @Override
    public int getMajorVersion() {
        return this.immutableConstantPool.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.immutableConstantPool.getMinorVersion();
    }

    public StaticObject getMethodHandle(BootstrapMethodsAttribute.Entry entry, ObjectKlass accessingKlass) {
        return this.resolvedMethodHandleAt(accessingKlass, entry.getBootstrapMethodRef());
    }

    public StaticObject[] getStaticArguments(BootstrapMethodsAttribute.Entry entry, ObjectKlass accessingKlass) {
        Meta meta = accessingKlass.getMeta();
        StaticObject[] args = new StaticObject[entry.numBootstrapArguments()];
        block11: for (int i = 0; i < entry.numBootstrapArguments(); ++i) {
            PoolConstant pc = this.at(entry.argAt(i));
            switch (pc.tag()) {
                case METHODHANDLE: {
                    args[i] = this.resolvedMethodHandleAt(accessingKlass, entry.argAt(i));
                    continue block11;
                }
                case METHODTYPE: {
                    args[i] = this.resolvedMethodTypeAt(accessingKlass, entry.argAt(i));
                    continue block11;
                }
                case DYNAMIC: {
                    args[i] = this.resolvedDynamicConstantAt(accessingKlass, entry.argAt(i)).guestBoxedValue(meta);
                    continue block11;
                }
                case CLASS: {
                    args[i] = this.resolvedKlassAt(accessingKlass, entry.argAt(i)).mirror();
                    continue block11;
                }
                case STRING: {
                    args[i] = this.resolvedStringAt(entry.argAt(i));
                    continue block11;
                }
                case INTEGER: {
                    args[i] = meta.boxInteger(this.intAt(entry.argAt(i)));
                    continue block11;
                }
                case LONG: {
                    args[i] = meta.boxLong(this.longAt(entry.argAt(i)));
                    continue block11;
                }
                case DOUBLE: {
                    args[i] = meta.boxDouble(this.doubleAt(entry.argAt(i)));
                    continue block11;
                }
                case FLOAT: {
                    args[i] = meta.boxFloat(this.floatAt(entry.argAt(i)));
                    continue block11;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        }
        return args;
    }

    Resolvable.ResolvedConstant resolve(Resolvable resolvable, int thisIndex, ObjectKlass accessingKlass) {
        switch (resolvable.tag()) {
            case STRING: {
                if (!(resolvable instanceof StringConstant.Index)) break;
                StringConstant.Index fromIndex = (StringConstant.Index)resolvable;
                return Resolution.resolveStringConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case FIELD_REF: {
                if (!(resolvable instanceof FieldRefConstant.Indexes)) break;
                FieldRefConstant.Indexes fromIndex = (FieldRefConstant.Indexes)resolvable;
                return Resolution.resolveFieldRefConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case INTERFACE_METHOD_REF: {
                if (!(resolvable instanceof InterfaceMethodRefConstant.Indexes)) break;
                InterfaceMethodRefConstant.Indexes fromIndex = (InterfaceMethodRefConstant.Indexes)resolvable;
                return Resolution.resolveInterfaceMethodRefConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case METHOD_REF: {
                if (!(resolvable instanceof ClassMethodRefConstant.Indexes)) break;
                ClassMethodRefConstant.Indexes fromIndex = (ClassMethodRefConstant.Indexes)resolvable;
                return Resolution.resolveClassMethodRefConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case METHODTYPE: {
                if (!(resolvable instanceof MethodTypeConstant.Index)) break;
                MethodTypeConstant.Index fromIndex = (MethodTypeConstant.Index)resolvable;
                return Resolution.resolveMethodTypeConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case INVOKEDYNAMIC: {
                if (!(resolvable instanceof InvokeDynamicConstant.Indexes)) break;
                InvokeDynamicConstant.Indexes fromIndex = (InvokeDynamicConstant.Indexes)resolvable;
                return Resolution.resolveInvokeDynamicConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case DYNAMIC: {
                if (!(resolvable instanceof DynamicConstant.Indexes)) break;
                DynamicConstant.Indexes fromIndex = (DynamicConstant.Indexes)resolvable;
                return Resolution.resolveDynamicConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case METHODHANDLE: {
                if (!(resolvable instanceof MethodHandleConstant.Index)) break;
                MethodHandleConstant.Index fromIndex = (MethodHandleConstant.Index)resolvable;
                return Resolution.resolveMethodHandleConstant(fromIndex, this, thisIndex, accessingKlass);
            }
            case CLASS: {
                if (resolvable instanceof ClassConstant.Index) {
                    ClassConstant.Index fromIndex = (ClassConstant.Index)resolvable;
                    return Resolution.resolveClassConstant(fromIndex, this, thisIndex, accessingKlass);
                }
                if (!(resolvable instanceof ClassConstant.WithString)) break;
                ClassConstant.WithString fromString = (ClassConstant.WithString)resolvable;
                return Resolution.resolveClassConstant(fromString, this, thisIndex, accessingKlass);
            }
        }
        throw EspressoError.shouldNotReachHere("Unexpected CP entry: " + String.valueOf(resolvable));
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=ClassFormatError.class) EspressoException classFormatError(String message) {
        CompilerAsserts.neverPartOfCompilation();
        Meta meta = EspressoContext.get(null).getMeta();
        if (meta.java_lang_ClassFormatError == null) {
            throw EspressoError.fatal("ClassFormatError during early startup: ", message);
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, message);
    }

    public void patchAt(int index, Resolvable.ResolvedConstant resolvedConstant) {
        assert (resolvedConstant != null);
        assert (resolvedConstant.value() != null);
        this.resolvedConstants[index] = resolvedConstant;
    }
}

