/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.SignatureCallNode;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.options.OptionValues;

public interface NativeAccess {
    public @Pointer TruffleObject loadLibrary(Path var1);

    public @Pointer TruffleObject loadDefaultLibrary();

    public void unloadLibrary(@Pointer TruffleObject var1);

    default public @Pointer TruffleObject loadLibrary(List<Path> searchPaths, String shortName, boolean notFoundIsFatal) {
        for (Path path : searchPaths) {
            Path libPath = path.resolve(System.mapLibraryName(shortName));
            @Pointer TruffleObject library = this.loadLibrary(libPath.toAbsolutePath());
            if (library == null) continue;
            return library;
        }
        if (notFoundIsFatal) {
            throw EspressoError.shouldNotReachHere("Cannot load library: " + shortName + "\nSearch path: " + String.valueOf(searchPaths));
        }
        return null;
    }

    public @Pointer TruffleObject lookupSymbol(@Pointer TruffleObject var1, String var2);

    public @Pointer TruffleObject bindSymbol(@Pointer TruffleObject var1, NativeSignature var2);

    public Object getCallableSignature(NativeSignature var1, boolean var2);

    public boolean hasFallbackSymbols();

    public boolean isFallbackSymbol(TruffleObject var1);

    public NativeAccess getFallbackAccess();

    public Object callSignature(Object var1, @Pointer TruffleObject var2, Object ... var3) throws UnsupportedMessageException, UnsupportedTypeException, ArityException;

    public SignatureCallNode createSignatureCall(NativeSignature var1);

    default public @Pointer TruffleObject lookupAndBindSymbol(@Pointer TruffleObject library, String symbolName, NativeSignature nativeSignature) {
        return this.lookupAndBindSymbol(library, symbolName, nativeSignature, false, false);
    }

    default public @Pointer TruffleObject lookupAndBindSymbol(@Pointer TruffleObject library, String symbolName, NativeSignature nativeSignature, boolean allowFallback, boolean allowMissing) {
        @Pointer TruffleObject symbol = this.lookupSymbol(library, symbolName);
        if (symbol == null) {
            if (!allowMissing) {
                throw EspressoError.shouldNotReachHere("Failed to locate required symbol: " + symbolName);
            }
            return null;
        }
        if (!allowFallback && this.isFallbackSymbol(symbol)) {
            String message = "Unexpected fallback symbol: " + symbolName + "\nA likely explanation is that a core espresso library was expected to contain bitcode but it doesn't.\nCore JDK libraries with LLVM bitcode are currently only available on linux-amd64 and darwin-amd64.\nOn linux-aarch64 you could instead try to set `java.NativeBackend` to `nfi-dlmopen`.";
            message = EspressoOptions.RUNNING_ON_SVM ? message + "\nIn a native-image, if a single espresso context is used, it's recommended to use the `nfi-native` backend." : message + "\nOn other platforms, you can try to run your embedding of espresso as a native-image if a single espresso context is used.";
            throw EspressoError.shouldNotReachHere(message);
        }
        return this.bindSymbol(symbol, nativeSignature);
    }

    public @Buffer TruffleObject allocateMemory(long var1);

    public @Buffer TruffleObject reallocateMemory(@Pointer TruffleObject var1, long var2);

    public void freeMemory(@Pointer TruffleObject var1);

    public @Pointer TruffleObject createNativeClosure(TruffleObject var1, NativeSignature var2);

    public static NativeType kindToNativeType(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return NativeType.BOOLEAN;
            }
            case Byte: {
                return NativeType.BYTE;
            }
            case Short: {
                return NativeType.SHORT;
            }
            case Char: {
                return NativeType.CHAR;
            }
            case Int: {
                return NativeType.INT;
            }
            case Long: {
                return NativeType.LONG;
            }
            case Float: {
                return NativeType.FLOAT;
            }
            case Double: {
                return NativeType.DOUBLE;
            }
            case Void: {
                return NativeType.VOID;
            }
            case Object: {
                return NativeType.OBJECT;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("unexpected kind: " + String.valueOf((Object)kind));
    }

    default public void updateEspressoProperties(EspressoProperties.Builder builder, OptionValues options) {
    }

    public void prepareThread();

    public static interface Provider {
        public String id();

        public NativeAccess create(TruffleLanguage.Env var1);
    }
}

