/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.ffi.Pointer;

@ExportLibrary(value=InteropLibrary.class)
public final class RawPointer
implements TruffleObject {
    private final long rawPtr;
    private static final RawPointer NULL = new RawPointer(0L);

    public static @Pointer TruffleObject nullInstance() {
        return NULL;
    }

    public RawPointer(long rawPtr) {
        this.rawPtr = rawPtr;
    }

    public static @Pointer TruffleObject create(long ptr) {
        if (ptr == 0L) {
            return NULL;
        }
        return new RawPointer(ptr);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.rawPtr;
    }

    @ExportMessage
    boolean isNull() {
        return this.rawPtr == 0L;
    }
}

