/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.TruffleByteBuffer;
import com.oracle.truffle.espresso.ffi.nfi.NFINativeAccess;
import com.oracle.truffle.espresso.impl.EmptyKeysArray;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.substitutions.Collect;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;

public final class NFIIsolatedNativeAccess
extends NFINativeAccess {
    private final @Pointer TruffleObject edenLibrary;
    private final @Pointer TruffleObject malloc;
    private final @Pointer TruffleObject free;
    private final @Pointer TruffleObject realloc;
    private final @Pointer TruffleObject ctypeInit;
    private final @Pointer TruffleObject dlsym;
    private final DefaultLibrary defaultLibrary;

    NFIIsolatedNativeAccess(TruffleLanguage.Env env) {
        super(env);
        Path espressoLibraryPath = EspressoLanguage.getEspressoLibs(env);
        this.edenLibrary = this.loadLibrary(Collections.singletonList(espressoLibraryPath), "eden", true);
        this.malloc = this.lookupAndBindSymbol(this.edenLibrary, "malloc", NativeSignature.create(NativeType.POINTER, NativeType.LONG));
        this.realloc = this.lookupAndBindSymbol(this.edenLibrary, "realloc", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.LONG));
        this.free = this.lookupAndBindSymbol(this.edenLibrary, "free", NativeSignature.create(NativeType.VOID, NativeType.POINTER));
        this.dlsym = this.lookupAndBindSymbol(this.edenLibrary, "dlsym", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER));
        this.ctypeInit = this.lookupAndBindSymbol(this.edenLibrary, "eden_ctypeInit", NativeSignature.create(NativeType.VOID, new NativeType[0]));
        this.defaultLibrary = new DefaultLibrary(this.dlsym, this.rtldDefault());
    }

    private TruffleObject rtldDefault() {
        TruffleObject edenRtldDefault = this.lookupAndBindSymbol(this.edenLibrary, "eden_RTLD_DEFAULT", NativeSignature.create(NativeType.POINTER, new NativeType[0]));
        try {
            TruffleObject result = (TruffleObject)InteropLibrary.getUncached().execute((Object)edenRtldDefault, new Object[0]);
            assert (InteropLibrary.getUncached().isPointer((Object)result));
            return result;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    protected @Pointer TruffleObject loadLibrary0(Path libraryPath) {
        String nfiSource = String.format("load(RTLD_LAZY|RTLD_LOCAL|ISOLATED_NAMESPACE) '%s'", libraryPath);
        return this.loadLibraryHelper(nfiSource);
    }

    @Override
    public @Pointer TruffleObject loadDefaultLibrary() {
        return this.defaultLibrary;
    }

    @Override
    public @Buffer TruffleObject allocateMemory(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("negative buffer length: " + size);
        }
        try {
            @Pointer TruffleObject address = (TruffleObject)UNCACHED_INTEROP.execute((Object)this.malloc, new Object[]{size});
            if (InteropLibrary.getUncached().isNull((Object)address)) {
                return null;
            }
            return TruffleByteBuffer.wrap(address, Math.toIntExact(size));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    public void freeMemory(@Pointer TruffleObject buffer) {
        assert (InteropLibrary.getUncached().isPointer((Object)buffer));
        try {
            UNCACHED_INTEROP.execute((Object)this.free, new Object[]{buffer});
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    public @Buffer TruffleObject reallocateMemory(@Pointer TruffleObject buffer, long newSize) {
        if (newSize < 0L) {
            throw new IllegalArgumentException("negative buffer length: " + newSize);
        }
        assert (InteropLibrary.getUncached().isPointer((Object)buffer));
        try {
            @Pointer TruffleObject address = (TruffleObject)UNCACHED_INTEROP.execute((Object)this.realloc, new Object[]{buffer, newSize});
            if (InteropLibrary.getUncached().isNull((Object)address)) {
                return null;
            }
            return TruffleByteBuffer.wrap(address, Math.toIntExact(newSize));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    public void prepareThread() {
        try {
            UNCACHED_INTEROP.execute((Object)this.ctypeInit, new Object[0]);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class DefaultLibrary
    implements TruffleObject {
        final @Pointer TruffleObject dlsym;
        final @Pointer TruffleObject rtldDefault;

        DefaultLibrary(@Pointer TruffleObject dlsym, @Pointer TruffleObject rtldDefault) {
            this.dlsym = Objects.requireNonNull(dlsym);
            this.rtldDefault = Objects.requireNonNull(rtldDefault);
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return EmptyKeysArray.INSTANCE;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object readMember(String member, @CachedLibrary(value="this.dlsym") InteropLibrary interop, @CachedLibrary(limit="2") InteropLibrary isNullInterop, @Cached BranchProfile error) throws UnknownIdentifierException {
            try {
                Object result = interop.execute((Object)this.dlsym, new Object[]{this.rtldDefault, TruffleByteBuffer.allocateDirectStringUTF8(member)});
                if (isNullInterop.isNull(result)) {
                    error.enter();
                    throw UnknownIdentifierException.create((String)member);
                }
                return result;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects) {
            return "nfi-dlmopen default library";
        }
    }

    @Collect(value={NativeAccess.class})
    public static final class Provider
    implements NativeAccess.Provider {
        public static final String ID = "nfi-dlmopen";

        @Override
        public String id() {
            return ID;
        }

        @Override
        public NativeAccess create(TruffleLanguage.Env env) {
            return new NFIIsolatedNativeAccess(env);
        }
    }
}

