/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.SignatureCallNode;
import com.oracle.truffle.espresso.ffi.nfi.NFINativeAccess;
import com.oracle.truffle.espresso.ffi.nfi.NFISulongSignatureCallNode;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import com.oracle.truffle.espresso.substitutions.Collect;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionValues;

public final class NFISulongNativeAccess
extends NFINativeAccess {
    private NFINativeAccess fallback;

    @Override
    protected String nfiStringSignature(NativeSignature nativeSignature, boolean forFallbackSymbol) {
        String res = super.nfiStringSignature(nativeSignature, forFallbackSymbol);
        if (!forFallbackSymbol) {
            return "with llvm " + res;
        }
        return res;
    }

    @Override
    public boolean hasFallbackSymbols() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isSulongSymbolClass(Object symbolClass) {
        return "LLVMLanguage".equals(((Class)symbolClass).getSimpleName());
    }

    @Override
    public boolean isFallbackSymbol(TruffleObject symbol) {
        return NFISulongNativeAccess.isFallbackSymbol(symbol, InteropLibrary.getUncached());
    }

    @Override
    public NativeAccess getFallbackAccess() {
        if (this.fallback == null) {
            this.fallback = new NFINativeAccess(this.env);
        }
        return this.fallback;
    }

    static boolean isFallbackSymbol(TruffleObject symbol, InteropLibrary interop) {
        Object symbolClass = NFISulongNativeAccess.getSymbolClass(symbol, interop);
        return symbolClass == null || !NFISulongNativeAccess.isSulongSymbolClass(symbolClass);
    }

    private static Object getSymbolClass(TruffleObject symbol, InteropLibrary interop) {
        if (!interop.hasLanguage((Object)symbol)) {
            return null;
        }
        try {
            return interop.getLanguage((Object)symbol);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    public SignatureCallNode createSignatureCall(NativeSignature nativeSignature) {
        return NFISulongSignatureCallNode.create(this, nativeSignature);
    }

    NFISulongNativeAccess(TruffleLanguage.Env env) {
        super(env);
    }

    @Override
    protected @Pointer TruffleObject loadLibrary0(Path libraryPath) {
        String nfiSource = String.format("with llvm load(RTLD_LAZY|RTLD_LOCAL) '%s'", libraryPath);
        return this.loadLibraryHelper(nfiSource);
    }

    @Override
    public @Pointer TruffleObject loadDefaultLibrary() {
        return null;
    }

    static String getJavaVersion(Path javaHome) {
        Path releaseFile = javaHome.resolve("release");
        if (!Files.isRegularFile(releaseFile, new LinkOption[0])) {
            return null;
        }
        try {
            for (String line : Files.readAllLines(releaseFile)) {
                if (!line.startsWith("JAVA_VERSION=")) continue;
                String version = line.substring("JAVA_VERSION=".length()).trim();
                if (version.length() > 2 && version.startsWith("\"") && version.endsWith("\"")) {
                    version = version.substring(1, version.length() - 1);
                }
                return version;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Path legacyGraalvmllvmBootLibraryPath(String javaVersion, Path llvmRoot) {
        List<Path> sortedPaths;
        Path llvmDefault = llvmRoot.resolve("default");
        if (!Files.exists(llvmDefault, new LinkOption[0])) {
            LOGGER.warning(() -> "espresso-llvm (default) component not found. Install it, if available for your platform.");
        }
        String llvmDefaultVersion = NFISulongNativeAccess.getJavaVersion(llvmDefault);
        LOGGER.fine(() -> "Check " + String.valueOf(llvmDefault) + " with Java version: " + llvmDefaultVersion);
        if (javaVersion.equals(llvmDefaultVersion)) {
            return llvmDefault;
        }
        if (!Files.exists(llvmRoot, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> stream = Files.list(llvmRoot);){
            sortedPaths = stream.filter(f -> !llvmDefault.equals(f) && Files.isDirectory(f, new LinkOption[0])).sorted().toList();
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e.getMessage(), e);
        }
        for (Path llvmImpl : sortedPaths) {
            String llvmImplVersion = NFISulongNativeAccess.getJavaVersion(llvmImpl);
            LOGGER.fine(() -> "Checking " + String.valueOf(llvmImpl) + " with Java version: " + llvmImplVersion);
            if (!javaVersion.equals(llvmImplVersion)) continue;
            return llvmImpl;
        }
        return null;
    }

    @Override
    public void updateEspressoProperties(EspressoProperties.Builder builder, OptionValues options) {
        if (options.hasBeenSet(EspressoOptions.BootLibraryPath)) {
            LOGGER.info("--java.BootLibraryPath was set by the user, skipping override for nfi-llvm");
        } else {
            String targetJavaVersion = NFISulongNativeAccess.getJavaVersion(builder.javaHome());
            if (targetJavaVersion == null) {
                LOGGER.warning("Cannot determine the Java version for '" + String.valueOf(builder.javaHome()) + "'. The default --java.BootLibraryPath will be used.");
            } else {
                Path espressoHome = (Path)HomeFinder.getInstance().getLanguageHomes().get("java");
                if (espressoHome != null && Files.isDirectory(espressoHome, new LinkOption[0])) {
                    Path llvmRoot = espressoHome.resolve("lib").resolve("llvm");
                    Path llvmBootLibraryPath = NFISulongNativeAccess.legacyGraalvmllvmBootLibraryPath(targetJavaVersion, llvmRoot);
                    if (llvmBootLibraryPath == null) {
                        LOGGER.warning("Couldn't find libraries with LLVM bitcode for Java version '" + targetJavaVersion + "'. The default --java.BootLibraryPath will be used.");
                    } else {
                        builder.bootLibraryPath(Collections.singletonList(llvmBootLibraryPath));
                    }
                } else {
                    Path llvmRoot = builder.javaHome().resolve("lib").resolve("llvm");
                    if (Files.isDirectory(llvmRoot, new LinkOption[0])) {
                        builder.bootLibraryPath(Collections.singletonList(llvmRoot));
                    } else {
                        LOGGER.warning("Couldn't find libraries with LLVM bitcode. The default --java.BootLibraryPath will be used.");
                    }
                }
            }
        }
        if (options.hasBeenSet(EspressoOptions.JVMLibraryPath)) {
            LOGGER.info("--java.JVMLibraryPath was set by the user, skipping override for nfi-llvm");
        } else {
            builder.jvmLibraryPath(Collections.singletonList(builder.espressoLibs()));
        }
    }

    @Collect(value={NativeAccess.class})
    public static final class Provider
    implements NativeAccess.Provider {
        public static final String ID = "nfi-llvm";

        @Override
        public String id() {
            return ID;
        }

        @Override
        public NativeAccess create(TruffleLanguage.Env env) {
            return new NFISulongNativeAccess(env);
        }
    }
}

