/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.SignatureCallNode;
import com.oracle.truffle.espresso.ffi.nfi.NFISulongNativeAccess;
import com.oracle.truffle.espresso.ffi.nfi.NFISulongSignatureCallNodeGen;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public abstract class NFISulongSignatureCallNode
extends SignatureCallNode {
    protected static final int LIMIT = 2;
    protected final NativeSignature signature;
    private final NFISulongNativeAccess access;

    protected NFISulongSignatureCallNode(NFISulongNativeAccess access, NativeSignature signature) {
        this.access = access;
        this.signature = signature;
    }

    public static SignatureCallNode create(NFISulongNativeAccess access, NativeSignature signature) {
        return NFISulongSignatureCallNodeGen.create(access, signature);
    }

    protected abstract Object execute(Object var1, Object ... var2) throws ArityException, UnsupportedTypeException, UnsupportedMessageException;

    @Override
    public Object call(Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        return this.execute(functionPointer, args);
    }

    protected static boolean isFallbackSymbol(Object symbol, InteropLibrary interop) {
        return NFISulongNativeAccess.isFallbackSymbol((TruffleObject)symbol, interop);
    }

    protected Object getCallableSignature(boolean forFallbackSymbol) {
        return this.access.getCallableSignature(this.signature, forFallbackSymbol);
    }

    @Specialization(limit="LIMIT", guards={"isFallbackSymbol(functionPointer, symbolInterop) == isFallbackSymbol"})
    static Object doCached(Object functionPointer, Object[] args, @CachedLibrary(value="functionPointer") InteropLibrary symbolInterop, @Cached(value="isFallbackSymbol(functionPointer, symbolInterop)") boolean isFallbackSymbol, @Cached(value="getCallableSignature(isFallbackSymbol)") Object callableSignature, @CachedLibrary(value="signature") SignatureLibrary signatureLibrary) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        return signatureLibrary.call(callableSignature, functionPointer, args);
    }

    @Specialization
    Object doUncached(Object functionPointer, Object[] args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        TruffleObject target = (TruffleObject)functionPointer;
        return this.access.callSignature(this.getCallableSignature(this.access.isFallbackSymbol(target)), target, args);
    }
}

