/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.ModifiedUtf8;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import sun.misc.Unsafe;

public final class NativeUtils {
    private static final Unsafe UNSAFE = UnsafeAccess.get();
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long CAPACITY_FIELD_OFFSET;

    private static long getBufferFieldOffset(String name) throws NoSuchFieldException {
        return UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField(name));
    }

    public static ByteBuffer directByteBuffer(@Pointer TruffleObject addressPtr, long size, JavaKind kind) {
        return NativeUtils.directByteBuffer(addressPtr, Math.multiplyExact(size, kind.getByteCount()));
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer directByteBuffer(@Pointer TruffleObject addressPtr, long capacity) {
        return NativeUtils.directByteBuffer(NativeUtils.interopAsPointer(addressPtr), capacity);
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer directByteBuffer(long address, long longCapacity) {
        int capacity = Math.toIntExact(longCapacity);
        ByteBuffer buffer = null;
        try {
            buffer = (ByteBuffer)UNSAFE.allocateInstance(DIRECT_BYTE_BUFFER_CLASS);
        }
        catch (InstantiationException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
        UNSAFE.putLong(buffer, ADDRESS_FIELD_OFFSET, address);
        UNSAFE.putInt(buffer, CAPACITY_FIELD_OFFSET, capacity);
        buffer.clear();
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    @CompilerDirectives.TruffleBoundary
    public static long interopAsPointer(@Pointer TruffleObject interopPtr) {
        try {
            return InteropLibrary.getUncached().asPointer((Object)interopPtr);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    public static String interopPointerToString(@Pointer TruffleObject interopPtr) {
        return NativeUtils.fromUTF8Ptr(NativeUtils.interopAsPointer(interopPtr));
    }

    public static void writeToIntPointer(TruffleObject pointer, int value) {
        NativeUtils.writeToIntPointer(InteropLibrary.getUncached(), pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static void writeToIntPointer(InteropLibrary library, TruffleObject pointer, int value) {
        if (library.isNull((Object)pointer)) {
            throw new NullPointerException();
        }
        IntBuffer resultPointer = NativeUtils.directByteBuffer(pointer, 1L, JavaKind.Int).asIntBuffer();
        resultPointer.put(value);
    }

    public static void writeToLongPointer(TruffleObject pointer, long value) {
        NativeUtils.writeToLongPointer(InteropLibrary.getUncached(), pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static void writeToLongPointer(InteropLibrary library, TruffleObject pointer, long value) {
        if (library.isNull((Object)pointer)) {
            throw new NullPointerException();
        }
        LongBuffer resultPointer = NativeUtils.directByteBuffer(pointer, 1L, JavaKind.Long).asLongBuffer();
        resultPointer.put(value);
    }

    public static void writeToPointerPointer(TruffleObject pointer, TruffleObject value) {
        NativeUtils.writeToPointerPointer(InteropLibrary.getUncached(), pointer, value);
    }

    public static void writeToPointerPointer(InteropLibrary library, TruffleObject pointer, TruffleObject value) {
        NativeUtils.writeToLongPointer(library, pointer, NativeUtils.interopAsPointer(value));
    }

    public static TruffleObject dereferencePointerPointer(TruffleObject pointer) {
        return NativeUtils.dereferencePointerPointer(InteropLibrary.getUncached(), pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleObject dereferencePointerPointer(InteropLibrary library, TruffleObject pointer) {
        if (library.isNull((Object)pointer)) {
            throw new NullPointerException();
        }
        LongBuffer buffer = NativeUtils.directByteBuffer(pointer, 1L, JavaKind.Long).asLongBuffer();
        return RawPointer.create(buffer.get());
    }

    @CompilerDirectives.TruffleBoundary
    public static long byteBufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        return UNSAFE.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    public static @Pointer TruffleObject byteBufferPointer(ByteBuffer byteBuffer) {
        return new RawPointer(NativeUtils.byteBufferAddress(byteBuffer));
    }

    public static String fromUTF8Ptr(@Pointer TruffleObject buffPtr) {
        return NativeUtils.fromUTF8Ptr(NativeUtils.interopAsPointer(buffPtr));
    }

    @CompilerDirectives.TruffleBoundary
    public static String fromUTF8Ptr(long rawBytesPtr) {
        if (rawBytesPtr == 0L) {
            return null;
        }
        ByteBuffer buf = NativeUtils.directByteBuffer(rawBytesPtr, Integer.MAX_VALUE);
        int utfLen = 0;
        while (buf.get() != 0) {
            ++utfLen;
        }
        byte[] bytes = new byte[utfLen];
        buf.clear();
        buf.get(bytes);
        try {
            return ModifiedUtf8.toJavaString(bytes);
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    static {
        try {
            ADDRESS_FIELD_OFFSET = NativeUtils.getBufferFieldOffset("address");
            CAPACITY_FIELD_OFFSET = NativeUtils.getBufferFieldOffset("capacity");
            DIRECT_BYTE_BUFFER_CLASS = Class.forName("java.nio.DirectByteBuffer");
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

