/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ClasspathFile;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.perf.DebugCloseable;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.classfile.perf.DebugTimer;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class BootClassRegistry
extends ClassRegistry {
    static final DebugCounter loadKlassCount = DebugCounter.create("BCL loadKlassCount");
    static final DebugCounter loadKlassCacheHits = DebugCounter.create("BCL loadKlassCacheHits");
    private static final DebugTimer BOOT_KLASS_READ = DebugTimer.create("boot klass read");
    private final Map<String, String> packageMap = new ConcurrentHashMap<String, String>();

    @Override
    protected void loadKlassCountInc() {
        loadKlassCount.inc();
    }

    @Override
    protected void loadKlassCacheHitsInc() {
        loadKlassCacheHits.inc();
    }

    public BootClassRegistry(long loaderID) {
        super(loaderID);
    }

    @Override
    public Klass loadKlassImpl(EspressoContext context, Symbol<Symbol.Type> type) throws EspressoClassLoadingException {
        ClasspathFile classpathFile;
        ClassLoadingEnv env = context.getClassLoadingEnv();
        if (Types.isPrimitive(type)) {
            return null;
        }
        try (DebugCloseable scope = BOOT_KLASS_READ.scope(env.getTimers());){
            classpathFile = context.getBootClasspath().readClassFile(type);
            if (classpathFile == null) {
                Klass klass = null;
                return klass;
            }
        }
        ObjectKlass result = this.defineKlass(context, type, classpathFile.contents);
        context.getRegistries().recordConstraint(type, result, this.getClassLoader());
        this.packageMap.put(result.getRuntimePackage().toString(), classpathFile.classpathEntry.path());
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String getPackagePath(String pkgName) {
        String result = this.packageMap.get(pkgName);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String[] getPackages() {
        return this.packageMap.keySet().toArray(new String[0]);
    }

    @Override
    public @JavaType(value=ClassLoader.class) StaticObject getClassLoader() {
        return StaticObject.NULL;
    }
}

