/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.classfile.JavaVersion;
import com.oracle.truffle.espresso.classfile.ParsingContext;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.perf.TimerCollection;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.LanguageAccess;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;

public class ClassLoadingEnv
implements LanguageAccess {
    private final AtomicLong klassIdProvider = new AtomicLong();
    private final AtomicLong loaderIdProvider = new AtomicLong();
    private final EspressoLanguage language;
    private final TruffleLogger logger;
    private final TimerCollection timers;
    private final ParsingContext parsingContext;
    @CompilerDirectives.CompilationFinal
    private Meta meta;

    public ClassLoadingEnv(EspressoLanguage language, TruffleLogger logger, TimerCollection timers) {
        this.language = language;
        this.logger = logger;
        this.timers = timers;
        this.parsingContext = ClassLoadingEnv.createParsingContext(this);
    }

    public ParsingContext getParsingContext() {
        return this.parsingContext;
    }

    @Override
    public EspressoLanguage getLanguage() {
        return this.language;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public TruffleLogger getLogger() {
        return this.logger;
    }

    public TimerCollection getTimers() {
        return this.timers;
    }

    private static boolean shouldCacheClass(ClassRegistry.ClassDefinitionInfo info) {
        return !info.isAnonymousClass() && !info.isHidden();
    }

    public boolean shouldCacheClass(ClassRegistry.ClassDefinitionInfo info, StaticObject loader) {
        return ClassLoadingEnv.shouldCacheClass(info) && (this.loaderIsBootOrPlatform(loader) || this.loaderIsAppLoader(loader));
    }

    public boolean loaderIsBootOrPlatform(StaticObject loader) {
        return StaticObject.isNull(loader) || this.language.getJavaVersion().java9OrLater() && this.meta.jdk_internal_loader_ClassLoaders$PlatformClassLoader.isAssignableFrom(loader.getKlass());
    }

    public boolean loaderIsAppLoader(StaticObject loader) {
        return !StaticObject.isNull(loader) && this.meta.jdk_internal_loader_ClassLoaders$AppClassLoader.isAssignableFrom(loader.getKlass());
    }

    public long getNewKlassId() {
        long id = this.klassIdProvider.getAndIncrement();
        if (id < 0L) {
            throw EspressoError.shouldNotReachHere("Exhausted klass IDs");
        }
        return id;
    }

    public long getNewLoaderId() {
        long id = this.loaderIdProvider.getAndIncrement();
        if (id < 0L) {
            throw EspressoError.shouldNotReachHere("Exhausted loader IDs");
        }
        return id;
    }

    public boolean isStrictComplianceMode() {
        return this.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT;
    }

    private static ParsingContext createParsingContext(final ClassLoadingEnv env) {
        return new ParsingContext(){
            final ParsingContext.Logger truffleEnvLogger;
            {
                this.truffleEnvLogger = new ParsingContext.Logger(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void log(String message) {
                        env.getLogger().warning(message);
                    }

                    @Override
                    public void log(Supplier<String> messageSupplier) {
                        env.getLogger().warning(messageSupplier);
                    }

                    @Override
                    public void log(String message, Throwable throwable) {
                        env.getLogger().log(Level.SEVERE, message, throwable);
                    }
                };
            }

            @Override
            public JavaVersion getJavaVersion() {
                return env.getJavaVersion();
            }

            @Override
            public boolean isStrictJavaCompliance() {
                return env.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT;
            }

            @Override
            public TimerCollection getTimers() {
                return env.getTimers();
            }

            @Override
            public boolean isPreviewEnabled() {
                return env.isPreviewEnabled();
            }

            @Override
            public ParsingContext.Logger getLogger() {
                return this.truffleEnvLogger;
            }

            @Override
            public Symbol<Symbol.Name> getOrCreateName(ByteSequence byteSequence) {
                return env.getNames().getOrCreate(byteSequence);
            }

            @Override
            public Symbol<Symbol.Type> getOrCreateTypeFromName(ByteSequence byteSequence) {
                return env.getTypes().getOrCreate(Types.nameToType(byteSequence));
            }

            @Override
            public Utf8Constant getOrCreateUtf8Constant(ByteSequence bytes) {
                return env.getLanguage().getUtf8ConstantTable().getOrCreate(bytes);
            }

            @Override
            public long getNewKlassId() {
                return env.getNewKlassId();
            }
        };
    }
}

