/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.impl.BootClassRegistry;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.GuestClassRegistry;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LoadingConstraints;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.jdwp.api.ModuleRef;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.redefinition.DefineKlassListener;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassRegistries {
    private ModuleTable.ModuleEntry javaBaseModule;
    private ModuleTable.ModuleEntry polyglotAPIModule;
    private final ClassRegistry bootClassRegistry;
    private final LoadingConstraints constraints;
    private final EspressoContext context;
    private List<Klass> fixupModuleList = new ArrayList<Klass>();
    private final Set<StaticObject> weakClassLoaderSet = Collections.newSetFromMap(new WeakHashMap());
    private int totalClassLoadersSet = 0;
    private DefineKlassListener defineKlassListener;

    public ClassRegistries(EspressoContext context) {
        this.context = context;
        this.bootClassRegistry = new BootClassRegistry(context.getClassLoadingEnv().getNewLoaderId());
        this.constraints = new LoadingConstraints(context);
    }

    public void initJavaBaseModule() {
        this.javaBaseModule = (ModuleTable.ModuleEntry)this.bootClassRegistry.modules().createAndAddEntry(Symbol.Name.java_base, this.bootClassRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassRegistry getClassRegistry(@JavaType(value=ClassLoader.class) StaticObject classLoader) {
        if (StaticObject.isNull(classLoader)) {
            return this.bootClassRegistry;
        }
        ClassRegistry classRegistry = (ClassRegistry)this.context.getMeta().HIDDEN_CLASS_LOADER_REGISTRY.getHiddenObject(classLoader, true);
        if (classRegistry == null) {
            Set<StaticObject> set = this.weakClassLoaderSet;
            synchronized (set) {
                classRegistry = (ClassRegistry)this.context.getMeta().HIDDEN_CLASS_LOADER_REGISTRY.getHiddenObject(classLoader, true);
                if (classRegistry == null) {
                    classRegistry = this.registerRegistry(classLoader);
                }
            }
        }
        assert (classRegistry != null);
        return classRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    private ClassRegistry registerRegistry(@JavaType(value=ClassLoader.class) StaticObject classLoader) {
        assert (Thread.holdsLock(this.weakClassLoaderSet));
        GuestClassRegistry classRegistry = new GuestClassRegistry(this.context.getClassLoadingEnv(), classLoader);
        this.context.getMeta().HIDDEN_CLASS_LOADER_REGISTRY.setHiddenObject(classLoader, classRegistry, true);
        this.weakClassLoaderSet.add(classLoader);
        ++this.totalClassLoadersSet;
        int size = this.weakClassLoaderSet.size();
        if (this.totalClassLoadersSet > size) {
            this.constraints.purge();
            this.totalClassLoadersSet = size;
        }
        return classRegistry;
    }

    public ModuleTable.ModuleEntry getJavaBaseModule() {
        return this.javaBaseModule;
    }

    public ModuleTable.ModuleEntry getPolyglotAPIModule() {
        if (this.polyglotAPIModule == null) {
            ModuleRef[] allModuleRefs;
            for (ModuleRef module : allModuleRefs = this.getAllModuleRefs()) {
                if (!"espresso.polyglot".equals(module.jdwpName())) continue;
                this.polyglotAPIModule = (ModuleTable.ModuleEntry)module;
                break;
            }
        }
        return this.polyglotAPIModule;
    }

    public boolean javaBaseDefined() {
        return this.javaBaseModule != null && !StaticObject.isNull(this.javaBaseModule.module());
    }

    @CompilerDirectives.TruffleBoundary
    public Klass findLoadedClass(Symbol<Symbol.Type> type, @JavaType(value=ClassLoader.class) StaticObject classLoader) {
        assert (classLoader != null) : "use StaticObject.NULL for BCL";
        if (Types.isArray(type)) {
            Klass elemental = this.findLoadedClass(this.context.getTypes().getElementalType(type), classLoader);
            if (elemental == null) {
                return null;
            }
            return elemental.getArrayClass(Types.getArrayDimensions(type));
        }
        ClassRegistry registry = this.getClassRegistry(classLoader);
        assert (registry != null);
        return registry.findLoadedKlass(this.context.getClassLoadingEnv(), type);
    }

    @CompilerDirectives.TruffleBoundary
    public List<Klass> getLoadedClassesByLoader(StaticObject classLoader) {
        if (classLoader == StaticObject.NULL) {
            ArrayList<Klass> result = new ArrayList<Klass>(this.bootClassRegistry.classes.size());
            for (RegistryEntry value : this.bootClassRegistry.classes.values()) {
                result.add(value.klass());
            }
            return result;
        }
        ClassRegistry classRegistry = this.getClassRegistry(classLoader);
        return classRegistry == null ? Collections.emptyList() : classRegistry.getLoadedKlasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Klass[] findLoadedClassAny(Symbol<Symbol.Type> type) {
        ArrayList<Klass> klasses = new ArrayList<Klass>();
        if (this.bootClassRegistry.classes.containsKey(type)) {
            klasses.add(this.bootClassRegistry.classes.get(type).klass());
            return klasses.toArray(Klass.EMPTY_ARRAY);
        }
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject classLoader : this.weakClassLoaderSet) {
                ClassRegistry registry = this.getClassRegistry(classLoader);
                if (registry == null || registry.classes == null || !registry.classes.containsKey(type)) continue;
                klasses.add(registry.classes.get(type).klass());
            }
        }
        return klasses.toArray(Klass.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Klass[] getAllLoadedClasses() {
        ArrayList<Klass> list = new ArrayList<Klass>();
        for (RegistryEntry entry : this.bootClassRegistry.classes.values()) {
            list.add(entry.klass());
        }
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject classLoader : this.weakClassLoaderSet) {
                for (RegistryEntry entry : this.getClassRegistry((StaticObject)classLoader).classes.values()) {
                    list.add(entry.klass());
                }
            }
        }
        return list.toArray(Klass.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleRef[] getAllModuleRefs() {
        ArrayList list = new ArrayList();
        list.addAll(this.bootClassRegistry.modules().values());
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject classLoader : this.weakClassLoaderSet) {
                list.addAll(this.getClassRegistry(classLoader).modules().values());
            }
        }
        return list.toArray(ModuleRef.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleTable.ModuleEntry findUniqueModule(Symbol<Symbol.Name> name) {
        ModuleTable.ModuleEntry result = (ModuleTable.ModuleEntry)this.bootClassRegistry.modules().lookup(name);
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject classLoader : this.weakClassLoaderSet) {
                ModuleTable.ModuleEntry newResult = (ModuleTable.ModuleEntry)this.getClassRegistry(classLoader).modules().lookup(name);
                if (newResult == null) continue;
                if (result == null) {
                    result = newResult;
                    continue;
                }
                throw EspressoError.shouldNotReachHere("Found more than one module named " + String.valueOf(name));
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public Klass loadKlass(Symbol<Symbol.Type> type, @JavaType(value=ClassLoader.class) StaticObject classLoader, StaticObject protectionDomain) throws EspressoClassLoadingException {
        assert (classLoader != null) : "use StaticObject.NULL for BCL";
        if (Types.isArray(type)) {
            Klass elemental = this.loadKlass(this.context.getTypes().getElementalType(type), classLoader, protectionDomain);
            if (elemental == null) {
                return null;
            }
            return elemental.getArrayClass(Types.getArrayDimensions(type));
        }
        ClassRegistry registry = this.getClassRegistry(classLoader);
        return registry.loadKlass(this.context, type, protectionDomain);
    }

    @CompilerDirectives.TruffleBoundary
    public ObjectKlass defineKlass(Symbol<Symbol.Type> type, byte[] bytes, StaticObject classLoader, ClassRegistry.ClassDefinitionInfo info) throws EspressoClassLoadingException {
        assert (classLoader != null);
        ClassRegistry registry = this.getClassRegistry(classLoader);
        return registry.defineKlass(this.context, type, bytes, info);
    }

    public BootClassRegistry getBootClassRegistry() {
        return (BootClassRegistry)this.bootClassRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    public void checkLoadingConstraint(Symbol<Symbol.Type> type, StaticObject loader1, StaticObject loader2) {
        Symbol<Symbol.Type> toCheck = this.context.getTypes().getElementalType(type);
        if (!Types.isPrimitive(toCheck) && loader1 != loader2) {
            this.constraints.checkConstraint(toCheck, loader1, loader2);
        }
    }

    void recordConstraint(Symbol<Symbol.Type> type, Klass klass, StaticObject loader) {
        assert (!Types.isArray(type));
        if (!Types.isPrimitive(type)) {
            this.constraints.recordConstraint(type, klass, loader);
        }
    }

    void removeUnloadedKlassConstraint(Klass klass, Symbol<Symbol.Type> type) {
        assert (klass.isInstanceClass());
        this.constraints.removeUnloadedKlassConstraint(klass, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public long getLoadedClassesCount() {
        long result = this.bootClassRegistry.classes.size();
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject classLoader : this.weakClassLoaderSet) {
                result += (long)this.getClassRegistry((StaticObject)classLoader).classes.size();
            }
        }
        assert (result >= 0L);
        return result;
    }

    public void addToFixupList(Klass k) {
        this.fixupModuleList.add(k);
    }

    public void processFixupList(StaticObject javaBase) {
        assert (StaticObject.notNull(javaBase));
        for (PrimitiveKlass k : this.context.getMeta().PRIMITIVE_KLASSES) {
            this.context.getMeta().java_lang_Class_module.setObject(k.initializeEspressoClass(), javaBase);
        }
        for (Klass k : this.fixupModuleList) {
            this.context.getMeta().java_lang_Class_module.setObject(k.initializeEspressoClass(), javaBase);
        }
        this.fixupModuleList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] aliveLoaders() {
        long[] loaders = new long[this.weakClassLoaderSet.size() + 1];
        loaders[0] = this.context.getBootClassLoaderID();
        int i = 1;
        Set<StaticObject> set = this.weakClassLoaderSet;
        synchronized (set) {
            for (StaticObject loader : this.weakClassLoaderSet) {
                if (loader == null) continue;
                loaders[i++] = this.getClassRegistry(loader).getLoaderID();
            }
        }
        if (i < loaders.length) {
            loaders[i++] = -1L;
        }
        return loaders;
    }

    public void registerListener(DefineKlassListener listener) {
        this.defineKlassListener = listener;
    }

    @CompilerDirectives.TruffleBoundary
    public void onKlassDefined(ObjectKlass klass) {
        if (this.defineKlassListener != null) {
            this.defineKlassListener.onKlassDefined(klass);
        }
    }

    static class RegistryEntry {
        private final Klass klass;
        private volatile Set<StaticObject> domains = null;

        RegistryEntry(Klass k) {
            this.klass = k;
        }

        public Klass klass() {
            return this.klass;
        }

        void checkPackageAccess(Meta meta, StaticObject classLoader, StaticObject protectionDomain) {
            CompilerAsserts.neverPartOfCompilation();
            if (StaticObject.isNull(protectionDomain)) {
                return;
            }
            Set<StaticObject> cachedDomains = this.getCachedDomains();
            if (cachedDomains.contains(protectionDomain)) {
                return;
            }
            meta.java_lang_ClassLoader_checkPackageAccess.invokeDirectSpecial(classLoader, this.klass.mirror(), protectionDomain);
            cachedDomains.add(protectionDomain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<StaticObject> getCachedDomains() {
            if (this.domains == null) {
                RegistryEntry registryEntry = this;
                synchronized (registryEntry) {
                    if (this.domains == null) {
                        this.domains = Collections.newSetFromMap(new ConcurrentHashMap(2));
                    }
                }
            }
            return this.domains;
        }
    }
}

