/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class EspressoClassLoadingException
extends Exception {
    private static final long serialVersionUID = 1598679948708713831L;

    public static ClassCircularityError classCircularityError() throws ClassCircularityError {
        CompilerDirectives.transferToInterpreter();
        throw new ClassCircularityError("Class circularity detected");
    }

    public static IncompatibleClassChangeError incompatibleClassChangeError(String msg) throws IncompatibleClassChangeError {
        CompilerDirectives.transferToInterpreter();
        throw new IncompatibleClassChangeError(msg);
    }

    public static SecurityException securityException(String msg) throws SecurityException {
        CompilerDirectives.transferToInterpreter();
        throw new SecurityException(msg);
    }

    public static ClassDefNotFoundError classDefNotFoundError(String msg) throws ClassDefNotFoundError {
        CompilerDirectives.transferToInterpreter();
        throw new ClassDefNotFoundError(msg);
    }

    public static LinkageError linkageError(String msg) throws LinkageError {
        CompilerDirectives.transferToInterpreter();
        throw new LinkageError(msg);
    }

    public static IllegalAccessError illegalAccessError(String msg) throws IllegalAccessError {
        CompilerDirectives.transferToInterpreter();
        throw new IllegalAccessError(msg);
    }

    public static EspressoException wrapClassNotFoundGuestException(ClassLoadingEnv env, EspressoException e) {
        Meta meta = env.getMeta();
        if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
            StaticObject ncdfe = Meta.initException(meta.java_lang_NoClassDefFoundError);
            meta.java_lang_Throwable_cause.set(ncdfe, e.getGuestException());
            throw meta.throwException(ncdfe);
        }
        throw e;
    }

    private EspressoClassLoadingException(String msg) {
        super(msg);
    }

    public abstract EspressoException asGuestException(Meta var1);

    public static final class ClassCircularityError
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = 2598679948708713801L;

        private ClassCircularityError(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCircularityError, this.getMessage());
        }
    }

    public static final class IncompatibleClassChangeError
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = -412429500300133184L;

        private IncompatibleClassChangeError(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, this.getMessage());
        }
    }

    public static final class SecurityException
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = -4134684427619639549L;

        private SecurityException(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_SecurityException, this.getMessage());
        }
    }

    public static final class ClassDefNotFoundError
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = 1820085678127928882L;

        private ClassDefNotFoundError(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, this.getMessage());
        }
    }

    public static final class LinkageError
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = 1820087778127928882L;

        private LinkageError(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_LinkageError, this.getMessage());
        }
    }

    public static final class IllegalAccessError
    extends EspressoClassLoadingException {
        private static final long serialVersionUID = 1820087878127928882L;

        private IllegalAccessError(String msg) {
            super(msg);
        }

        @Override
        public EspressoException asGuestException(Meta meta) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, this.getMessage());
        }
    }
}

