/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.constantpool.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.LinkedKlassFieldLayout;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.RedefineAddedEnumField;
import com.oracle.truffle.espresso.impl.RedefineAddedField;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class ExtensionFieldsMetadata {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Field[] addedInstanceFields = Field.EMPTY_ARRAY;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Field[] addedStaticFields = Field.EMPTY_ARRAY;

    ExtensionFieldsMetadata() {
    }

    synchronized void addNewStaticFields(ObjectKlass.KlassVersion holder, List<ParserField> newFields, RuntimeConstantPool pool, Map<ParserField, Field> compatibleFields, ClassRedefinition classRedefinition) {
        CompilerAsserts.neverPartOfCompilation();
        if (newFields.isEmpty()) {
            return;
        }
        List<Field> toAdd = ExtensionFieldsMetadata.initNewFields(holder, newFields, pool, compatibleFields, classRedefinition);
        int nextIndex = this.addedStaticFields.length;
        this.addedStaticFields = Arrays.copyOf(this.addedStaticFields, this.addedStaticFields.length + toAdd.size());
        for (Field field : toAdd) {
            this.addedStaticFields[nextIndex++] = field;
        }
    }

    synchronized void addNewInstanceFields(ObjectKlass.KlassVersion holder, List<ParserField> newFields, RuntimeConstantPool pool, Map<ParserField, Field> compatibleFields, ClassRedefinition classRedefinition) {
        CompilerAsserts.neverPartOfCompilation();
        if (newFields.isEmpty()) {
            return;
        }
        List<Field> toAdd = ExtensionFieldsMetadata.initNewFields(holder, newFields, pool, compatibleFields, classRedefinition);
        int nextIndex = this.addedInstanceFields.length;
        this.addedInstanceFields = Arrays.copyOf(this.addedInstanceFields, this.addedInstanceFields.length + toAdd.size());
        for (Field field : toAdd) {
            this.addedInstanceFields[nextIndex++] = field;
        }
    }

    synchronized void addNewInstanceField(Field toAdd) {
        int nextIndex = this.addedInstanceFields.length;
        this.addedInstanceFields = Arrays.copyOf(this.addedInstanceFields, this.addedInstanceFields.length + 1);
        this.addedInstanceFields[nextIndex] = toAdd;
    }

    private static List<Field> initNewFields(ObjectKlass.KlassVersion holder, List<ParserField> fields, RuntimeConstantPool pool, Map<ParserField, Field> compatibleFields, ClassRedefinition classRedefinition) {
        ArrayList<Field> toAdd = new ArrayList<Field>(fields.size());
        for (ParserField newField : fields) {
            int nextFieldSlot = classRedefinition.getNextAvailableFieldSlot();
            LinkedField.IdMode mode = LinkedKlassFieldLayout.getIdMode(holder.linkedKlass.getParserKlass());
            LinkedField linkedField = new LinkedField(newField, nextFieldSlot, mode);
            RedefineAddedField field = holder.getSuperKlass() == holder.getKlass().getMeta().java_lang_Enum && newField.getName() != Symbol.Name.$VALUES && newField.getName() != Symbol.Name.ENUM$VALUES ? new RedefineAddedEnumField(holder, linkedField, pool) : new RedefineAddedField(holder, linkedField, pool, false);
            if (field.isStatic()) {
                holder.getKlass().initField(field);
            }
            toAdd.add(field);
            Field compatibleField = compatibleFields.get(newField);
            if (compatibleField == null || !compatibleField.getDeclaringKlass().isInitialized()) continue;
            ((Field)field).setCompatibleField(compatibleField);
        }
        return toAdd;
    }

    synchronized Field[] getDeclaredAddedFields() {
        int instanceFieldslength = this.addedInstanceFields.length;
        int staticFieldsLength = this.addedStaticFields.length;
        Field[] result = new Field[instanceFieldslength + staticFieldsLength];
        System.arraycopy(this.addedStaticFields, 0, result, 0, staticFieldsLength);
        System.arraycopy(this.addedInstanceFields, 0, result, staticFieldsLength, instanceFieldslength);
        return result;
    }

    synchronized Field[] getAddedStaticFields() {
        return (Field[])this.addedStaticFields.clone();
    }

    synchronized Field[] getAddedInstanceFields() {
        return (Field[])this.addedInstanceFields.clone();
    }

    synchronized Field getStaticFieldAtSlot(int slot) {
        Field field = ExtensionFieldsMetadata.binarySearch(this.addedStaticFields, slot);
        if (field != null) {
            return field;
        }
        CompilerDirectives.transferToInterpreter();
        throw new IndexOutOfBoundsException("index out of range: " + slot);
    }

    synchronized Field getInstanceFieldAtSlot(int slot) {
        return ExtensionFieldsMetadata.binarySearch(this.addedInstanceFields, slot);
    }

    private static Field binarySearch(Field[] arr, int slot) {
        int firstIndex = 0;
        int lastIndex = arr.length - 1;
        while (firstIndex <= lastIndex) {
            int middleIndex = (firstIndex + lastIndex) / 2;
            if (arr[middleIndex].getSlot() == slot) {
                return arr[middleIndex];
            }
            if (arr[middleIndex].getSlot() > slot) {
                firstIndex = middleIndex + 1;
                continue;
            }
            if (arr[middleIndex].getSlot() >= slot) continue;
            lastIndex = middleIndex - 1;
        }
        return null;
    }
}

