/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

final class LinkedField
extends StaticProperty {
    private final ParserField parserField;
    private final int slot;

    LinkedField(ParserField parserField, int slot, IdMode mode) {
        this.parserField = LinkedField.maybeCorrectParserField(parserField, mode);
        this.slot = slot;
    }

    private static ParserField maybeCorrectParserField(ParserField parserField, IdMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return parserField;
            }
            case 1: {
                return parserField.withFlags(0x1000000);
            }
            case 2: {
                return parserField.withFlags(0x2000000);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    protected String getId() {
        Symbol<Symbol.Name> name = this.getName();
        switch (this.idMode().ordinal()) {
            case 1: {
                return LinkedField.idFromNameAndType(name, this.getType());
            }
            case 2: {
                return (this.getKind().isPrimitive() ? "primitive" : (this.isHidden() ? "hidden" : "reference")) + "Field" + this.slot;
            }
            case 0: {
                return name.toString();
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    private IdMode idMode() {
        int flags = this.getFlags();
        if ((flags & 0x1000000) == 0x1000000) {
            return IdMode.WITH_TYPE;
        }
        if ((flags & 0x2000000) == 0x2000000) {
            return IdMode.OBFUSCATED;
        }
        return IdMode.REGULAR;
    }

    static String idFromNameAndType(Symbol<Symbol.Name> name, ByteSequence t) {
        int arrayDims = Types.getArrayDimensions(t);
        if (arrayDims > 0) {
            StringBuilder typeString = new StringBuilder(LinkedField.idFromNameAndType(name, t.subSequence(arrayDims, t.length() - arrayDims)));
            typeString.append('_');
            while (arrayDims > 0) {
                typeString.append(']');
                --arrayDims;
            }
            return typeString.toString();
        }
        String typeString = t.toString();
        if (Types.isReference(t)) {
            typeString = typeString.substring(1, typeString.length() - 1);
            typeString = typeString.replace('/', '_');
        }
        return name.toString() + "_" + typeString;
    }

    public Symbol<Symbol.Name> getName() {
        return this.parserField.getName();
    }

    public int getSlot() {
        return this.slot;
    }

    public Symbol<Symbol.Type> getType() {
        return this.getParserField().getType();
    }

    public int getFlags() {
        return this.getParserField().getFlags();
    }

    public JavaKind getKind() {
        return this.parserField.getKind();
    }

    public Attribute getAttribute(Symbol<Symbol.Name> name) {
        for (Attribute a : this.getParserField().getAttributes()) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public boolean isHidden() {
        return this.getParserField().isHidden();
    }

    ParserField getParserField() {
        return this.parserField;
    }

    public static Class<?> getPropertyType(ParserField parserField) {
        Symbol<Symbol.Type> type = parserField.getType();
        if (type.length() == 1) {
            char ch = (char)type.byteAt(0);
            return switch (ch) {
                case 'Z' -> Boolean.TYPE;
                case 'C' -> Character.TYPE;
                case 'F' -> Float.TYPE;
                case 'D' -> Double.TYPE;
                case 'B' -> Byte.TYPE;
                case 'S' -> Short.TYPE;
                case 'I' -> Integer.TYPE;
                case 'J' -> Long.TYPE;
                default -> throw EspressoError.shouldNotReachHere("unknown primitive or void type character: " + ch);
            };
        }
        return parserField.isHidden() ? Object.class : StaticObject.class;
    }

    static enum IdMode {
        REGULAR,
        WITH_TYPE,
        OBFUSCATED;

    }
}

