/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import java.util.ArrayList;
import java.util.Arrays;

public final class VirtualTable {
    private VirtualTable() {
    }

    public static Method.MethodVersion[] create(ObjectKlass superKlass, Method.MethodVersion[] declaredMethods, ObjectKlass.KlassVersion thisKlass, Method.MethodVersion[] mirandaMethods, boolean isRedefinition) {
        ArrayList<Method.MethodVersion> overrides = new ArrayList<Method.MethodVersion>();
        ArrayList<Object> tmp = superKlass != null ? new ArrayList<Method.MethodVersion>(Arrays.asList(superKlass.getVTable())) : new ArrayList();
        for (Method.MethodVersion m : declaredMethods) {
            if (m.isPrivate() || m.isStatic() || Symbol.Name._clinit_.equals(m.getName()) || Symbol.Name._init_.equals(m.getName())) continue;
            VirtualTable.checkOverride(superKlass, m, tmp, thisKlass, overrides, isRedefinition);
        }
        for (Method.MethodVersion m : mirandaMethods) {
            m.setVTableIndex(tmp.size(), isRedefinition);
            tmp.add(m);
        }
        return tmp.toArray(Method.EMPTY_VERSION_ARRAY);
    }

    private static void checkOverride(ObjectKlass superKlass, Method.MethodVersion m, ArrayList<Method.MethodVersion> tmp, ObjectKlass.KlassVersion thisKlass, ArrayList<Method.MethodVersion> overrides, boolean isRedefinition) {
        if (!overrides.isEmpty()) {
            overrides.clear();
        }
        if (superKlass != null) {
            superKlass.lookupVirtualMethodOverrides(m.getMethod(), thisKlass.getKlass(), overrides);
        }
        Method.MethodVersion toSet = m;
        if (!overrides.isEmpty()) {
            int count = 1;
            for (Method.MethodVersion override : overrides) {
                if (override.isFinalFlagSet()) {
                    Meta meta = m.getMethod().getDeclaringKlass().getMeta();
                    if (meta.getJavaVersion().java16OrLater()) {
                        throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, "Overriding final method: " + String.valueOf(override));
                    }
                    throw meta.throwExceptionWithMessage(meta.java_lang_VerifyError, "Overriding final method: " + String.valueOf(override));
                }
                int pos = override.getVTableIndex();
                if (count > 1) {
                    toSet = new Method(m.getMethod()).getMethodVersion();
                }
                toSet.setVTableIndex(pos, isRedefinition);
                tmp.set(pos, toSet);
                ++count;
            }
        } else {
            int pos = tmp.size();
            toSet.setVTableIndex(pos, isRedefinition);
            tmp.add(toSet);
        }
    }
}

