/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl.generics.factory;

import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.generics.factory.GenericsFactory;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.GenericArrayTypeImpl;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.ParameterizedTypeImpl;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.ParameterizedTypeVariable;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class CoreReflectionFactory
implements GenericsFactory {
    private final Klass klass;

    private CoreReflectionFactory(Klass d) {
        this.klass = d;
    }

    private StaticObject getDefiningClassLoader() {
        return this.klass.getDefiningClassLoader();
    }

    public static CoreReflectionFactory make(Klass klass) {
        return new CoreReflectionFactory(klass);
    }

    @Override
    public EspressoType makeParameterizedType(EspressoType declaration, EspressoType[] typeArgs, EspressoType owner) {
        return ParameterizedTypeImpl.make((Klass)declaration, typeArgs, owner);
    }

    @Override
    public EspressoType makeNamedType(String dotName) {
        return this.klass.getMeta().loadKlassOrNull(this.klass.getTypes().getOrCreate(CoreReflectionFactory.toInternalName(dotName)), this.getDefiningClassLoader(), StaticObject.NULL);
    }

    @Override
    public EspressoType makeTypeVariable(String name, EspressoType javaLangObjectType) {
        return ParameterizedTypeVariable.make(name, javaLangObjectType);
    }

    private static String toInternalName(String dotName) {
        return "L" + dotName.replace('.', '/') + ";";
    }

    @Override
    public EspressoType makeArrayType(EspressoType componentType) {
        if (componentType instanceof Klass) {
            return ((Klass)componentType).array();
        }
        return GenericArrayTypeImpl.make(componentType);
    }

    @Override
    public EspressoType makeJavaLangObject() {
        return this.klass.getMeta().java_lang_Object;
    }

    @Override
    public EspressoType makeByte() {
        return this.klass.getMeta()._byte;
    }

    @Override
    public EspressoType makeBool() {
        return this.klass.getMeta()._boolean;
    }

    @Override
    public EspressoType makeShort() {
        return this.klass.getMeta()._short;
    }

    @Override
    public EspressoType makeChar() {
        return this.klass.getMeta()._char;
    }

    @Override
    public EspressoType makeInt() {
        return this.klass.getMeta()._int;
    }

    @Override
    public EspressoType makeLong() {
        return this.klass.getMeta()._long;
    }

    @Override
    public EspressoType makeFloat() {
        return this.klass.getMeta()._float;
    }

    @Override
    public EspressoType makeDouble() {
        return this.klass.getMeta()._double;
    }

    @Override
    public EspressoType makeVoid() {
        return this.klass.getMeta()._void;
    }
}

