/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl.generics.reflectiveObjects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ParameterizedEspressoType;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public final class ParameterizedTypeImpl
implements ParameterizedEspressoType {
    private final EspressoType[] actualTypeArguments;
    private final Klass rawType;
    private final EspressoType ownerType;
    @CompilerDirectives.CompilationFinal
    private StaticObject guestTypeLiteral;

    private ParameterizedTypeImpl(Klass rawType, EspressoType[] actualTypeArguments, EspressoType ownerType) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType != null ? ownerType : rawType;
    }

    @Override
    public StaticObject getGuestTypeLiteral() {
        if (this.guestTypeLiteral == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoContext context = this.getRawType().getContext();
            StaticObject result = context.getAllocator().createNew(context.getMeta().polyglot.TypeLiteral$InternalTypeLiteral);
            context.getMeta().polyglot.HIDDEN_TypeLiteral_internalType.setHiddenObject(result, this);
            context.getMeta().polyglot.TypeLiteral_rawType.setObject(result, this.getRawType().mirror());
            this.guestTypeLiteral = result;
        }
        return this.guestTypeLiteral;
    }

    public static EspressoType make(Klass rawType, EspressoType[] actualTypeArguments, EspressoType ownerType) {
        return new ParameterizedTypeImpl(rawType, actualTypeArguments, ownerType);
    }

    @Override
    public EspressoType[] getTypeArguments() {
        return (EspressoType[])this.actualTypeArguments.clone();
    }

    @Override
    public Klass getRawType() {
        return this.rawType;
    }

    @Override
    public EspressoType getOwnerType() {
        return this.ownerType;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object o) {
        if (o instanceof ParameterizedEspressoType) {
            ParameterizedEspressoType that = (ParameterizedEspressoType)o;
            if (this == that) {
                return true;
            }
            EspressoType thatOwner = that.getOwnerType();
            Klass thatRawType = that.getRawType();
            return Objects.equals(this.ownerType, thatOwner) && Objects.equals(this.rawType, thatRawType) && Arrays.equals(this.actualTypeArguments, that.getTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getRawType().getTypeName());
            sb.append("$");
            if (this.ownerType instanceof ParameterizedTypeImpl) {
                sb.append(this.rawType.getNameAsString().replace(String.valueOf(((ParameterizedTypeImpl)this.ownerType).rawType.getName()) + "$", ""));
            } else {
                sb.append(this.rawType.getNameAsString());
            }
        } else {
            sb.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null) {
            StringJoiner sj = new StringJoiner(", ", "<", ">");
            sj.setEmptyValue("");
            for (EspressoType t : this.actualTypeArguments) {
                sj.add(t.getRawType().getTypeName());
            }
            sb.append(sj);
        }
        return sb.toString();
    }
}

