/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl.generics.visitor;

import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.generics.factory.GenericsFactory;
import com.oracle.truffle.espresso.impl.generics.tree.ArrayTypeSignature;
import com.oracle.truffle.espresso.impl.generics.tree.BooleanSignature;
import com.oracle.truffle.espresso.impl.generics.tree.BottomSignature;
import com.oracle.truffle.espresso.impl.generics.tree.ByteSignature;
import com.oracle.truffle.espresso.impl.generics.tree.CharSignature;
import com.oracle.truffle.espresso.impl.generics.tree.ClassTypeSignature;
import com.oracle.truffle.espresso.impl.generics.tree.DoubleSignature;
import com.oracle.truffle.espresso.impl.generics.tree.FloatSignature;
import com.oracle.truffle.espresso.impl.generics.tree.IntSignature;
import com.oracle.truffle.espresso.impl.generics.tree.LongSignature;
import com.oracle.truffle.espresso.impl.generics.tree.ShortSignature;
import com.oracle.truffle.espresso.impl.generics.tree.SimpleClassTypeSignature;
import com.oracle.truffle.espresso.impl.generics.tree.TypeArgument;
import com.oracle.truffle.espresso.impl.generics.tree.TypeVariableSignature;
import com.oracle.truffle.espresso.impl.generics.tree.VoidDescriptor;
import com.oracle.truffle.espresso.impl.generics.visitor.TypeTreeVisitor;
import java.util.Iterator;
import java.util.List;

public final class Reifier
implements TypeTreeVisitor<EspressoType> {
    private EspressoType resultType;
    private final GenericsFactory factory;

    private Reifier(GenericsFactory f) {
        this.factory = f;
    }

    private GenericsFactory getFactory() {
        return this.factory;
    }

    public static Reifier make(GenericsFactory f) {
        return new Reifier(f);
    }

    private EspressoType[] reifyTypeArguments(TypeArgument[] tas) {
        EspressoType[] ts = new EspressoType[tas.length];
        for (int i = 0; i < tas.length; ++i) {
            tas[i].accept(this);
            ts[i] = this.resultType;
        }
        return ts;
    }

    @Override
    public EspressoType getResult() {
        return this.resultType;
    }

    @Override
    public void visitClassTypeSignature(ClassTypeSignature ct) {
        boolean dollar;
        List<SimpleClassTypeSignature> scts = ct.getPath();
        assert (!scts.isEmpty());
        Iterator<SimpleClassTypeSignature> iter = scts.iterator();
        SimpleClassTypeSignature sc = iter.next();
        StringBuilder n = new StringBuilder(sc.getName());
        while (iter.hasNext() && sc.getTypeArguments().length == 0) {
            sc = iter.next();
            dollar = sc.getDollar();
            n.append(dollar ? "$" : ".").append(sc.getName());
        }
        EspressoType c = this.getFactory().makeNamedType(n.toString());
        if (sc.getTypeArguments().length == 0) {
            assert (!iter.hasNext());
            this.resultType = c;
        } else {
            EspressoType[] pts = this.reifyTypeArguments(sc.getTypeArguments());
            EspressoType owner = this.getFactory().makeParameterizedType(c, pts, null);
            while (iter.hasNext()) {
                sc = iter.next();
                dollar = sc.getDollar();
                n.append(dollar ? "$" : ".").append(sc.getName());
                c = this.getFactory().makeNamedType(n.toString());
                pts = this.reifyTypeArguments(sc.getTypeArguments());
                owner = this.getFactory().makeParameterizedType(c, pts, owner);
            }
            this.resultType = owner;
        }
    }

    @Override
    public void visitArrayTypeSignature(ArrayTypeSignature a) {
        a.getComponentType().accept(this);
        EspressoType ct = this.resultType;
        this.resultType = this.getFactory().makeArrayType(ct);
    }

    @Override
    public void visitSimpleClassTypeSignature(SimpleClassTypeSignature sct) {
        this.resultType = this.getFactory().makeNamedType(sct.getName());
    }

    @Override
    public void visitBottomSignature(BottomSignature b) {
    }

    @Override
    public void visitTypeVariableSignature(TypeVariableSignature t) {
        this.resultType = this.getFactory().makeTypeVariable(t.getIdentifier(), this.getFactory().makeJavaLangObject());
    }

    @Override
    public void visitByteSignature(ByteSignature b) {
        this.resultType = this.getFactory().makeByte();
    }

    @Override
    public void visitBooleanSignature(BooleanSignature b) {
        this.resultType = this.getFactory().makeBool();
    }

    @Override
    public void visitShortSignature(ShortSignature s) {
        this.resultType = this.getFactory().makeShort();
    }

    @Override
    public void visitCharSignature(CharSignature c) {
        this.resultType = this.getFactory().makeChar();
    }

    @Override
    public void visitIntSignature(IntSignature i) {
        this.resultType = this.getFactory().makeInt();
    }

    @Override
    public void visitLongSignature(LongSignature l) {
        this.resultType = this.getFactory().makeLong();
    }

    @Override
    public void visitFloatSignature(FloatSignature f) {
        this.resultType = this.getFactory().makeFloat();
    }

    @Override
    public void visitDoubleSignature(DoubleSignature d) {
        this.resultType = this.getFactory().makeDouble();
    }

    @Override
    public void visitVoidDescriptor(VoidDescriptor v) {
        this.resultType = this.getFactory().makeVoid();
    }
}

