/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.api;

import com.oracle.truffle.espresso.classfile.JavaKind;

public final class TagConstants {
    public static final byte ARRAY = 91;
    public static final byte BYTE = 66;
    public static final byte CHAR = 67;
    public static final byte OBJECT = 76;
    public static final byte FLOAT = 70;
    public static final byte DOUBLE = 68;
    public static final byte INT = 73;
    public static final byte LONG = 74;
    public static final byte SHORT = 83;
    public static final byte VOID = 86;
    public static final byte BOOLEAN = 90;
    public static final byte STRING = 115;
    public static final byte THREAD = 116;
    public static final byte THREAD_GROUP = 103;
    public static final byte CLASS_LOADER = 108;
    public static final byte CLASS_OBJECT = 99;

    private TagConstants() {
    }

    public static boolean isPrimitive(byte tag) {
        return tag != 76 && tag != 115 && tag != 91 && tag != 116 && tag != 103 && tag != 99 && tag != 108;
    }

    public static byte getTagFromPrimitive(Object boxed) {
        if (boxed instanceof Integer) {
            return 73;
        }
        if (boxed instanceof Float) {
            return 70;
        }
        if (boxed instanceof Double) {
            return 68;
        }
        if (boxed instanceof Long) {
            return 74;
        }
        if (boxed instanceof Byte) {
            return 66;
        }
        if (boxed instanceof Short) {
            return 83;
        }
        if (boxed instanceof Character) {
            return 67;
        }
        if (boxed instanceof Boolean) {
            return 90;
        }
        throw new RuntimeException("boxed object: " + String.valueOf(boxed.getClass()) + " is not a primitive");
    }

    public static byte toTagConstant(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return 90;
            }
            case Byte: {
                return 66;
            }
            case Short: {
                return 83;
            }
            case Char: {
                return 67;
            }
            case Int: {
                return 73;
            }
            case Float: {
                return 70;
            }
            case Long: {
                return 74;
            }
            case Double: {
                return 68;
            }
            case Object: {
                return 76;
            }
        }
        return -1;
    }
}

