/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.FieldBreakpoint;
import com.oracle.truffle.espresso.jdwp.api.FieldRef;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodHook;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.MethodVariable;
import com.oracle.truffle.espresso.jdwp.api.VMEventListener;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.ClassPrepareRequest;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.FieldBreakpointEvent;
import com.oracle.truffle.espresso.jdwp.impl.FieldBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.JDWP;
import com.oracle.truffle.espresso.jdwp.impl.MethodBreakpointEvent;
import com.oracle.truffle.espresso.jdwp.impl.MethodBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.MonitorEvent;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.SocketConnection;
import com.oracle.truffle.espresso.jdwp.impl.SteppingInfo;
import com.oracle.truffle.espresso.jdwp.impl.TypeTag;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public final class VMEventListenerImpl
implements VMEventListener {
    public static final InteropLibrary UNCACHED = InteropLibrary.getUncached();
    private final HashMap<Integer, ClassPrepareRequest> classPrepareRequests = new HashMap();
    private final HashMap<Integer, BreakpointInfo> breakpointRequests = new HashMap();
    private final HashMap<Integer, RequestFilter> monitorContendedRequests = new HashMap();
    private final HashMap<Integer, RequestFilter> monitorContendedEnteredRequests = new HashMap();
    private final HashMap<Integer, RequestFilter> monitorWaitRequests = new HashMap();
    private final HashMap<Integer, RequestFilter> monitorWaitedRequests = new HashMap();
    private SocketConnection connection;
    private JDWPContext context;
    private Ids<Object> ids;
    private DebuggerController debuggerController;
    private volatile boolean holdEvents;
    private int threadStartedRequestId;
    private int threadDeathRequestId;
    private byte threadStartSuspendPolicy;
    private byte threadDeathSuspendPolicy;
    private int vmDeathRequestId;
    private byte vmDeathSuspendPolicy = 0;
    private int vmStartRequestId;
    private final List<PacketStream> heldEvents = new ArrayList<PacketStream>();
    private final Map<Object, Object> currentContendedMonitor = new HashMap<Object, Object>();
    private Object initialThread;

    public void activate(Object mainThread, DebuggerController control, JDWPContext jdwpContext) {
        this.initialThread = mainThread;
        this.debuggerController = control;
        this.context = jdwpContext;
        this.ids = this.context.getIds();
    }

    public void replaceController(DebuggerController newController) {
        this.debuggerController = newController;
    }

    @Override
    public void onDetach() {
        this.removeThreadStartedRequestId();
        this.removeThreadDiedRequestId();
        this.vmDeathRequestId = 0;
        this.vmDeathSuspendPolicy = 0;
        this.classPrepareRequests.clear();
        this.breakpointRequests.clear();
        this.monitorContendedRequests.clear();
        this.monitorContendedEnteredRequests.clear();
        this.monitorWaitedRequests.clear();
        this.monitorWaitRequests.clear();
    }

    @Override
    public void setConnection(SocketConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClassPrepareRequest(ClassPrepareRequest request) {
        HashMap<Integer, ClassPrepareRequest> hashMap = this.classPrepareRequests;
        synchronized (hashMap) {
            this.classPrepareRequests.put(request.getRequestId(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public void removeClassPrepareRequest(int requestId) {
        HashMap<Integer, ClassPrepareRequest> hashMap = this.classPrepareRequests;
        synchronized (hashMap) {
            this.classPrepareRequests.remove(requestId);
        }
    }

    @Override
    public void addBreakpointRequest(int requestId, BreakpointInfo info) {
        this.breakpointRequests.put(requestId, info);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void removeBreakpointRequest(int requestId) {
        BreakpointInfo remove = this.breakpointRequests.remove(requestId);
        if (remove != null) {
            Breakpoint[] breakpoints;
            for (Breakpoint breakpoint : breakpoints = remove.getBreakpoints()) {
                breakpoint.dispose();
            }
        }
    }

    @Override
    public void clearAllBreakpointRequests() {
        this.breakpointRequests.clear();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean onFieldModification(FieldRef field, Object receiver, Object value) {
        boolean active = false;
        for (FieldBreakpoint info : field.getFieldBreakpointInfos()) {
            if (!info.isModificationBreakpoint()) continue;
            this.debuggerController.prepareFieldBreakpoint(new FieldBreakpointEvent((FieldBreakpointInfo)info, receiver, value));
            this.debuggerController.suspend(this.context.asGuestThread(Thread.currentThread()));
            active = true;
        }
        return active;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean onFieldAccess(FieldRef field, Object receiver) {
        boolean active = false;
        for (FieldBreakpoint info : field.getFieldBreakpointInfos()) {
            if (!info.isAccessBreakpoint()) continue;
            this.debuggerController.prepareFieldBreakpoint(new FieldBreakpointEvent((FieldBreakpointInfo)info, receiver));
            this.debuggerController.suspend(this.context.asGuestThread(Thread.currentThread()));
            active = true;
        }
        return active;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean onMethodEntry(MethodRef method, Object scope) {
        boolean active = false;
        ArrayList<MethodVariable> variables = new ArrayList<MethodVariable>(1);
        try {
            Object identifiers;
            if (UNCACHED.hasMembers(scope) && UNCACHED.hasArrayElements(identifiers = UNCACHED.getMembers(scope))) {
                long size = UNCACHED.getArraySize(identifiers);
                for (long i = 0L; i < size; ++i) {
                    String identifier = (String)UNCACHED.readArrayElement(identifiers, i);
                    Object value = UNCACHED.readMember(scope, identifier);
                    variables.add(new MethodVariable(identifier, value));
                }
            }
        }
        catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException throwable) {
            // empty catch block
        }
        block6: for (MethodHook hook : method.getMethodHooks()) {
            if (!hook.onMethodEnter(method, variables.toArray(new MethodVariable[variables.size()]))) continue;
            this.debuggerController.prepareMethodBreakpoint(new MethodBreakpointEvent((MethodBreakpointInfo)hook, null));
            this.debuggerController.suspend(this.context.asGuestThread(Thread.currentThread()));
            active = true;
            switch (hook.getKind()) {
                case ONE_TIME: {
                    if (!hook.hasFired()) continue block6;
                    method.removedMethodHook(hook);
                    continue block6;
                }
            }
        }
        return active;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean onMethodReturn(MethodRef method, Object returnValue) {
        boolean active = false;
        block3: for (MethodHook hook : method.getMethodHooks()) {
            if (!hook.onMethodExit(method, returnValue)) continue;
            this.debuggerController.prepareMethodBreakpoint(new MethodBreakpointEvent((MethodBreakpointInfo)hook, returnValue));
            this.debuggerController.suspend(this.context.asGuestThread(Thread.currentThread()));
            active = true;
            switch (hook.getKind()) {
                case ONE_TIME: {
                    if (!hook.hasFired()) continue block3;
                    method.removedMethodHook(hook);
                    continue block3;
                }
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public void classPrepared(KlassRef klass, Object prepareThread) {
        if (this.classPrepareRequests.isEmpty()) {
            return;
        }
        String dotName = klass.getNameAsString().replace('/', '.');
        ArrayList<ClassPrepareRequest> toSend = new ArrayList<ClassPrepareRequest>();
        byte suspendPolicy = 0;
        ClassPrepareRequest[] classPrepareRequestArray = this.classPrepareRequests;
        synchronized (this.classPrepareRequests) {
            ClassPrepareRequest[] prepareRequests = this.classPrepareRequests.values().toArray(new ClassPrepareRequest[0]);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            for (ClassPrepareRequest cpr : prepareRequests) {
                Pattern[] patterns;
                for (Pattern pattern : patterns = cpr.getPatterns()) {
                    if (!"".equals(pattern.pattern()) && !pattern.matcher(dotName).matches()) continue;
                    toSend.add(cpr);
                    byte cprPolicy = cpr.getSuspendPolicy();
                    if (cprPolicy == 2) {
                        suspendPolicy = 2;
                        continue;
                    }
                    if (cprPolicy != 1 || suspendPolicy == 2) continue;
                    suspendPolicy = 1;
                }
            }
            if (!toSend.isEmpty()) {
                PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
                assert (this.connection != null);
                stream.writeByte(suspendPolicy);
                stream.writeInt(toSend.size());
                for (ClassPrepareRequest cpr : toSend) {
                    stream.writeByte((byte)8);
                    stream.writeInt(cpr.getRequestId());
                    stream.writeLong(this.ids.getIdAsLong(prepareThread));
                    stream.writeByte(TypeTag.getKind(klass));
                    stream.writeLong(this.ids.getIdAsLong(klass));
                    stream.writeString(klass.getTypeAsString());
                    stream.writeInt(klass.getStatus());
                }
                if (suspendPolicy != 0) {
                    this.debuggerController.immediateSuspend(prepareThread, suspendPolicy, () -> {
                        if (this.holdEvents) {
                            this.heldEvents.add(stream);
                        } else {
                            this.debuggerController.fine(() -> "SENDING CLASS PREPARE EVENT FOR KLASS: " + klass.getNameAsString() + " WITH THREAD " + this.context.getThreadName(prepareThread));
                            this.connection.queuePacket(stream);
                        }
                        return null;
                    });
                } else if (this.holdEvents) {
                    this.heldEvents.add(stream);
                } else {
                    this.connection.queuePacket(stream);
                }
            }
            return;
        }
    }

    @Override
    public void breakpointHit(BreakpointInfo info, CallFrame frame, Object currentThread) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(info.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte(info.getEventKind());
        stream.writeInt(info.getRequestId());
        long threadId = this.ids.getIdAsLong(currentThread);
        stream.writeLong(threadId);
        stream.writeByte(frame.getTypeTag());
        stream.writeLong(frame.getClassId());
        stream.writeLong(frame.getMethodId());
        stream.writeLong(frame.getCodeIndex());
        this.debuggerController.fine(() -> "Sending breakpoint hit event in thread: " + this.context.getThreadName(currentThread) + " with suspension policy: " + info.getSuspendPolicy());
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void methodBreakpointHit(MethodBreakpointEvent methodEvent, Object currentThread, CallFrame frame) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        MethodBreakpointInfo info = methodEvent.getInfo();
        stream.writeByte(info.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte(info.getEventKind());
        stream.writeInt(info.getRequestId());
        long threadId = this.ids.getIdAsLong(currentThread);
        stream.writeLong(threadId);
        stream.writeByte(frame.getTypeTag());
        stream.writeLong(frame.getClassId());
        stream.writeLong(frame.getMethodId());
        stream.writeLong(frame.getCodeIndex());
        if (info.getEventKind() == 42) {
            Object returnValue = methodEvent.getReturnValue();
            byte tag = this.context.getTag(returnValue);
            JDWP.writeValue(tag, returnValue, stream, true, this.context);
        }
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void fieldAccessBreakpointHit(FieldBreakpointEvent event, Object currentThread, CallFrame callFrame) {
        assert (this.connection != null);
        PacketStream stream = this.writeSharedFieldInformation(event, currentThread, callFrame, (byte)20);
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void fieldModificationBreakpointHit(FieldBreakpointEvent event, Object currentThread, CallFrame callFrame) {
        assert (this.connection != null);
        PacketStream stream = this.writeSharedFieldInformation(event, currentThread, callFrame, (byte)21);
        Object value = event.getValue();
        byte tag = this.context.getTag(value);
        JDWP.writeValue(tag, value, stream, true, this.context);
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    private PacketStream writeSharedFieldInformation(FieldBreakpointEvent event, Object currentThread, CallFrame callFrame, byte eventType) {
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        FieldBreakpointInfo info = event.getInfo();
        stream.writeByte(info.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte(eventType);
        stream.writeInt(info.getRequestId());
        long threadId = this.ids.getIdAsLong(currentThread);
        stream.writeLong(threadId);
        stream.writeByte(callFrame.getTypeTag());
        stream.writeLong(callFrame.getClassId());
        stream.writeLong(callFrame.getMethodId());
        stream.writeLong(callFrame.getCodeIndex());
        KlassRef klass = info.getKlass();
        stream.writeByte(TypeTag.getKind(klass));
        stream.writeLong(this.context.getIds().getIdAsLong(klass));
        stream.writeLong(this.context.getIds().getIdAsLong(info.getField()));
        stream.writeByte((byte)76);
        if (Modifier.isStatic(info.getField().getModifiers())) {
            stream.writeLong(0L);
        } else {
            stream.writeLong(this.context.getIds().getIdAsLong(event.getReceiver()));
        }
        return stream;
    }

    @Override
    public void exceptionThrown(BreakpointInfo info, Object currentThread, Object exception, CallFrame[] callFrames) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        CallFrame top = callFrames[0];
        stream.writeByte(info.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte((byte)4);
        stream.writeInt(info.getRequestId());
        stream.writeLong(this.ids.getIdAsLong(currentThread));
        stream.writeByte(top.getTypeTag());
        stream.writeLong(top.getClassId());
        stream.writeLong(this.ids.getIdAsLong(top.getMethod()));
        stream.writeLong(top.getCodeIndex());
        stream.writeByte((byte)76);
        stream.writeLong(this.context.getIds().getIdAsLong(exception));
        boolean caught = false;
        for (CallFrame callFrame : callFrames) {
            MethodRef method = callFrame.getMethod();
            int catchLocation = this.context.getCatchLocation(method, exception, (int)callFrame.getCodeIndex());
            if (catchLocation == -1) continue;
            stream.writeByte(callFrame.getTypeTag());
            stream.writeLong(callFrame.getClassId());
            stream.writeLong(callFrame.getMethodId());
            stream.writeLong(catchLocation);
            caught = true;
            break;
        }
        if (!caught) {
            stream.writeByte((byte)1);
            stream.writeLong(0L);
            stream.writeLong(0L);
            stream.writeLong(0L);
        }
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void stepCompleted(SteppingInfo info, CallFrame currentFrame) {
        assert (this.connection != null);
        if (info.isPopFrames()) {
            PacketStream reply = new PacketStream().replyPacket().id(info.getRequestId());
            this.debuggerController.fine(() -> "Sending pop frames reply packet");
            if (this.holdEvents) {
                this.heldEvents.add(reply);
            } else {
                this.connection.queuePacket(reply);
            }
        } else {
            PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
            stream.writeByte(info.getSuspendPolicy());
            stream.writeInt(1);
            stream.writeByte((byte)1);
            stream.writeInt(info.getRequestId());
            stream.writeLong(currentFrame.getThreadId());
            stream.writeByte(currentFrame.getTypeTag());
            stream.writeLong(currentFrame.getClassId());
            stream.writeLong(currentFrame.getMethodId());
            long codeIndex = info.getStepOutBCI() != -1L ? info.getStepOutBCI() : currentFrame.getCodeIndex();
            stream.writeLong(codeIndex);
            this.debuggerController.fine(() -> "Sending step completed event");
            if (this.holdEvents) {
                this.heldEvents.add(stream);
            } else {
                this.connection.queuePacket(stream);
            }
        }
    }

    private void sendMonitorContendedEnterEvent(MonitorEvent monitorEvent, CallFrame currentFrame) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(monitorEvent.getFilter().getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte((byte)43);
        stream.writeInt(monitorEvent.getFilter().getRequestId());
        stream.writeLong(currentFrame.getThreadId());
        Object monitor = monitorEvent.getMonitor();
        stream.writeByte(this.context.getTag(monitor));
        stream.writeLong(this.context.getIds().getIdAsLong(monitor));
        stream.writeByte(currentFrame.getTypeTag());
        stream.writeLong(currentFrame.getClassId());
        stream.writeLong(currentFrame.getMethodId());
        long codeIndex = currentFrame.getCodeIndex();
        stream.writeLong(codeIndex);
        this.debuggerController.fine(() -> "Sending monitor contended event");
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void addMonitorContendedEnterRequest(int requestId, RequestFilter filter) {
        this.monitorContendedRequests.put(requestId, filter);
    }

    @Override
    public void removeMonitorContendedEnterRequest(int requestId) {
        this.monitorContendedRequests.remove(requestId);
    }

    private void sendMonitorContendedEnteredEvent(MonitorEvent monitorEvent, CallFrame currentFrame) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(monitorEvent.getFilter().getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte((byte)44);
        stream.writeInt(monitorEvent.getFilter().getRequestId());
        stream.writeLong(currentFrame.getThreadId());
        Object monitor = monitorEvent.getMonitor();
        stream.writeByte(this.context.getTag(monitor));
        stream.writeLong(this.context.getIds().getIdAsLong(monitor));
        stream.writeByte(currentFrame.getTypeTag());
        stream.writeLong(currentFrame.getClassId());
        stream.writeLong(currentFrame.getMethodId());
        long codeIndex = currentFrame.getCodeIndex();
        stream.writeLong(codeIndex);
        this.debuggerController.fine(() -> "Sending monitor contended entered event");
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void addMonitorContendedEnteredRequest(int requestId, RequestFilter filter) {
        this.monitorContendedEnteredRequests.put(requestId, filter);
    }

    @Override
    public void removeMonitorContendedEnteredRequest(int requestId) {
        this.monitorContendedEnteredRequests.remove(requestId);
    }

    public void sendMonitorWaitEvent(Object monitor, long timeout, RequestFilter filter, CallFrame currentFrame) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(filter.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte((byte)45);
        stream.writeInt(filter.getRequestId());
        stream.writeLong(currentFrame.getThreadId());
        stream.writeByte(this.context.getTag(monitor));
        stream.writeLong(this.context.getIds().getIdAsLong(monitor));
        stream.writeByte(currentFrame.getTypeTag());
        stream.writeLong(currentFrame.getClassId());
        stream.writeLong(currentFrame.getMethodId());
        long codeIndex = currentFrame.getCodeIndex();
        stream.writeLong(codeIndex);
        stream.writeLong(timeout);
        this.debuggerController.fine(() -> "Sending monitor wait event");
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void addMonitorWaitRequest(int requestId, RequestFilter filter) {
        this.monitorWaitRequests.put(requestId, filter);
    }

    @Override
    public void removeMonitorWaitRequest(int requestId) {
        this.monitorWaitRequests.remove(requestId);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void monitorWait(Object monitor, long timeout) {
        if (this.context == null) {
            return;
        }
        Object guestThread = this.context.asGuestThread(Thread.currentThread());
        this.currentContendedMonitor.put(guestThread, monitor);
        if (this.monitorWaitRequests.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, RequestFilter> entry : this.monitorWaitRequests.entrySet()) {
            RequestFilter filter = entry.getValue();
            if (guestThread != filter.getThread()) continue;
            CallFrame frame = this.context.locateObjectWaitFrame();
            this.debuggerController.immediateSuspend(guestThread, filter.getSuspendPolicy(), () -> {
                this.sendMonitorWaitEvent(monitor, timeout, filter, frame);
                return null;
            });
        }
    }

    private void sendMonitorWaitedEvent(Object monitor, boolean timedOut, RequestFilter filter, CallFrame currentFrame) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(filter.getSuspendPolicy());
        stream.writeInt(1);
        stream.writeByte((byte)46);
        stream.writeInt(filter.getRequestId());
        stream.writeLong(currentFrame.getThreadId());
        stream.writeByte(this.context.getTag(monitor));
        stream.writeLong(this.context.getIds().getIdAsLong(monitor));
        stream.writeByte(currentFrame.getTypeTag());
        stream.writeLong(currentFrame.getClassId());
        stream.writeLong(currentFrame.getMethodId());
        long codeIndex = currentFrame.getCodeIndex();
        stream.writeLong(codeIndex);
        stream.writeBoolean(timedOut);
        this.debuggerController.fine(() -> "Sending monitor wait event");
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void addMonitorWaitedRequest(int requestId, RequestFilter filter) {
        this.monitorWaitedRequests.put(requestId, filter);
    }

    @Override
    public void removeMonitorWaitedRequest(int requestId) {
        this.monitorWaitedRequests.remove(requestId);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void monitorWaited(final Object monitor, final boolean timedOut) {
        if (this.context == null) {
            return;
        }
        Object currentThread = this.context.asGuestThread(Thread.currentThread());
        this.currentContendedMonitor.remove(currentThread);
        if (this.monitorWaitedRequests.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, RequestFilter> entry : this.monitorWaitedRequests.entrySet()) {
            final RequestFilter filter = entry.getValue();
            if (currentThread != filter.getThread()) continue;
            final CallFrame frame = this.context.locateObjectWaitFrame();
            this.debuggerController.immediateSuspend(currentThread, filter.getSuspendPolicy(), new Callable<Void>(){
                final /* synthetic */ VMEventListenerImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void call() {
                    this.this$0.sendMonitorWaitedEvent(monitor, timedOut, filter, frame);
                    return null;
                }
            });
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void onContendedMonitorEnter(Object monitor) {
        if (this.context == null) {
            return;
        }
        Object guestThread = this.context.asGuestThread(Thread.currentThread());
        this.currentContendedMonitor.put(guestThread, monitor);
        if (this.monitorContendedRequests.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, RequestFilter> entry : this.monitorContendedRequests.entrySet()) {
            RequestFilter filter = entry.getValue();
            if (guestThread != filter.getThread()) continue;
            MonitorEvent event = new MonitorEvent(monitor, filter);
            CallFrame topFrame = this.context.getStackTrace(guestThread)[0];
            this.debuggerController.immediateSuspend(guestThread, filter.getSuspendPolicy(), () -> {
                this.sendMonitorContendedEnterEvent(event, topFrame);
                return null;
            });
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void onContendedMonitorEntered(Object monitor) {
        if (this.context == null) {
            return;
        }
        Object guestThread = this.context.asGuestThread(Thread.currentThread());
        this.currentContendedMonitor.remove(guestThread);
        if (this.monitorContendedEnteredRequests.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, RequestFilter> entry : this.monitorContendedEnteredRequests.entrySet()) {
            RequestFilter filter = entry.getValue();
            if (guestThread != filter.getThread()) continue;
            MonitorEvent event = new MonitorEvent(monitor, filter);
            CallFrame topFrame = this.context.getStackTrace(guestThread)[0];
            this.debuggerController.immediateSuspend(guestThread, filter.getSuspendPolicy(), () -> {
                this.sendMonitorContendedEnteredEvent(event, topFrame);
                return null;
            });
        }
    }

    @Override
    public Object getCurrentContendedMonitor(Object guestThread) {
        return this.currentContendedMonitor.get(guestThread);
    }

    @Override
    public void classUnloaded(KlassRef klass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void threadStarted(Object thread) {
        if (this.threadStartedRequestId == 0) {
            return;
        }
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(this.threadStartSuspendPolicy);
        this.suspend(this.threadStartSuspendPolicy, thread);
        stream.writeInt(1);
        stream.writeByte((byte)6);
        stream.writeInt(this.threadStartedRequestId);
        stream.writeLong(this.ids.getIdAsLong(thread));
        this.debuggerController.fine(() -> "sending thread started event for thread: " + this.context.getThreadName(thread));
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void threadDied(Object thread) {
        if (this.threadDeathRequestId == 0) {
            return;
        }
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(this.threadDeathSuspendPolicy);
        this.suspend(this.threadDeathSuspendPolicy, thread);
        stream.writeInt(1);
        stream.writeByte((byte)7);
        stream.writeInt(this.threadDeathRequestId);
        stream.writeLong(this.ids.getIdAsLong(thread));
        if (this.holdEvents) {
            this.heldEvents.add(stream);
        } else {
            this.connection.queuePacket(stream);
        }
    }

    @Override
    public void vmStarted(boolean suspend) {
        assert (this.connection != null);
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(suspend ? (byte)2 : 0);
        stream.writeInt(1);
        stream.writeByte((byte)90);
        stream.writeInt(this.vmStartRequestId != -1 ? this.vmStartRequestId : 0);
        stream.writeLong(this.context.getIds().getIdAsLong(this.initialThread));
        this.connection.queuePacket(stream);
    }

    @Override
    public boolean vmDied() {
        if (this.connection == null) {
            return false;
        }
        PacketStream stream = new PacketStream().commandPacket().commandSet(64).command(100);
        stream.writeByte(this.vmDeathSuspendPolicy);
        if (this.vmDeathRequestId != 0) {
            stream.writeInt(2);
            stream.writeByte((byte)99);
            stream.writeInt(this.vmDeathRequestId);
        } else {
            stream.writeInt(1);
        }
        stream.writeByte((byte)99);
        stream.writeInt(0);
        this.connection.queuePacket(stream);
        return this.vmDeathSuspendPolicy != 0;
    }

    @Override
    public void addClassUnloadRequestId(int id) {
        this.debuggerController.fine(() -> "class unload events not yet implemented!");
    }

    @Override
    public void addThreadStartedRequestId(int id, byte suspendPolicy) {
        this.debuggerController.fine(() -> "Adding thread start listener");
        this.threadStartedRequestId = id;
        this.threadStartSuspendPolicy = suspendPolicy;
    }

    @Override
    public void addThreadDiedRequestId(int id, byte suspendPolicy) {
        this.debuggerController.fine(() -> "Adding thread death listener");
        this.threadDeathRequestId = id;
        this.threadDeathSuspendPolicy = suspendPolicy;
    }

    @Override
    public void removeThreadStartedRequestId() {
        this.threadStartSuspendPolicy = 0;
        this.threadStartedRequestId = 0;
    }

    @Override
    public void removeThreadDiedRequestId() {
        this.threadDeathSuspendPolicy = 0;
        this.threadDeathRequestId = 0;
    }

    @Override
    public void addVMDeathRequest(int id, byte suspendPolicy) {
        this.vmDeathRequestId = id;
        this.vmDeathSuspendPolicy = suspendPolicy;
    }

    @Override
    public void addVMStartRequest(int id) {
        this.vmStartRequestId = id;
    }

    @Override
    public void holdEvents() {
        this.holdEvents = true;
    }

    @Override
    public void releaseEvents() {
        this.holdEvents = false;
        for (PacketStream heldEvent : this.heldEvents) {
            this.connection.queuePacket(heldEvent);
        }
    }

    private void suspend(byte suspendPolicy, Object thread) {
        switch (suspendPolicy) {
            case 0: {
                return;
            }
            case 1: {
                this.debuggerController.suspend(thread);
                return;
            }
            case 2: {
                this.debuggerController.suspendAll();
            }
        }
    }
}

