/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.SourceLocation;

final class DebuggerCommand {
    final Kind kind;
    private final RequestFilter requestFilter;
    private SourceLocation location;
    private BreakpointInfo breakpointInfo;
    private volatile boolean submitted;

    DebuggerCommand(Kind kind, RequestFilter filter) {
        this.kind = kind;
        this.requestFilter = filter;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void markSubmitted() {
        this.submitted = true;
    }

    void setSourceLocation(SourceLocation location) {
        this.location = location;
    }

    public SourceLocation getSourceLocation() {
        return this.location;
    }

    public RequestFilter getRequestFilter() {
        return this.requestFilter;
    }

    public void setBreakpointInfo(BreakpointInfo info) {
        this.breakpointInfo = info;
    }

    public BreakpointInfo getBreakpointInfo() {
        return this.breakpointInfo;
    }

    static enum Kind {
        STEP_INTO,
        STEP_OVER,
        STEP_OUT,
        SUBMIT_LINE_BREAKPOINT,
        SUBMIT_EXCEPTION_BREAKPOINT,
        SPECIAL_STEP;

    }
}

