/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.CommandResult;
import com.oracle.truffle.espresso.jdwp.impl.Commands;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerCommand;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.JDWP;
import com.oracle.truffle.espresso.jdwp.impl.LineBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.Packet;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.RequestedJDWPEvents;
import com.oracle.truffle.espresso.jdwp.impl.SocketConnection;
import com.oracle.truffle.espresso.jdwp.impl.SourceLocation;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public final class DebuggerConnection
implements Commands {
    private final DebuggerController controller;
    private final JDWPContext context;
    private final SocketConnection connection;

    private DebuggerConnection(SocketConnection connection, DebuggerController controller) {
        this.connection = connection;
        this.controller = controller;
        this.context = controller.getContext();
    }

    static void establishDebuggerConnection(DebuggerController controller, DebuggerController.SetupState setupState, boolean isReconnect, CountDownLatch startupLatch) {
        Thread jdwpReceiver = new Thread((Runnable)new JDWPReceiver(controller, setupState, isReconnect, startupLatch), "jdwp-receiver");
        controller.addDebuggerReceiverThread(jdwpReceiver);
        jdwpReceiver.setDaemon(true);
        jdwpReceiver.start();
    }

    public void dispose() {
        this.connection.dispose();
    }

    public void closeSocket() {
        this.connection.closeSocket();
    }

    @Override
    public void stepInto(Object thread, RequestFilter filter) {
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_INTO);
    }

    @Override
    public void stepOver(Object thread, RequestFilter filter) {
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_OVER);
    }

    @Override
    public void stepOut(Object thread, RequestFilter filter) {
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_OUT);
        this.controller.stepOut(filter);
    }

    @Override
    public Callable<Void> createLineBreakpointCommand(BreakpointInfo info) {
        return () -> {
            LineBreakpointInfo lineInfo = (LineBreakpointInfo)info;
            DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.SUBMIT_LINE_BREAKPOINT, info.getFilter());
            debuggerCommand.setSourceLocation(new SourceLocation(lineInfo.getSlashName(), (int)lineInfo.getLine(), this.context));
            debuggerCommand.setBreakpointInfo(info);
            this.controller.submitLineBreakpoint(debuggerCommand);
            return null;
        };
    }

    @Override
    public Callable<Void> createExceptionBreakpoint(BreakpointInfo info) {
        return () -> {
            DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.SUBMIT_EXCEPTION_BREAKPOINT, null);
            debuggerCommand.setBreakpointInfo(info);
            this.controller.submitExceptionBreakpoint(debuggerCommand);
            return null;
        };
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    private static CommandResult unknownCommandSet(Packet packet, DebuggerController controller) {
        controller.warning(() -> "Unknown command set: " + packet.cmdSet);
        return DebuggerConnection.notImplemented(packet);
    }

    private static CommandResult unknownCommand(Packet packet, DebuggerController controller) {
        controller.warning(() -> "Unknown command " + packet.cmd + " in command set " + packet.cmdSet);
        return DebuggerConnection.notImplemented(packet);
    }

    private static CommandResult notImplemented(Packet packet) {
        PacketStream reply = new PacketStream().replyPacket().id(packet.id);
        reply.errorCode(99);
        return new CommandResult(reply);
    }

    void handleReply(Packet packet, CommandResult result) {
        if (result == null) {
            return;
        }
        if (result.getPreFutures() != null) {
            try {
                for (Callable<Void> future : result.getPreFutures()) {
                    if (future == null) continue;
                    future.call();
                }
            }
            catch (Exception e) {
                this.controller.warning(() -> "Failed to run future for command(" + packet.cmdSet + "." + packet.cmd + ")");
            }
        }
        if (result.getReply() != null) {
            this.controller.fine(() -> "replying to command(" + packet.cmdSet + "." + packet.cmd + ")");
            this.connection.queuePacket(result.getReply());
        } else {
            this.controller.warning(() -> "no result for command(" + packet.cmdSet + "." + packet.cmd + ")");
        }
        if (result.getPostFutures() != null) {
            try {
                for (Callable<Void> future : result.getPostFutures()) {
                    if (future == null) continue;
                    future.call();
                }
            }
            catch (Exception e) {
                this.controller.severe(() -> "Failed to run future for command(" + packet.cmdSet + "." + packet.cmd + ")");
            }
        }
    }

    private static class JDWPReceiver
    implements Runnable {
        private DebuggerController.SetupState setupState;
        private final DebuggerController controller;
        private RequestedJDWPEvents requestedJDWPEvents;
        private DebuggerConnection debuggerConnection;
        private final boolean isReconnect;
        private final CountDownLatch latch;

        JDWPReceiver(DebuggerController controller, DebuggerController.SetupState setupState, boolean isReconnect, CountDownLatch latch) {
            this.setupState = setupState;
            this.controller = controller;
            this.requestedJDWPEvents = new RequestedJDWPEvents(controller);
            this.isReconnect = isReconnect;
            this.latch = latch;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void processPacket(Packet packet) {
            JDWPContext context = this.controller.getContext();
            CommandResult result = null;
            try {
                if (packet.flags == 128) {
                    this.controller.warning(() -> "Should not get any reply packet from debugger");
                } else {
                    this.controller.fine(() -> "received command(" + packet.cmdSet + "." + packet.cmd + ")");
                    block1 : switch (packet.cmdSet) {
                        case 1: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.VirtualMachine.VERSION.createReply(packet, this.controller.getVirtualMachine());
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.VirtualMachine.CLASSES_BY_SIGNATURE.createReply(packet, this.controller, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.VirtualMachine.ALL_CLASSES.createReply(packet, context, this.controller);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.VirtualMachine.ALL_THREADS.createReply(packet, context, this.controller);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.VirtualMachine.TOP_LEVEL_THREAD_GROUPS.createReply(packet, context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.VirtualMachine.DISPOSE.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.VirtualMachine.IDSIZES.createReply(packet, this.controller.getVirtualMachine());
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.VirtualMachine.SUSPEND.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.VirtualMachine.RESUME.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.VirtualMachine.EXIT.createReply(packet, context, this.controller);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.VirtualMachine.CREATE_STRING.createReply(packet, context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.VirtualMachine.CAPABILITIES.createReply(packet);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.VirtualMachine.CLASS_PATHS.createReply(packet, context);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.VirtualMachine.DISPOSE_OBJECTS.createReply(packet);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.VirtualMachine.HOLD_EVENTS.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 16: {
                                    result = JDWP.VirtualMachine.RELEASE_EVENTS.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 17: {
                                    result = JDWP.VirtualMachine.CAPABILITIES_NEW.createReply(packet);
                                    break block1;
                                }
                                case 18: {
                                    result = JDWP.VirtualMachine.REDEFINE_CLASSES.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 19: {
                                    result = JDWP.VirtualMachine.SET_DEFAULT_STRATUM.createReply(packet);
                                    break block1;
                                }
                                case 20: {
                                    result = JDWP.VirtualMachine.ALL_CLASSES_WITH_GENERIC.createReply(packet, context);
                                    break block1;
                                }
                                case 21: {
                                    result = JDWP.VirtualMachine.INSTANCE_COUNTS.createReply(packet);
                                    break block1;
                                }
                                case 22: {
                                    result = JDWP.VirtualMachine.ALL_MODULES.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 2: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ReferenceType.SIGNATURE.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ReferenceType.CLASSLOADER.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ReferenceType.MODIFIERS.createReply(packet, context);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ReferenceType.FIELDS.createReply(packet, context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ReferenceType.METHODS.createReply(packet, context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ReferenceType.GET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ReferenceType.SOURCE_FILE.createReply(packet, context);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ReferenceType.NESTED_TYPES.createReply(packet, context);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ReferenceType.STATUS.createReply(packet, context);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ReferenceType.INTERFACES.createReply(packet, context);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.ReferenceType.CLASS_OBJECT.createReply(packet, context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.ReferenceType.SOURCE_DEBUG_EXTENSION.createReply(packet, context);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.ReferenceType.SIGNATURE_WITH_GENERIC.createReply(packet, context);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.ReferenceType.FIELDS_WITH_GENERIC.createReply(packet, context);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.ReferenceType.METHODS_WITH_GENERIC.createReply(packet, context);
                                    break block1;
                                }
                                case 16: {
                                    result = JDWP.ReferenceType.INSTANCES.createReply(packet);
                                    break block1;
                                }
                                case 17: {
                                    result = JDWP.ReferenceType.CLASS_FILE_VERSION.createReply(packet, context);
                                    break block1;
                                }
                                case 18: {
                                    result = JDWP.ReferenceType.CONSTANT_POOL.createReply(packet, context);
                                    break block1;
                                }
                                case 19: {
                                    result = JDWP.ReferenceType.MODULE.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 3: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassType.SUPERCLASS.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ClassType.SET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ClassType.INVOKE_METHOD.createReply(packet, this.controller, this.debuggerConnection);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ClassType.NEW_INSTANCE.createReply(packet, this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 4: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ArrayType.NEW_INSTANCE.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 5: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.InterfaceType.INVOKE_METHOD.createReply(packet, this.controller, this.debuggerConnection);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 6: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.Methods.LINE_TABLE.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.Methods.VARIABLE_TABLE.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.Methods.BYTECODES.createReply(packet, context);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.Methods.IS_OBSOLETE.createReply(packet, context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.Methods.VARIABLE_TABLE_WITH_GENERIC.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 9: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ObjectReference.REFERENCE_TYPE.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ObjectReference.GET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ObjectReference.SET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ObjectReference.MONITOR_INFO.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ObjectReference.INVOKE_METHOD.createReply(packet, this.controller, this.debuggerConnection);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ObjectReference.DISABLE_COLLECTION.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ObjectReference.ENABLE_COLLECTION.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ObjectReference.IS_COLLECTED.createReply(packet, context);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ObjectReference.REFERRING_OBJECTS.createReply(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 10: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.StringReference.VALUE.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 11: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ThreadReference.NAME.createReply(packet, this.controller, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ThreadReference.SUSPEND.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ThreadReference.RESUME.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ThreadReference.STATUS.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ThreadReference.THREAD_GROUP.createReply(packet, context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ThreadReference.FRAMES.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ThreadReference.FRAME_COUNT.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ThreadReference.OWNED_MONITORS.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ThreadReference.CURRENT_CONTENDED_MONITOR.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ThreadReference.STOP.createReply(packet, context);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.ThreadReference.INTERRUPT.createReply(packet, context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.ThreadReference.SUSPEND_COUNT.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.ThreadReference.OWNED_MONITORS_STACK_DEPTH_INFO.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.ThreadReference.FORCE_EARLY_RETURN.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.ThreadReference.IS_VIRTUAL.createReply(packet, this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 12: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ThreadGroupReference.NAME.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ThreadGroupReference.PARENT.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ThreadGroupReference.CHILDREN.createReply(packet, context, this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 13: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ArrayReference.LENGTH.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ArrayReference.GET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ArrayReference.SET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 14: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassLoaderReference.VISIBLE_CLASSES.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 15: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = this.requestedJDWPEvents.registerEvent(packet, this.debuggerConnection);
                                    break block1;
                                }
                                case 2: {
                                    result = this.requestedJDWPEvents.clearRequest(packet);
                                    break block1;
                                }
                                case 3: {
                                    result = this.requestedJDWPEvents.clearAllRequests(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 16: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.StackFrame.GET_VALUES.createReply(packet, context, this.controller);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.StackFrame.SET_VALUES.createReply(packet, context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.StackFrame.THIS_OBJECT.createReply(packet, this.controller);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.StackFrame.POP_FRAMES.createReply(packet, this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 17: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassObjectReference.REFLECTED_TYPE.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 18: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ModuleReference.NAME.createReply(packet, context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ModuleReference.CLASSLOADER.createReply(packet, context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        case 64: {
                            switch (packet.cmd) {
                                case 100: {
                                    result = JDWP.Event.COMPOSITE.createReply(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.unknownCommand(packet, this.controller);
                            break;
                        }
                        default: {
                            result = DebuggerConnection.unknownCommandSet(packet, this.controller);
                        }
                    }
                }
                this.debuggerConnection.handleReply(packet, result);
            }
            catch (Throwable t) {
                this.controller.severe("Internal error while processing packet", t);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.errorCode(113);
                this.debuggerConnection.handleReply(packet, new CommandResult(reply));
            }
        }

        private static /* synthetic */ String lambda$run$0(IOException e) {
            return "Failed to process jdwp packet with message: " + e.getMessage();
        }
    }

    private static class JDWPSender
    implements Runnable {
        private final SocketConnection socketConnection;

        JDWPSender(SocketConnection socketConnection) {
            this.socketConnection = socketConnection;
        }

        @Override
        public void run() {
            this.socketConnection.sendPackets();
        }
    }
}

