/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;

final class HandshakeController {
    private static final String JDWP_HANDSHAKE = "JDWP-Handshake";
    private ServerSocket currentServerSocket;

    HandshakeController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupInitialConnection(DebuggerController controller) throws IOException {
        DebuggerController.SetupState result;
        String connectionHost = controller.getHost();
        int port = controller.getListeningPort();
        if (controller.isServer()) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setSoTimeout(0);
            if (port != 0) {
                serverSocket.setReuseAddress(true);
            }
            if (connectionHost == null) {
                serverSocket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
            } else if ("*".equals(connectionHost)) {
                serverSocket.bind(new InetSocketAddress((InetAddress)null, port));
            } else {
                serverSocket.bind(new InetSocketAddress(connectionHost, port));
            }
            String address = controller.getHost() != null ? controller.getHost() + ":" + serverSocket.getLocalPort() : "" + serverSocket.getLocalPort();
            System.out.println("Listening for transport dt_socket at address: " + address);
            HandshakeController handshakeController = this;
            synchronized (handshakeController) {
                assert (this.currentServerSocket == null);
                this.currentServerSocket = serverSocket;
            }
            result = new DebuggerController.SetupState(null, serverSocket, false);
        } else {
            try {
                controller.getResettingLock().lockInterruptibly();
                result = !controller.isClosing() ? new DebuggerController.SetupState(new Socket(connectionHost, port), null, false) : new DebuggerController.SetupState(null, null, true);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                controller.getResettingLock().unlock();
            }
        }
        controller.setSetupState(result);
    }

    synchronized void close() {
        if (this.currentServerSocket != null) {
            if (!this.currentServerSocket.isClosed()) {
                try {
                    this.currentServerSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close the server socket used to listen for transport dt_socket", e);
                }
            }
            this.currentServerSocket = null;
        }
    }

    static boolean handshake(Socket s) throws IOException {
        int n;
        byte[] hello = JDWP_HANDSHAKE.getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[hello.length];
        for (int received = 0; received < hello.length; received += n) {
            try {
                n = s.getInputStream().read(b, received, hello.length - received);
            }
            catch (SocketTimeoutException x) {
                throw new IOException("handshake timeout");
            }
            if (n >= 0) continue;
            s.close();
            throw new IOException("handshake failed - connection prematurely closed");
        }
        for (int i = 0; i < hello.length; ++i) {
            if (b[i] == hello[i]) continue;
            throw new IOException("handshake failed - unrecognized message from the debugger");
        }
        s.getOutputStream().write(hello);
        return true;
    }
}

