/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import java.util.concurrent.Callable;

public final class InvokeJob<T> {
    private final Object jobLock = new Object();
    private final Object thread;
    private final Callable<T> callable;
    private final byte suspensionStrategy;
    private boolean resultAvailable;
    private JobResult<T> result;

    public InvokeJob(Object guestThread, Callable<T> task) {
        this(guestThread, task, 1);
    }

    public InvokeJob(Object guestThread, Callable<T> task, byte suspensionStrategy) {
        this.thread = guestThread;
        this.callable = task;
        this.suspensionStrategy = suspensionStrategy;
    }

    public Object getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(DebuggerController controller) {
        block19: {
            Object[] visibleGuestThreads = controller.getVisibleGuestThreads();
            this.result = new JobResult();
            try {
                if (this.suspensionStrategy == 2) {
                    controller.getIds().unpinAll();
                    for (Object activeThread : visibleGuestThreads) {
                        if (activeThread == this.thread) continue;
                        controller.resume(activeThread);
                    }
                }
                this.result.setResult(this.callable.call());
                if (this.suspensionStrategy != 2) break block19;
                controller.getIds().pinAll();
            }
            catch (Throwable throwable) {
                block20: {
                    try {
                        this.result.setException(throwable);
                        if (this.suspensionStrategy != 2) break block20;
                        controller.getIds().pinAll();
                    }
                    catch (Throwable throwable2) {
                        if (this.suspensionStrategy == 2) {
                            controller.getIds().pinAll();
                            for (Object activeThread : visibleGuestThreads) {
                                if (activeThread == this.thread) continue;
                                controller.suspend(activeThread);
                            }
                        }
                        this.resultAvailable = true;
                        Object object = this.jobLock;
                        synchronized (object) {
                            this.jobLock.notifyAll();
                        }
                        throw throwable2;
                    }
                    for (Object activeThread : visibleGuestThreads) {
                        if (activeThread == this.thread) continue;
                        controller.suspend(activeThread);
                    }
                }
                this.resultAvailable = true;
                Object object = this.jobLock;
                synchronized (object) {
                    this.jobLock.notifyAll();
                }
            }
            for (Object activeThread : visibleGuestThreads) {
                if (activeThread == this.thread) continue;
                controller.suspend(activeThread);
            }
        }
        this.resultAvailable = true;
        Object object = this.jobLock;
        synchronized (object) {
            this.jobLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResult<T> getResult() {
        while (!this.resultAvailable && !Thread.currentThread().isInterrupted()) {
            Object object = this.jobLock;
            synchronized (object) {
                try {
                    this.jobLock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.result;
    }

    public class JobResult<C> {
        private C result;
        private Throwable exception;

        public C getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        private void setResult(C obj) {
            this.result = obj;
        }

        private void setException(Throwable throwable) {
            this.exception = throwable;
        }
    }
}

