/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class SocketConnection {
    private static final PacketStream DISPOSE_PACKET = new PacketStream();
    private final Socket socket;
    private final OutputStream socketOutput;
    private final InputStream socketInput;
    private final BlockingQueue<PacketStream> queue = new ArrayBlockingQueue<PacketStream>(4096);

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    public void dispose() {
        this.queue.add(DISPOSE_PACKET);
    }

    public void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    public void sendPackets() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                PacketStream stream = this.queue.take();
                if (stream == DISPOSE_PACKET) break;
                byte[] shipment = stream.prepareForShipment();
                this.writePacket(shipment);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException ex) {
                if (!this.isOpen()) break;
                throw new RuntimeException("Failed sending packet to debugger instance", ex);
            }
        }
    }

    public void queuePacket(PacketStream stream) {
        if (this.isOpen()) {
            this.queue.add(stream);
        }
    }

    public byte[] readPacket() throws IOException {
        int b1 = this.socketInput.read();
        int b2 = this.socketInput.read();
        int b3 = this.socketInput.read();
        int b4 = this.socketInput.read();
        if (b1 < 0) {
            return new byte[0];
        }
        if (b2 < 0 || b3 < 0 || b4 < 0) {
            throw new IOException("protocol error - premature EOF");
        }
        int len = b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
        if (len < 0) {
            throw new IOException("protocol error - invalid length");
        }
        byte[] b = new byte[len];
        b[0] = (byte)b1;
        b[1] = (byte)b2;
        b[2] = (byte)b3;
        b[3] = (byte)b4;
        int off = 4;
        len -= off;
        while (len > 0) {
            int count = this.socketInput.read(b, off, len);
            if (count < 0) {
                throw new IOException("protocol error - premature EOF");
            }
            len -= count;
            off += count;
        }
        return b;
    }

    public void writePacket(byte[] b) throws IOException {
        if (b.length < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int len = b0 << 24 | b1 << 16 | b2 << 8 | b3 << 0;
        if (len < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        if (len > b.length) {
            throw new IllegalArgumentException("length mis-match");
        }
        this.socketOutput.write(b, 0, len);
    }
}

