/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.DebuggerCommand;

public final class SteppingInfo {
    private final int requestId;
    private final byte suspendPolicy;
    private long stepOutBCI = -1L;
    private long stepOutMethodId = -1L;
    private long stepOutKlassId = -1L;
    private final boolean isPopFrames;
    private final boolean isForceEarlyReturn;
    private final DebuggerCommand.Kind stepKind;
    private boolean submitted;

    SteppingInfo(int requestId, byte suspendPolicy, boolean isPopFrames, boolean isForceEarlyReturn, DebuggerCommand.Kind stepKind) {
        this.requestId = requestId;
        this.suspendPolicy = suspendPolicy;
        this.isPopFrames = isPopFrames;
        this.isForceEarlyReturn = isForceEarlyReturn;
        this.stepKind = stepKind;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    public void setStepOutBCI(long klassId, long methodId, long stepOutBCI) {
        this.stepOutKlassId = klassId;
        this.stepOutMethodId = methodId;
        this.stepOutBCI = stepOutBCI;
    }

    public long getStepOutBCI() {
        return this.stepOutBCI;
    }

    public boolean isPopFrames() {
        return this.isPopFrames;
    }

    public boolean isForceEarlyReturn() {
        return this.isForceEarlyReturn;
    }

    public boolean isStepOutFrame(long methodId, long klassId) {
        return this.stepOutMethodId == methodId && this.stepOutKlassId == klassId;
    }

    public DebuggerCommand.Kind getStepKind() {
        return this.stepKind;
    }

    public void submit() {
        this.submitted = true;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }
}

