/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.jni.GlobalHandles;
import com.oracle.truffle.espresso.jni.LocalHandles;
import com.oracle.truffle.espresso.jni.WeakHandles;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.function.Supplier;

public final class JNIHandles {
    static final int NATIVE_CALL_MIN_LOCAL_HANDLE_CAPACITY = 16;
    private final WeakHandles<Field> fieldIds = new WeakHandles();
    private final WeakHandles<Method> methodIds = new WeakHandles();
    private final ThreadLocal<LocalHandles> locals;
    private final GlobalHandles globals = new GlobalHandles();

    public JNIHandles() {
        this.locals = ThreadLocal.withInitial(new Supplier<LocalHandles>(){

            @Override
            public LocalHandles get() {
                return new LocalHandles();
            }
        });
    }

    public int nativeCallPrologue() {
        return this.getLocals().pushFrame(16);
    }

    public void nativeCallEpilogue(int handleFrame) {
        this.getLocals().popFramesIncluding(handleFrame);
    }

    @CompilerDirectives.TruffleBoundary
    LocalHandles getLocals() {
        return this.locals.get();
    }

    GlobalHandles getGlobals() {
        return this.globals;
    }

    public StaticObject get(int handle) {
        if (handle == 0) {
            return StaticObject.NULL;
        }
        if (handle > 0) {
            return this.getLocals().get(handle);
        }
        assert (handle != Integer.MIN_VALUE);
        return this.getGlobals().get(-handle);
    }

    public int createLocal(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        int handle = this.getLocals().create(obj);
        assert (handle > 0);
        return handle;
    }

    public int createGlobal(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        int handle = -this.getGlobals().create(obj);
        assert (handle < 0);
        assert (handle != Integer.MIN_VALUE) : "Invalid handle";
        return handle;
    }

    public int createWeakGlobal(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        int handle = -this.getGlobals().createWeakGlobal(obj);
        assert (handle < 0);
        assert (handle != Integer.MIN_VALUE);
        return handle;
    }

    public void deleteLocalRef(int handle) {
        if (handle == 0) {
            return;
        }
        assert (handle > 0);
        this.getLocals().deleteLocalRef(handle);
    }

    public void deleteGlobalRef(int handle) {
        if (handle == 0) {
            return;
        }
        assert (handle < 0);
        assert (handle != Integer.MIN_VALUE);
        this.getGlobals().destroy(-handle);
    }

    public static int toIntHandle(long value) {
        if ((long)((int)value) != value) {
            throw new IllegalArgumentException(JNIHandles.handleErrorString(value));
        }
        return (int)value;
    }

    @CompilerDirectives.TruffleBoundary
    private static String handleErrorString(long value) {
        return String.format("Bad handle: 0x%x", value);
    }

    public int getObjectRefType(int handle) {
        if (handle > 0) {
            assert (this.getLocals().validHandle(handle));
            return 1;
        }
        if (handle < 0) {
            return this.getGlobals().getObjectRefType(-handle);
        }
        return 0;
    }

    public void popFramesIncluding(int frame) {
        this.getLocals().popFramesIncluding(frame);
    }

    public int pushFrame(int capacity) {
        return this.getLocals().pushFrame(capacity);
    }

    public void popFrame() {
        this.getLocals().popFrame();
    }

    public int pushFrame() {
        return this.pushFrame(16);
    }

    public WeakHandles<Field> fieldIds() {
        return this.fieldIds;
    }

    public WeakHandles<Method> methodIds() {
        return this.methodIds;
    }
}

