/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.espresso.classfile.JavaVersion;

public final class JniVersion
extends Enum<JniVersion> {
    public static final /* enum */ JniVersion JNI_VERSION_1_1 = new JniVersion(65537);
    public static final /* enum */ JniVersion JNI_VERSION_1_2 = new JniVersion(65538);
    public static final /* enum */ JniVersion JNI_VERSION_1_4 = new JniVersion(65540);
    public static final /* enum */ JniVersion JNI_VERSION_1_6 = new JniVersion(65542);
    public static final /* enum */ JniVersion JNI_VERSION_1_8 = new JniVersion(65544);
    public static final /* enum */ JniVersion JNI_VERSION_9 = new JniVersion(589824);
    public static final /* enum */ JniVersion JNI_VERSION_10 = new JniVersion(655360);
    public static final /* enum */ JniVersion JNI_VERSION_19 = new JniVersion(0x130000);
    public static final /* enum */ JniVersion JNI_VERSION_20 = new JniVersion(0x140000);
    public static final /* enum */ JniVersion JNI_VERSION_21 = new JniVersion(0x150000);
    private final int version;
    private static final /* synthetic */ JniVersion[] $VALUES;

    public static JniVersion[] values() {
        return (JniVersion[])$VALUES.clone();
    }

    public static JniVersion valueOf(String name) {
        return Enum.valueOf(JniVersion.class, name);
    }

    private JniVersion(int version) {
        this.version = version;
    }

    public int version() {
        return this.version;
    }

    public JavaVersion getJavaVersion() {
        int major = this.version >> 16 & 0xFFFF;
        int minor = this.version & 0xFFFF;
        if (major == 1) {
            return JavaVersion.forVersion(minor);
        }
        return JavaVersion.forVersion(major);
    }

    public static JniVersion decodeVersion(int encoded) {
        for (JniVersion version : JniVersion.values()) {
            if (version.version != encoded) continue;
            return version;
        }
        return null;
    }

    public static JniVersion getJniVersion(JavaVersion javaVersion) {
        JniVersion latestSupportedJniVersion = null;
        for (JniVersion version : JniVersion.values()) {
            assert (latestSupportedJniVersion == null || latestSupportedJniVersion.getJavaVersion().compareTo(version.getJavaVersion()) < 0);
            if (version.getJavaVersion().compareTo(javaVersion) > 0) continue;
            latestSupportedJniVersion = version;
        }
        assert (latestSupportedJniVersion != null);
        return latestSupportedJniVersion;
    }

    private static /* synthetic */ JniVersion[] $values() {
        return new JniVersion[]{JNI_VERSION_1_1, JNI_VERSION_1_2, JNI_VERSION_1_4, JNI_VERSION_1_6, JNI_VERSION_1_8, JNI_VERSION_9, JNI_VERSION_10, JNI_VERSION_19, JNI_VERSION_20, JNI_VERSION_21};
    }

    static {
        $VALUES = JniVersion.$values();
    }
}

