/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;

final class LocalHandles {
    private static final int INITIAL_NUMBER_OF_FRAMES = 8;
    private StaticObject[] objects = new StaticObject[128];
    private int top = 1;
    private int[] frameStack = new int[8];
    private int frameCount = 0;

    LocalHandles() {
    }

    public int pushFrame(int capacity) {
        if (this.frameCount == this.frameStack.length) {
            int[] oldArray = this.frameStack;
            this.frameStack = Arrays.copyOf(oldArray, Math.multiplyExact(oldArray.length, 2));
        }
        this.frameStack[this.frameCount] = this.top;
        ++this.frameCount;
        this.ensureCapacity(capacity);
        return this.frameCount;
    }

    public void popFrame() {
        this.popFramesIncluding(this.frameCount);
    }

    public void popFramesIncluding(int frame) {
        assert (frame > 0 && frame <= this.frameCount);
        int previousTop = this.top;
        this.frameCount = frame - 1;
        for (int i = this.top = this.frameStack[this.frameCount]; i < previousTop; ++i) {
            this.objects[i] = null;
        }
    }

    public void ensureCapacity(int capacity) {
        int targetCapacity = this.objects.length;
        while (this.top + capacity >= targetCapacity) {
            targetCapacity = Math.multiplyExact(targetCapacity, 2);
        }
        if (targetCapacity > this.objects.length) {
            StaticObject[] oldArray = this.objects;
            assert (targetCapacity >= this.top + capacity);
            this.objects = new StaticObject[targetCapacity];
            System.arraycopy(oldArray, 0, this.objects, 0, oldArray.length);
        }
    }

    public StaticObject get(int handle) {
        if (handle == 0) {
            return StaticObject.NULL;
        }
        assert (this.validHandle(handle));
        assert (this.objects[handle] != null);
        return this.objects[handle];
    }

    public int create(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        this.ensureCapacity(1);
        int handle = this.top++;
        this.objects[handle] = obj;
        return handle;
    }

    public void deleteLocalRef(int handle) {
        assert (handle > 0);
        this.objects[handle] = null;
    }

    public boolean validHandle(int handle) {
        return handle > 0 && handle < this.top;
    }
}

