/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.MetaUtil;

public final class Mangle {
    public static final char LONG_NAME_DELIMITER = ' ';

    private Mangle() {
    }

    private static String mangle(String name) {
        return Mangle.mangle(name, false);
    }

    private static String mangle(String name, boolean isTruffleMangle) {
        StringBuilder mangledName = new StringBuilder(100);
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (Mangle.isAlphaNumeric(ch)) {
                mangledName.append(ch);
                continue;
            }
            if (ch == '_') {
                mangledName.append("_1");
                continue;
            }
            if (ch == '.') {
                mangledName.append("_");
                continue;
            }
            if (ch == ';') {
                mangledName.append("_2");
                continue;
            }
            if (ch == '[') {
                mangledName.append("_3");
                continue;
            }
            if (isTruffleMangle && ch == '$') {
                mangledName.append(ch);
                continue;
            }
            mangledName.append(Mangle.mangleChar(ch));
        }
        return mangledName.toString();
    }

    public static String mangleMethod(Method method, boolean withSignature) {
        return Mangle.mangleMethod(method.getDeclaringKlass().getType(), method.getName().toString(), withSignature ? method.getRawSignature() : null, false);
    }

    public static String mangleMethod(Symbol<Symbol.Type> declaringClass, String name, Symbol<Symbol.Signature> signature, boolean splitSuffix) {
        StringBuilder result = new StringBuilder(100);
        String declaringClassName = MetaUtil.internalNameToJava(declaringClass.toString(), true, false);
        result.append("Java_").append(Mangle.mangle(declaringClassName)).append('_').append(Mangle.mangle(name));
        if (signature != null) {
            if (splitSuffix) {
                result.append(' ');
            }
            result.append("__");
            String sig = signature.toString();
            String parametersSignature = sig.substring(1, sig.lastIndexOf(41)).replace('/', '.').replace('$', '.');
            result.append(Mangle.mangle(parametersSignature));
        }
        return result.toString();
    }

    public static String truffleJniMethodName(String methodName, Symbol<Symbol.Signature> signature) {
        assert (signature != null);
        StringBuilder result = new StringBuilder(100);
        result.append(Mangle.mangle(methodName)).append("__");
        String sig = signature.toString();
        String returnType = sig.substring(sig.lastIndexOf(41) + 1).replace('/', '.');
        result.append(Mangle.mangle(returnType, true));
        String parametersSignature = sig.substring(1, sig.lastIndexOf(41)).replace('/', '.');
        result.append(Mangle.mangle(parametersSignature, true));
        return result.toString();
    }

    private static String mangleChar(char ch) {
        String s = Integer.toHexString(ch);
        assert (s.length() <= 4);
        return "_0" + String.format("%4s", s).replace(' ', '0');
    }

    private static boolean isAlphaNumeric(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9';
    }
}

