/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.meta.EspressoError;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public final class RawBuffer
implements AutoCloseable {
    private ByteBuffer buffer;
    private TruffleObject pointer;

    public RawBuffer(ByteBuffer buffer, TruffleObject pointer) {
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public static RawBuffer getNativeString(ByteSequence seq) {
        ByteBuffer bb = NativeUtils.allocateDirect(seq.length() + 1);
        seq.writeTo(bb);
        bb.put((byte)0);
        return new RawBuffer(bb, NativeUtils.byteBufferPointer(bb));
    }

    public static RawBuffer getNativeString(String name) {
        block4: {
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            int length = (int)((float)name.length() * encoder.averageBytesPerChar()) + 1;
            while (true) {
                if (length <= 0) {
                    throw EspressoError.shouldNotReachHere();
                }
                ByteBuffer bb = NativeUtils.allocateDirect(length);
                encoder.reset();
                CoderResult result = encoder.encode(CharBuffer.wrap(name), bb, true);
                if (result.isOverflow()) {
                    length <<= 1;
                    continue;
                }
                if (!result.isUnderflow()) break block4;
                result = encoder.flush(bb);
                if (result.isUnderflow() && bb.position() < bb.capacity()) {
                    bb.put((byte)0);
                    return new RawBuffer(bb, NativeUtils.byteBufferPointer(bb));
                }
                if (!result.isOverflow() && !result.isUnderflow()) break;
                ++length;
            }
            throw EspressoError.shouldNotReachHere();
        }
        throw EspressoError.shouldNotReachHere();
    }

    public TruffleObject pointer() {
        return this.pointer;
    }

    @Override
    public void close() {
        this.buffer.clear();
        this.buffer = null;
    }
}

