/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Locale;

public final class EspressoError
extends Error {
    static final String UNREACHABLE_MESSAGE = "EspressoError.* host exception is reachable.\nThrow it behind a @TruffleBoundary or deopt with CompilerDirectives.transferToInterpreterAndInvalidate();";
    private static final long serialVersionUID = 2625263796982958128L;

    public static RuntimeException unimplemented() {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("unimplemented");
    }

    public static RuntimeException unimplemented(String message) {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("unimplemented: " + message);
    }

    public static RuntimeException fatal(String message) {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("fatal: " + message);
    }

    public static RuntimeException shouldNotReachHere() {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("should not reach here");
    }

    public static RuntimeException shouldNotReachHere(String message) {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("should not reach here: " + message);
    }

    public static RuntimeException shouldNotReachHere(String message, Throwable cause) {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("should not reach here: " + message, cause);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause) {
        CompilerAsserts.neverPartOfCompilation((String)UNREACHABLE_MESSAGE);
        throw new EspressoError("should not reach here", cause);
    }

    public static RuntimeException fatal(Object ... msg) {
        CompilerAsserts.neverPartOfCompilation();
        throw new EspressoError("fatal: " + EspressoError.cat(msg));
    }

    @CompilerDirectives.TruffleBoundary
    public static String cat(Object ... strs) {
        StringBuilder res = new StringBuilder();
        for (Object str : strs) {
            res.append(str);
        }
        return res.toString();
    }

    public static void guarantee(boolean condition, String message) {
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new EspressoError("failed guarantee: " + message);
        }
    }

    public static void guarantee(boolean condition, String message, Object additionalContext) {
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new EspressoError("failed guarantee: " + message + " " + String.valueOf(additionalContext));
        }
    }

    private EspressoError(String message) {
        super(message);
    }

    private EspressoError(String message, Throwable cause) {
        super(message, cause);
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(String msg, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Iterable)) continue;
                ArrayList list = new ArrayList();
                for (Object o : (Iterable)args[i]) {
                    list.add(o);
                }
                args[i] = list.toString();
            }
        }
        return String.format(Locale.ENGLISH, msg, args);
    }
}

