/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

public final class ExceptionDispatch
extends ContextAccessImpl {
    private final Meta meta;
    private final ObjectKlass runtimeException;

    public ExceptionDispatch(Meta meta) {
        super(meta.getContext());
        this.meta = meta;
        this.runtimeException = meta.java_lang_RuntimeException;
    }

    StaticObject initEx(ObjectKlass klass, StaticObject message, StaticObject cause) {
        if (!CompilerDirectives.inInterpreter() && CompilerDirectives.isPartialEvaluationConstant((Object)klass) && StaticObject.isNull(klass.getDefiningClassLoader()) && this.runtimeException.isAssignableFrom(klass)) {
            return this.fastPath(klass, message, cause);
        }
        return this.slowPath(klass, message, cause);
    }

    private StaticObject fastPath(ObjectKlass klass, StaticObject message, StaticObject cause) {
        StaticObject ex = this.allocateException(klass);
        InterpreterToVM.fillInStackTrace(ex, this.meta);
        if (this.meta.java_lang_NullPointerException == klass && this.meta.java_lang_NullPointerException_extendedMessageState != null) {
            this.meta.java_lang_NullPointerException_extendedMessageState.setInt(ex, 1);
        }
        if (message != null) {
            this.meta.java_lang_Throwable_detailMessage.setObject(ex, message);
        }
        if (cause != null) {
            this.meta.java_lang_Throwable_cause.setObject(ex, cause);
        }
        return ex;
    }

    private StaticObject allocateException(ObjectKlass klass) {
        EspressoContext ctx = this.getContext();
        assert (!klass.isAbstract() && !klass.isInterface());
        return ctx.getAllocator().createNew(klass);
    }

    private StaticObject slowPath(ObjectKlass klass, StaticObject message, StaticObject cause) {
        assert (this.meta.java_lang_Throwable.isAssignableFrom(klass));
        StaticObject ex = this.allocateException(klass);
        this.slowInitEx(ex, klass, message, cause);
        return ex;
    }

    private void slowInitEx(StaticObject ex, ObjectKlass klass, StaticObject message, StaticObject cause) {
        if (message == null && cause == null) {
            ExceptionDispatch.doInit(ex, klass);
        } else if (message != null && cause == null) {
            assert (StaticObject.isNull(message) || this.meta.java_lang_String.isAssignableFrom(message.getKlass()));
            ExceptionDispatch.doMessageInit(ex, klass, message);
        } else if (message == null) {
            assert (StaticObject.isNull(cause) || this.meta.java_lang_Throwable.isAssignableFrom(cause.getKlass()));
            ExceptionDispatch.doCauseInit(ex, klass, cause);
        } else {
            assert (StaticObject.isNull(cause) || this.meta.java_lang_Throwable.isAssignableFrom(cause.getKlass()));
            assert (StaticObject.isNull(message) || this.meta.java_lang_String.isAssignableFrom(message.getKlass()));
            ExceptionDispatch.doFullInit(ex, klass, message, cause);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void doFullInit(StaticObject ex, ObjectKlass klass, StaticObject message, StaticObject cause) {
        klass.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_String_Throwable).invokeDirectSpecial(ex, message, cause);
    }

    @CompilerDirectives.TruffleBoundary
    private static void doCauseInit(StaticObject ex, ObjectKlass klass, StaticObject cause) {
        klass.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_Throwable).invokeDirectSpecial(ex, cause);
    }

    @CompilerDirectives.TruffleBoundary
    private static void doMessageInit(StaticObject ex, ObjectKlass klass, StaticObject message) {
        klass.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_String).invokeDirectSpecial(ex, message);
    }

    @CompilerDirectives.TruffleBoundary
    private static void doInit(StaticObject ex, ObjectKlass klass) {
        klass.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void).invokeDirectSpecial(ex);
    }
}

