/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public class MetaUtil {
    public static String getSimpleName(Class<?> clazz, boolean withEnclosingClass) {
        String simpleName = null;
        try {
            simpleName = clazz.getSimpleName();
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        if (simpleName != null && simpleName.length() != 0) {
            if (withEnclosingClass) {
                Object prefix = "";
                Class<?> enclosingClass = clazz;
                while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
                    prefix = enclosingClass.getSimpleName() + "." + (String)prefix;
                }
                return (String)prefix + simpleName;
            }
            return simpleName;
        }
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    @CompilerDirectives.TruffleBoundary
    public static String internalNameToJava(String name, boolean qualified, boolean classForNameCompatible) {
        switch (name.charAt(0)) {
            case 'L': {
                int lastDot;
                String result = name.substring(1, name.length() - 1).replace('/', '.');
                if (!qualified && (lastDot = result.lastIndexOf(46)) != -1) {
                    result = result.substring(lastDot + 1);
                }
                return result;
            }
            case '[': {
                return classForNameCompatible ? name.replace('/', '.') : MetaUtil.internalNameToJava(name.substring(1), qualified, classForNameCompatible) + "[]";
            }
        }
        if (name.length() != 1) {
            throw new IllegalArgumentException("Illegal internal name: " + name);
        }
        return JavaKind.fromPrimitiveOrVoidTypeChar(name.charAt(0)).getJavaName();
    }

    public static String toInternalName(String className) {
        if (className.startsWith("L") && className.endsWith(";")) {
            return className.replace('.', '/');
        }
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        StringBuilder result = new StringBuilder();
        String base = className;
        while (base.endsWith("[]")) {
            result.append("[");
            base = base.substring(0, base.length() - 2);
        }
        switch (base) {
            case "boolean": {
                result.append("Z");
                break;
            }
            case "byte": {
                result.append("B");
                break;
            }
            case "short": {
                result.append("S");
                break;
            }
            case "char": {
                result.append("C");
                break;
            }
            case "int": {
                result.append("I");
                break;
            }
            case "float": {
                result.append("F");
                break;
            }
            case "long": {
                result.append("J");
                break;
            }
            case "double": {
                result.append("D");
                break;
            }
            case "void": {
                result.append("V");
                break;
            }
            default: {
                result.append("L").append(base.replace('.', '/')).append(";");
            }
        }
        return result.toString();
    }

    public static String identityHashCodeString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }

    public static Object unwrapArrayOrNull(EspressoLanguage language, StaticObject object) {
        if (StaticObject.isNull(object)) {
            return null;
        }
        if (object.isArray()) {
            return object.unwrap(language);
        }
        return object;
    }

    public static Object maybeUnwrapNull(StaticObject object) {
        if (StaticObject.isNull(object)) {
            return null;
        }
        return object;
    }

    public static Object defaultFieldValue(JavaKind kind) {
        switch (kind) {
            case Object: {
                return StaticObject.NULL;
            }
            case Float: {
                return Float.valueOf(0.0f);
            }
            case Double: {
                return 0.0;
            }
            case Long: {
                return 0L;
            }
            case Char: {
                return Character.valueOf('\u0000');
            }
            case Short: {
                return (short)0;
            }
            case Int: {
                return 0;
            }
            case Byte: {
                return (byte)0;
            }
            case Boolean: {
                return false;
            }
        }
        CompilerAsserts.neverPartOfCompilation();
        throw EspressoError.shouldNotReachHere("Invalid field type " + String.valueOf((Object)kind));
    }

    public static int defaultWordFieldValue(JavaKind kind) {
        switch (kind) {
            case Char: {
                return 0;
            }
            case Short: {
                return 0;
            }
            case Int: {
                return 0;
            }
            case Byte: {
                return 0;
            }
            case Boolean: {
                return 0;
            }
        }
        CompilerAsserts.neverPartOfCompilation();
        throw EspressoError.shouldNotReachHere("Invalid Word field type " + String.valueOf((Object)kind));
    }
}

