/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.analysis.liveness.LivenessAnalysis;
import com.oracle.truffle.espresso.bytecode.MapperBCI;
import com.oracle.truffle.espresso.classfile.ExceptionHandler;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.bytecode.VolatileArrayAccess;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DoubleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FloatConstant;
import com.oracle.truffle.espresso.classfile.constantpool.IntegerConstant;
import com.oracle.truffle.espresso.classfile.constantpool.LongConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.constantpool.Resolution;
import com.oracle.truffle.espresso.constantpool.ResolvedDynamicConstant;
import com.oracle.truffle.espresso.constantpool.ResolvedWithInvokerClassMethodRefConstant;
import com.oracle.truffle.espresso.constantpool.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoBaseStatementNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.EspressoStatementNode;
import com.oracle.truffle.espresso.nodes.helper.EspressoReferenceArrayStoreNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MHInvokeGenericNode;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNode;
import com.oracle.truffle.espresso.nodes.quick.CheckCastQuickNode;
import com.oracle.truffle.espresso.nodes.quick.InstanceOfQuickNode;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ArrayLengthQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ByteArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ByteArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.CharArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.CharArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.DoubleArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.DoubleArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.FloatArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.FloatArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.IntArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.IntArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.LongArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.LongArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.QuickenedGetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.interop.QuickenedPutFieldNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ReferenceArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ReferenceArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ShortArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ShortArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeContinuableNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeDynamicCallSiteNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeHandleNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeInterfaceQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeSpecialQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeStaticQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeVirtualQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.resolver.CallKind;
import com.oracle.truffle.espresso.resolver.CallSiteType;
import com.oracle.truffle.espresso.resolver.FieldAccessType;
import com.oracle.truffle.espresso.resolver.LinkResolver;
import com.oracle.truffle.espresso.resolver.ResolvedCall;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.continuation.HostFrameRecord;
import com.oracle.truffle.espresso.vm.continuation.UnwindContinuationException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BytecodeNode
extends AbstractInstrumentableBytecodeNode
implements BytecodeOSRNode,
GuestAllocator.AllocationProfiler {
    private static final DebugCounter EXECUTED_BYTECODES_COUNT = DebugCounter.create("Executed bytecodes");
    private static final DebugCounter QUICKENED_BYTECODES = DebugCounter.create("Quickened bytecodes");
    private static final DebugCounter QUICKENED_INVOKES = DebugCounter.create("Quickened invokes (excluding INDY)");
    private static final byte TRIVIAL_UNINITIALIZED = -1;
    private static final byte TRIVIAL_NO = 0;
    private static final byte TRIVIAL_YES = 1;
    private static final int REPORT_LOOP_STRIDE = 256;
    @Node.Children
    private BaseQuickNode[] nodes = BaseQuickNode.EMPTY_ARRAY;
    @Node.Children
    private BaseQuickNode[] sparseNodes = BaseQuickNode.EMPTY_ARRAY;
    @Node.Child
    private volatile EspressoReferenceArrayStoreNode refArrayStoreNode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] stackOverflowErrorInfo;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private volatile int[][] jsrBci = null;
    private final BytecodeStream bs;
    @CompilerDirectives.CompilationFinal
    private EspressoRootNode rootNode;
    @Node.Child
    private volatile InstrumentationSupport instrumentation;
    private final Assumption noForeignObjects;
    @CompilerDirectives.CompilationFinal
    private boolean implicitExceptionProfile;
    @CompilerDirectives.CompilationFinal
    private boolean linkageExceptionProfile;
    private final LivenessAnalysis livenessAnalysis;
    private byte trivialBytecodesCache = (byte)-1;
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;
    private final FrameDescriptor frameDescriptor;
    private final Method.MethodVersion methodVersion;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] code;
    private final int returnValueBci;
    private final int throwValueBci;

    public BytecodeNode(Method.MethodVersion methodVersion) {
        CompilerAsserts.neverPartOfCompilation();
        Method method = methodVersion.getMethod();
        assert (method.hasBytecodes());
        this.methodVersion = methodVersion;
        byte[] originalCode = method.getOriginalCode();
        byte[] customCode = Arrays.copyOf(originalCode, originalCode.length + 2);
        this.returnValueBci = originalCode.length;
        customCode[this.returnValueBci] = -51;
        this.throwValueBci = originalCode.length + 1;
        customCode[this.throwValueBci] = -50;
        this.code = customCode;
        this.bs = new BytecodeStream(this.code);
        this.stackOverflowErrorInfo = method.getSOEHandlerInfo();
        this.frameDescriptor = EspressoFrame.createFrameDescriptor(methodVersion.getMaxLocals(), methodVersion.getMaxStackSize());
        this.noForeignObjects = Truffle.getRuntime().createAssumption("noForeignObjects");
        this.implicitExceptionProfile = false;
        this.livenessAnalysis = methodVersion.getLivenessAnalysis();
        this.trivialBytecodesCache = (byte)(originalCode.length <= method.getContext().getEspressoEnv().TrivialMethodSize ? -1 : 0);
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    Source getSource() {
        return this.getMethodVersion().getSource();
    }

    public SourceSection getSourceSectionAtBCI(int bci) {
        return this.getMethodVersion().getSourceSectionAtBCI(bci);
    }

    @ExplodeLoop
    private void initArguments(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        boolean hasReceiver = !this.getMethod().isStatic();
        int receiverSlot = hasReceiver ? 1 : 0;
        int curSlot = 0;
        if (hasReceiver) {
            assert (StaticObject.notNull((StaticObject)arguments[0])) : "null receiver in init arguments !";
            StaticObject receiver = (StaticObject)arguments[0];
            EspressoFrame.setLocalObject((Frame)frame, curSlot, receiver);
            this.checkNoForeignObjectAssumption(receiver);
            curSlot += JavaKind.Object.getSlotCount();
        }
        Symbol<Symbol.Type>[] methodSignature = this.getMethod().getParsedSignature();
        int argCount = Signatures.parameterCount(methodSignature);
        CompilerAsserts.partialEvaluationConstant((int)argCount);
        for (int i = 0; i < argCount; ++i) {
            Symbol<Symbol.Type> argType = Signatures.parameterType(methodSignature, i);
            switch (argType.byteAt(0)) {
                case 90: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, (Boolean)arguments[i + receiverSlot] != false ? 1 : 0);
                    break;
                }
                case 66: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Byte)arguments[i + receiverSlot]).byteValue());
                    break;
                }
                case 83: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Short)arguments[i + receiverSlot]).shortValue());
                    break;
                }
                case 67: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Character)arguments[i + receiverSlot]).charValue());
                    break;
                }
                case 73: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, (Integer)arguments[i + receiverSlot]);
                    break;
                }
                case 70: {
                    EspressoFrame.setLocalFloat((Frame)frame, curSlot, ((Float)arguments[i + receiverSlot]).floatValue());
                    break;
                }
                case 74: {
                    EspressoFrame.setLocalLong((Frame)frame, curSlot, (Long)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case 68: {
                    EspressoFrame.setLocalDouble((Frame)frame, curSlot, (Double)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case 76: 
                case 91: {
                    StaticObject argument = (StaticObject)arguments[i + receiverSlot];
                    EspressoFrame.setLocalObject((Frame)frame, curSlot, argument);
                    this.checkNoForeignObjectAssumption(argument);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
            ++curSlot;
        }
    }

    public void createContinuableNode(int bci, int top) {
        int opcode = this.bs.opcode(bci);
        if (opcode == 203 && this.nodes[this.bs.readCPI2(bci)] instanceof InvokeContinuableNode) {
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        while (true) {
            if ((opcode = this.bs.volatileOpcode(bci)) == 203) {
                assert (this.nodes[this.bs.readCPI2(bci)] instanceof InvokeQuickNode);
                InvokeQuickNode quick = (InvokeQuickNode)this.nodes[this.bs.readCPI2(bci)];
                while (!(quick instanceof InvokeContinuableNode)) {
                    InvokeContinuableNode icn = new InvokeContinuableNode(top, bci, quick);
                    quick = (InvokeQuickNode)this.replaceQuickAt(opcode, bci, quick, icn);
                }
                return;
            }
            InstrumentationSupport instrument = this.instrumentation;
            int statementIndex = instrument == null ? -1 : instrument.getStartStatementIndex(bci);
            this.quickenInvoke(top, bci, opcode, statementIndex);
        }
    }

    @Override
    public Object resumeContinuation(VirtualFrame frame, int bci, int top) {
        int statementIndex;
        CompilerAsserts.partialEvaluationConstant((int)bci);
        CompilerAsserts.partialEvaluationConstant((int)top);
        this.createContinuableNode(bci, top);
        InstrumentationSupport instrument = this.instrumentation;
        int n = statementIndex = instrument == null ? -1 : instrument.getStartStatementIndex(bci);
        assert (this.bs.opcode(bci) == 203 && this.nodes[this.bs.readCPI2(bci)] instanceof InvokeContinuableNode);
        return this.executeBodyFromBCI(frame, bci, top, statementIndex, true, true);
    }

    public void checkNoForeignObjectAssumption(StaticObject object) {
        if (this.noForeignObjects.isValid() && object.isForeignObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.noForeignObjects.invalidate();
        }
    }

    @Override
    void initializeFrame(VirtualFrame frame) {
        EspressoFrame.setBCI((Frame)frame, -1);
        this.initArguments(frame);
        EspressoFrame.setBCI((Frame)frame, 0);
    }

    public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterState) {
        EspressoOSRInterpreterState state = (EspressoOSRInterpreterState)interpreterState;
        return this.executeBodyFromBCI(osrFrame, target, state.top, state.statementIndex, true, false);
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    public void prepareOSR(int target) {
        this.getRoot();
    }

    public void copyIntoOSRFrame(VirtualFrame frame, VirtualFrame parentFrame, int target, Object entryMetadata) {
        super.copyIntoOSRFrame(frame, parentFrame, target, entryMetadata);
        EspressoFrame.setBCI((Frame)frame, target);
    }

    public void restoreParentFrame(VirtualFrame osrFrame, VirtualFrame parentFrame) {
        super.restoreParentFrame(osrFrame, parentFrame);
        EspressoFrame.setBCI((Frame)parentFrame, this.getBci((Frame)osrFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        int startTop = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
        if (this.methodVersion.hasJsr()) {
            this.getLanguage().getThreadLocalState().blockContinuationSuspension();
        }
        try {
            int statementIndex = this.instrumentation == null ? -1 : this.instrumentation.getStartStatementIndex(0);
            Object object = this.executeBodyFromBCI(frame, 0, startTop, statementIndex, false, false);
            return object;
        }
        finally {
            if (this.methodVersion.hasJsr()) {
                this.getLanguage().getThreadLocalState().unblockContinuationSuspension();
            }
        }
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private Object executeBodyFromBCI(VirtualFrame frame, int startBCI, int startTop, int startStatementIndex, boolean isOSR, boolean resumeContinuation) {
        CompilerAsserts.partialEvaluationConstant((int)startBCI);
        InstrumentationSupport instrument = this.instrumentation;
        int statementIndex = startStatementIndex;
        boolean skipLivenessActions = instrument != null;
        boolean shouldResumeContinuation = resumeContinuation;
        Counter loopCount = new Counter();
        EspressoFrame.setBCI((Frame)frame, startBCI);
        int curBCI = startBCI;
        int top = startTop;
        if (instrument != null) {
            if (resumeContinuation) {
                instrument.notifyResume(frame, this);
                instrument.notifyStatementResume(frame, statementIndex);
            } else if (!isOSR) {
                instrument.notifyEntry(frame, this);
                instrument.notifyStatementEnter(frame, statementIndex);
            }
        }
        if (!isOSR) {
            this.livenessAnalysis.onStart(frame, skipLivenessActions);
        }
        block155: while (true) {
            int nextStatementIndex;
            int curOpcode = this.bs.opcode(curBCI);
            EXECUTED_BYTECODES_COUNT.inc();
            try {
                CompilerAsserts.partialEvaluationConstant((int)top);
                CompilerAsserts.partialEvaluationConstant((int)curBCI);
                CompilerAsserts.partialEvaluationConstant((int)curOpcode);
                CompilerAsserts.partialEvaluationConstant((int)statementIndex);
                assert (statementIndex == -1 || curBCI == this.returnValueBci || curBCI == this.throwValueBci || statementIndex == this.instrumentation.hookBCIToNodeIndex.lookupBucket(curBCI));
                if (instrument != null || Bytecodes.canTrap(curOpcode)) {
                    EspressoFrame.setBCI((Frame)frame, curBCI);
                }
                switch (curOpcode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        EspressoFrame.putObject((Frame)frame, top, StaticObject.NULL);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        EspressoFrame.putInt((Frame)frame, top, curOpcode - 3);
                        break;
                    }
                    case 9: 
                    case 10: {
                        EspressoFrame.putLong((Frame)frame, top, curOpcode - 9);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        EspressoFrame.putFloat((Frame)frame, top, curOpcode - 11);
                        break;
                    }
                    case 14: 
                    case 15: {
                        EspressoFrame.putDouble((Frame)frame, top, curOpcode - 14);
                        break;
                    }
                    case 16: {
                        EspressoFrame.putInt((Frame)frame, top, this.bs.readByte(curBCI));
                        break;
                    }
                    case 17: {
                        EspressoFrame.putInt((Frame)frame, top, this.bs.readShort(curBCI));
                        break;
                    }
                    case 18: {
                        this.putPoolConstant(frame, top, this.bs.readCPI1(curBCI), curOpcode);
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.putPoolConstant(frame, top, this.bs.readCPI2(curBCI), curOpcode);
                        break;
                    }
                    case 21: {
                        EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 22: {
                        EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 23: {
                        EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 24: {
                        EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 25: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, curOpcode - 26));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, curOpcode - 30));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, curOpcode - 34));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, curOpcode - 38));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 42: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, 0));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 43: 
                    case 44: 
                    case 45: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, curOpcode - 42));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: {
                        this.arrayLoad(frame, top, curBCI, curOpcode);
                        break;
                    }
                    case 50: {
                        this.arrayLoad(frame, top, curBCI, 50);
                        this.checkNoForeignObjectAssumption(EspressoFrame.peekObject((Frame)frame, top - 2));
                        break;
                    }
                    case 54: {
                        EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popInt((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 55: {
                        EspressoFrame.setLocalLong((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popLong((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 56: {
                        EspressoFrame.setLocalFloat((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popFloat((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 57: {
                        EspressoFrame.setLocalDouble((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popDouble((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 58: {
                        EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        EspressoFrame.setLocalInt((Frame)frame, curOpcode - 59, EspressoFrame.popInt((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: {
                        EspressoFrame.setLocalLong((Frame)frame, curOpcode - 63, EspressoFrame.popLong((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        EspressoFrame.setLocalFloat((Frame)frame, curOpcode - 67, EspressoFrame.popFloat((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        EspressoFrame.setLocalDouble((Frame)frame, curOpcode - 71, EspressoFrame.popDouble((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, curOpcode - 75, EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        this.arrayStore(frame, top, curBCI, curOpcode);
                        break;
                    }
                    case 88: {
                        EspressoFrame.clear((Frame)frame, top - 1);
                        EspressoFrame.clear((Frame)frame, top - 2);
                        break;
                    }
                    case 87: {
                        EspressoFrame.clear((Frame)frame, top - 1);
                        break;
                    }
                    case 89: {
                        EspressoFrame.dup1((Frame)frame, top);
                        break;
                    }
                    case 90: {
                        EspressoFrame.dupx1((Frame)frame, top);
                        break;
                    }
                    case 91: {
                        EspressoFrame.dupx2((Frame)frame, top);
                        break;
                    }
                    case 92: {
                        EspressoFrame.dup2((Frame)frame, top);
                        break;
                    }
                    case 93: {
                        EspressoFrame.dup2x1((Frame)frame, top);
                        break;
                    }
                    case 94: {
                        EspressoFrame.dup2x2((Frame)frame, top);
                        break;
                    }
                    case 95: {
                        EspressoFrame.swapSingle((Frame)frame, top);
                        break;
                    }
                    case 96: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) + EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 97: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) + EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 98: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 1) + EspressoFrame.popFloat((Frame)frame, top - 2));
                        break;
                    }
                    case 99: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 1) + EspressoFrame.popDouble((Frame)frame, top - 3));
                        break;
                    }
                    case 100: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 2) - EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 101: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 3) - EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 102: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 2) - EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 103: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 3) - EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 104: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) * EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 105: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) * EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 106: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 1) * EspressoFrame.popFloat((Frame)frame, top - 2));
                        break;
                    }
                    case 107: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 1) * EspressoFrame.popDouble((Frame)frame, top - 3));
                        break;
                    }
                    case 108: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.divInt(this.checkNonZero(EspressoFrame.popInt((Frame)frame, top - 1)), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 109: {
                        EspressoFrame.putLong((Frame)frame, top - 4, BytecodeNode.divLong(this.checkNonZero(EspressoFrame.popLong((Frame)frame, top - 1)), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 110: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, BytecodeNode.divFloat(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 111: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, BytecodeNode.divDouble(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 112: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.remInt(this.checkNonZero(EspressoFrame.popInt((Frame)frame, top - 1)), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 113: {
                        EspressoFrame.putLong((Frame)frame, top - 4, BytecodeNode.remLong(this.checkNonZero(EspressoFrame.popLong((Frame)frame, top - 1)), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 114: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, BytecodeNode.remFloat(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 115: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, BytecodeNode.remDouble(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 116: {
                        EspressoFrame.putInt((Frame)frame, top - 1, -EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 117: {
                        EspressoFrame.putLong((Frame)frame, top - 2, -EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 118: {
                        EspressoFrame.putFloat((Frame)frame, top - 1, -EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 119: {
                        EspressoFrame.putDouble((Frame)frame, top - 2, -EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 120: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftLeftInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 121: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftLeftLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 122: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftRightSignedInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 123: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftRightSignedLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 124: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftRightUnsignedInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 125: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftRightUnsignedLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 126: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) & EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 127: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) & EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 128: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) | EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 129: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) | EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 130: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) ^ EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 131: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) ^ EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 132: {
                        EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI)) + this.bs.readIncrement1(curBCI));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 133: {
                        EspressoFrame.putLong((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 134: {
                        EspressoFrame.putFloat((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 135: {
                        EspressoFrame.putDouble((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 136: {
                        EspressoFrame.putInt((Frame)frame, top - 2, (int)EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 137: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 138: {
                        EspressoFrame.putDouble((Frame)frame, top - 2, EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 139: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (int)EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 140: {
                        EspressoFrame.putLong((Frame)frame, top - 1, (long)EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 141: {
                        EspressoFrame.putDouble((Frame)frame, top - 1, EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 142: {
                        EspressoFrame.putInt((Frame)frame, top - 2, (int)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 143: {
                        EspressoFrame.putLong((Frame)frame, top - 2, (long)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 144: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, (float)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 145: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (byte)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 146: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (char)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 147: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (short)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 148: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareLong(EspressoFrame.popLong((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 149: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.compareFloatLess(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 150: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.compareFloatGreater(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 151: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareDoubleLess(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 152: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareDoubleGreater(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        if (BytecodeNode.takeBranchPrimitive1(EspressoFrame.popInt((Frame)frame, top - 1), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(158), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        if (BytecodeNode.takeBranchPrimitive2(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2), curOpcode)) {
                            statementIndex = this.beforeJumpChecks(frame, curBCI, this.bs.readBranchDest2(curBCI), top += Bytecodes.stackEffectOf(164), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = this.bs.readBranchDest2(curBCI);
                            continue block155;
                        }
                        break;
                    }
                    case 165: 
                    case 166: {
                        if (this.takeBranchRef2(EspressoFrame.popObject((Frame)frame, top - 1), EspressoFrame.popObject((Frame)frame, top - 2), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(166), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                        break;
                    }
                    case 198: 
                    case 199: {
                        if (BytecodeNode.takeBranchRef1(EspressoFrame.popObject((Frame)frame, top - 1), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(199), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                        break;
                    }
                    case 167: {
                        int targetBCI = this.bs.readBranchDest2(curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top, statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 200: {
                        int targetBCI = this.bs.readBranchDest4(curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top, statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 168: {
                        EspressoFrame.putReturnAddress((Frame)frame, top, this.bs.nextBCI(curBCI));
                        int targetBCI = this.bs.readBranchDest2(curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(168), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 201: {
                        EspressoFrame.putReturnAddress((Frame)frame, top, this.bs.nextBCI(curBCI));
                        int targetBCI = this.bs.readBranchDest4(curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(201), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 169: {
                        int[] knownRets;
                        int retOpBci = curBCI;
                        int targetBCI = EspressoFrame.getLocalReturnAddress((Frame)frame, this.bs.readLocalIndex1(curBCI));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        int[][] knownTargets = this.jsrBci;
                        if (knownTargets == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.atomic(() -> {
                                if (this.jsrBci == null) {
                                    this.jsrBci = new int[this.bs.endBCI()][];
                                }
                            });
                            knownTargets = this.jsrBci;
                        }
                        if ((knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci)) == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.atomic(() -> {
                                if (VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci) != null) {
                                    return;
                                }
                                int[] targets = new int[]{targetBCI};
                                VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, targets);
                            });
                            knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci);
                        }
                        assert (knownRets != null);
                        for (int jsr : knownRets) {
                            if (jsr != targetBCI) continue;
                            CompilerAsserts.partialEvaluationConstant((int)jsr);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, jsr, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = jsr;
                            continue block155;
                        }
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.atomic(() -> {
                            int[] currentRets;
                            for (int jsr : currentRets = (int[])VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci)) {
                                if (jsr != targetBCI) continue;
                                return;
                            }
                            int[] updatedTargets = Arrays.copyOf(currentRets, currentRets.length + 1);
                            updatedTargets[updatedTargets.length - 1] = targetBCI;
                            VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, updatedTargets);
                        });
                        statementIndex = this.beforeJumpChecks(frame, retOpBci, targetBCI, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 170: {
                        int targetBCI;
                        int index = EspressoFrame.popInt((Frame)frame, top - 1);
                        BytecodeTableSwitch switchHelper = BytecodeTableSwitch.INSTANCE;
                        int low = switchHelper.lowKey(this.bs, curBCI);
                        int high = switchHelper.highKey(this.bs, curBCI);
                        assert (low <= high);
                        if (CompilerDirectives.inInterpreter()) {
                            int targetBCI2 = low <= index && index <= high ? switchHelper.targetAt(this.bs, curBCI, index - low) : switchHelper.defaultTarget(this.bs, curBCI);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI2, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI2;
                            continue block155;
                        }
                        for (int i = low; i != high + 1; ++i) {
                            if (i != index) continue;
                            targetBCI = switchHelper.targetAt(this.bs, curBCI, i - low);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                        int targetBCI3 = switchHelper.defaultTarget(this.bs, curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI3, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI3;
                        continue block155;
                    }
                    case 171: {
                        int key = EspressoFrame.popInt((Frame)frame, top - 1);
                        BytecodeLookupSwitch switchHelper = BytecodeLookupSwitch.INSTANCE;
                        int low = 0;
                        int high = switchHelper.numberOfCases(this.bs, curBCI) - 1;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            int midVal = switchHelper.keyAt(this.bs, curBCI, mid);
                            if (midVal < key) {
                                low = mid + 1;
                                continue;
                            }
                            if (midVal > key) {
                                high = mid - 1;
                                continue;
                            }
                            int targetBCI = curBCI + switchHelper.offsetAt(this.bs, curBCI, mid);
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(171), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                        int targetBCI = switchHelper.defaultTarget(this.bs, curBCI);
                        statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(171), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block155;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                            LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                        }
                        Object returnValue = this.getReturnValueAsObject(frame, top);
                        if (instrument != null) {
                            instrument.exitAt(frame, statementIndex, returnValue);
                        }
                        top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                        frame.setObjectStatic(top, returnValue);
                        ++top;
                        curBCI = this.returnValueBci;
                        continue block155;
                    }
                    case 178: {
                        top += this.getField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex, FieldAccessType.GetStatic);
                        break;
                    }
                    case 180: {
                        top += this.getField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex, FieldAccessType.GetInstance);
                        break;
                    }
                    case 179: {
                        top += this.putField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex, FieldAccessType.PutStatic);
                        break;
                    }
                    case 181: {
                        top += this.putField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex, FieldAccessType.PutInstance);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        top += this.quickenInvoke(frame, top, curBCI, curOpcode, statementIndex);
                        break;
                    }
                    case 187: {
                        Klass klass = this.resolveType(187, this.bs.readCPI2(curBCI));
                        EspressoFrame.putObject((Frame)frame, top, this.newReferenceObject(klass));
                        break;
                    }
                    case 188: {
                        byte jvmPrimitiveType = this.bs.readByte(curBCI);
                        int length = EspressoFrame.popInt((Frame)frame, top - 1);
                        EspressoFrame.putObject((Frame)frame, top - 1, this.newPrimitiveArray(jvmPrimitiveType, length));
                        break;
                    }
                    case 189: {
                        EspressoFrame.putObject((Frame)frame, top - 1, this.newReferenceArray(this.resolveType(189, this.bs.readCPI2(curBCI)), EspressoFrame.popInt((Frame)frame, top - 1)));
                        break;
                    }
                    case 190: {
                        this.arrayLength(frame, top, curBCI);
                        break;
                    }
                    case 191: {
                        throw this.getMethod().getMeta().throwException(this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                    }
                    case 192: {
                        StaticObject receiver = EspressoFrame.peekObject((Frame)frame, top - 1);
                        if (!StaticObject.isNull(receiver)) {
                            if (receiver.getKlass() == this.resolveType(192, this.readOriginalCPI(curBCI))) break;
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.quickenCheckCast(frame, top, curBCI, 192);
                        }
                        break;
                    }
                    case 193: {
                        StaticObject receiver = EspressoFrame.popObject((Frame)frame, top - 1);
                        if (StaticObject.isNull(receiver)) {
                            EspressoFrame.putInt((Frame)frame, top - 1, 0);
                            break;
                        }
                        if (receiver.getKlass() == this.resolveType(193, this.readOriginalCPI(curBCI))) {
                            EspressoFrame.putInt((Frame)frame, top - 1, 1);
                            break;
                        }
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        EspressoFrame.putObject((Frame)frame, top - 1, receiver);
                        this.quickenInstanceOf(frame, top, curBCI, 193);
                        break;
                    }
                    case 194: {
                        this.getRoot().monitorEnter(frame, this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                        break;
                    }
                    case 195: {
                        this.getRoot().monitorExit(frame, this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                        break;
                    }
                    case 196: {
                        int targetBCI;
                        int wideOpcode = this.bs.opcode(curBCI + 1);
                        switch (wideOpcode) {
                            case 21: {
                                EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 22: {
                                EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 23: {
                                EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 24: {
                                EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 25: {
                                EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 54: {
                                EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popInt((Frame)frame, top - 1));
                                break;
                            }
                            case 55: {
                                EspressoFrame.setLocalLong((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popLong((Frame)frame, top - 1));
                                break;
                            }
                            case 56: {
                                EspressoFrame.setLocalFloat((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popFloat((Frame)frame, top - 1));
                                break;
                            }
                            case 57: {
                                EspressoFrame.setLocalDouble((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popDouble((Frame)frame, top - 1));
                                break;
                            }
                            case 58: {
                                EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                                break;
                            }
                            case 132: {
                                EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI)) + this.bs.readIncrement2(curBCI));
                                break;
                            }
                            case 169: {
                                int[] knownRets;
                                int retOpBci = curBCI;
                                targetBCI = EspressoFrame.getLocalReturnAddress((Frame)frame, this.bs.readLocalIndex2(curBCI));
                                this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                                int[][] knownTargets = this.jsrBci;
                                if (knownTargets == null) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    this.atomic(() -> {
                                        if (this.jsrBci == null) {
                                            this.jsrBci = new int[this.bs.endBCI()][];
                                        }
                                    });
                                    knownTargets = this.jsrBci;
                                }
                                if ((knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci)) == null) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    this.atomic(() -> {
                                        if (VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci) != null) {
                                            return;
                                        }
                                        int[] targets = new int[]{targetBCI};
                                        VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, targets);
                                    });
                                    knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci);
                                }
                                assert (knownRets != null);
                                for (int jsr : knownRets) {
                                    if (jsr != targetBCI) continue;
                                    CompilerAsserts.partialEvaluationConstant((int)jsr);
                                    statementIndex = this.beforeJumpChecks(frame, curBCI, jsr, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                                    curBCI = jsr;
                                    continue block155;
                                }
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.atomic(() -> {
                                    int[] currentRets;
                                    for (int jsr : currentRets = (int[])VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci)) {
                                        if (jsr != targetBCI) continue;
                                        return;
                                    }
                                    int[] updatedTargets = Arrays.copyOf(currentRets, currentRets.length + 1);
                                    updatedTargets[updatedTargets.length - 1] = targetBCI;
                                    VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, updatedTargets);
                                });
                                statementIndex = this.beforeJumpChecks(frame, retOpBci, targetBCI, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                                curBCI = targetBCI;
                                continue block155;
                            }
                            default: {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                            }
                        }
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        int targetBCI4 = this.bs.nextBCI(curBCI);
                        this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI4, skipLivenessActions);
                        top += Bytecodes.stackEffectOf(wideOpcode);
                        curBCI = targetBCI4;
                        continue block155;
                    }
                    case 197: {
                        top += this.allocateMultiArray(frame, top, this.resolveType(197, this.bs.readCPI2(curBCI)), this.bs.readUByte(curBCI + 3));
                        break;
                    }
                    case 202: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.unimplemented(Bytecodes.nameOf(curOpcode) + " not supported.");
                    }
                    case 186: {
                        top += this.quickenInvokeDynamic(frame, top, curBCI, 186);
                        break;
                    }
                    case 203: {
                        if (this.bs.currentVolatileBC(curBCI) != 203) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            continue block155;
                        }
                        BaseQuickNode quickNode = this.nodes[this.bs.readCPI2(curBCI)];
                        if (quickNode.removedByRedefinition()) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            quickNode = this.getBaseQuickNode(curBCI, top, statementIndex, quickNode);
                        }
                        top += quickNode.execute(frame, shouldResumeContinuation);
                        shouldResumeContinuation = false;
                        break;
                    }
                    case 204: {
                        top += this.sparseNodes[curBCI].execute(frame, false);
                        break;
                    }
                    case 205: {
                        assert (top == EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals()) + 1);
                        assert (curBCI == this.returnValueBci);
                        return frame.getObjectStatic(top - 1);
                    }
                    case 206: {
                        assert (top == EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals()) + 1);
                        assert (curBCI == this.throwValueBci);
                        throw new ThrowOutOfInterpreterLoop((RuntimeException)frame.getObjectStatic(top - 1));
                    }
                    default: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                    }
                }
            }
            catch (UnwindContinuationException unwindContinuationExceptionRequest) {
                this.copyFrameToUnwindRequest(frame, unwindContinuationExceptionRequest, curBCI, top);
                if (instrument != null) {
                    instrument.notifyYieldAt(frame, unwindContinuationExceptionRequest.getContinuation(), statementIndex);
                }
                top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                frame.setObjectStatic(top, (Object)unwindContinuationExceptionRequest);
                ++top;
                curBCI = this.throwValueBci;
                continue;
            }
            catch (AbstractTruffleException | OutOfMemoryError | StackOverflowError e) {
                EspressoException wrappedException;
                CompilerAsserts.partialEvaluationConstant((int)curBCI);
                if (e == this.getContext().getStackOverflow() || e instanceof StackOverflowError) {
                    CompilerDirectives.transferToInterpreter();
                    EspressoException wrappedStackOverflowError = null;
                    wrappedStackOverflowError = e == this.getContext().getStackOverflow() ? (EspressoException)((Object)e) : this.getContext().getStackOverflow();
                    if (this.stackOverflowErrorInfo != null) {
                        for (int i = 0; i < this.stackOverflowErrorInfo.length; i += 3) {
                            if (curBCI < this.stackOverflowErrorInfo[i] || curBCI >= this.stackOverflowErrorInfo[i + 1]) continue;
                            this.clearOperandStack(frame, top);
                            top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                            EspressoFrame.putObject((Frame)frame, top, wrappedStackOverflowError.getGuestException());
                            int targetBCI = this.stackOverflowErrorInfo[i + 2];
                            statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, ++top, statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block155;
                        }
                    }
                    if (instrument != null) {
                        instrument.notifyExceptionAt(frame, (Throwable)((Object)wrappedStackOverflowError), statementIndex);
                    }
                    if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                        LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                    }
                    throw wrappedStackOverflowError;
                }
                if (e instanceof EspressoException) {
                    wrappedException = (EspressoException)((Object)e);
                } else if (e instanceof AbstractTruffleException) {
                    if (e instanceof EspressoExitException) {
                        CompilerDirectives.transferToInterpreter();
                        this.getRoot().abortMonitor(frame);
                        throw e;
                    }
                    assert (this.getContext().getEspressoEnv().Polyglot);
                    Meta meta = this.getMethod().getMeta();
                    meta.polyglot.ForeignException.safeInitialize();
                    wrappedException = EspressoException.wrap(this.getAllocator().createForeignException(this.getContext(), e, InteropLibrary.getUncached((Object)e)), meta);
                } else {
                    assert (e instanceof OutOfMemoryError);
                    CompilerDirectives.transferToInterpreter();
                    wrappedException = this.getContext().getOutOfMemory();
                }
                ExceptionHandler[] handlers = this.getMethodVersion().getExceptionHandlers();
                ExceptionHandler handler = null;
                for (ExceptionHandler toCheck : handlers) {
                    CompilerAsserts.partialEvaluationConstant((Object)toCheck);
                    if (!toCheck.covers(curBCI)) continue;
                    Klass catchType = null;
                    if (!toCheck.isCatchAll()) {
                        catchType = this.resolveType(193, (char)toCheck.catchTypeCPI());
                    }
                    CompilerAsserts.partialEvaluationConstant(catchType);
                    if (catchType != null && !InterpreterToVM.instanceOf(wrappedException.getGuestException(), catchType)) continue;
                    handler = toCheck;
                    break;
                }
                if (handler != null) {
                    TruffleStackTrace.fillIn((Throwable)((Object)wrappedException));
                    this.clearOperandStack(frame, top);
                    top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                    this.checkNoForeignObjectAssumption(wrappedException.getGuestException());
                    EspressoFrame.putObject((Frame)frame, top, wrappedException.getGuestException());
                    int targetBCI = handler.getHandlerBCI();
                    statementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, ++top, statementIndex, instrument, loopCount, skipLivenessActions);
                    curBCI = targetBCI;
                    continue;
                }
                if (instrument != null) {
                    instrument.notifyExceptionAt(frame, (Throwable)((Object)wrappedException), statementIndex);
                }
                if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                    LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                }
                top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                frame.setObjectStatic(top, (Object)wrappedException);
                ++top;
                curBCI = this.throwValueBci;
                continue;
            }
            catch (EspressoOSRReturnException e) {
                if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                    LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                }
                Object returnValue = e.getResultOrRethrow();
                if (instrument != null) {
                    instrument.notifyReturn(frame, statementIndex, returnValue);
                }
                top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                frame.setObjectStatic(top, returnValue);
                ++top;
                curBCI = this.returnValueBci;
                continue;
            }
            catch (ThrowOutOfInterpreterLoop e) {
                throw e.reThrow();
            }
            assert (curOpcode != 196 && curOpcode != 171 && curOpcode != 170);
            int targetBCI = curBCI + Bytecodes.lengthOf(curOpcode);
            this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI, skipLivenessActions);
            if (instrument != null && (nextStatementIndex = instrument.getNextStatementIndex(statementIndex, targetBCI)) != statementIndex) {
                instrument.notifyStatementChange(frame, statementIndex, nextStatementIndex, targetBCI);
                statementIndex = nextStatementIndex;
            }
            top += Bytecodes.stackEffectOf(curOpcode);
            curBCI = targetBCI;
        }
    }

    private void copyFrameToUnwindRequest(VirtualFrame frame, UnwindContinuationException unwindContinuationExceptionRequest, int bci, int top) {
        unwindContinuationExceptionRequest.head = HostFrameRecord.recordFrame(frame, this.getMethodVersion(), bci, top, unwindContinuationExceptionRequest.head);
    }

    @Override
    public void enterNewReference() {
        this.enterImplicitExceptionProfile();
    }

    @Override
    public void enterNewArray() {
        this.enterImplicitExceptionProfile();
    }

    @Override
    public void enterNewMultiArray() {
        this.enterImplicitExceptionProfile();
    }

    private StaticObject newReferenceObject(Klass klass) {
        assert (!klass.isPrimitive()) : "Verifier guarantee";
        GuestAllocator.AllocationChecks.checkCanAllocateNewReference(this.getMethod().getMeta(), klass, true, this);
        return this.getAllocator().createNew((ObjectKlass)klass);
    }

    private StaticObject newPrimitiveArray(byte jvmPrimitiveType, int length) {
        Meta meta = this.getMethod().getMeta();
        GuestAllocator.AllocationChecks.checkCanAllocateArray(meta, length, this);
        return this.getAllocator().createNewPrimitiveArray(meta, jvmPrimitiveType, length);
    }

    private StaticObject newReferenceArray(Klass componentType, int length) {
        GuestAllocator.AllocationChecks.checkCanAllocateArray(this.getMethod().getMeta(), length, this);
        return this.getAllocator().createNewReferenceArray(componentType, length);
    }

    private BaseQuickNode getBaseQuickNode(int curBCI, int top, int statementIndex, BaseQuickNode quickNode) {
        this.getMethod().getContext().getClassRedefinition().check();
        if (quickNode != this.nodes[this.readCPI(curBCI)]) {
            return this.nodes[this.readCPI(curBCI)];
        }
        BytecodeStream original = new BytecodeStream(this.getMethodVersion().getCodeAttribute().getOriginalCode());
        char originalCpi = original.readCPI(curBCI);
        int originalOpcode = original.currentBC(curBCI);
        ResolvedInvoke resolvedInvoke = this.reResolvedInvoke(originalOpcode, originalCpi);
        return (BaseQuickNode)this.atomic(() -> {
            BaseQuickNode newNode;
            char cpi = this.readCPI(curBCI);
            if (quickNode != this.nodes[cpi]) {
                return this.nodes[cpi];
            }
            this.nodes[cpi] = newNode = (BaseQuickNode)this.insert(this.dispatchQuickened(top, curBCI, originalOpcode, statementIndex, resolvedInvoke, this.getMethod().getContext().getEspressoEnv().bytecodeLevelInlining));
            return newNode;
        });
    }

    private Object getReturnValueAsObject(VirtualFrame frame, int top) {
        Symbol<Symbol.Type> returnType = Signatures.returnType(this.getMethod().getParsedSignature());
        switch (returnType.byteAt(0)) {
            case 90: {
                return this.stackIntToBoolean(EspressoFrame.popInt((Frame)frame, top - 1));
            }
            case 66: {
                return (byte)EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 83: {
                return (short)EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 67: {
                return Character.valueOf((char)EspressoFrame.popInt((Frame)frame, top - 1));
            }
            case 73: {
                return EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 74: {
                return EspressoFrame.popLong((Frame)frame, top - 1);
            }
            case 70: {
                return Float.valueOf(EspressoFrame.popFloat((Frame)frame, top - 1));
            }
            case 68: {
                return EspressoFrame.popDouble((Frame)frame, top - 1);
            }
            case 86: {
                return StaticObject.NULL;
            }
            case 76: 
            case 91: {
                return EspressoFrame.popObject((Frame)frame, top - 1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    @ExplodeLoop
    private void clearOperandStack(VirtualFrame frame, int top) {
        int stackStart = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
        for (int slot = top - 1; slot >= stackStart; --slot) {
            EspressoFrame.clear((Frame)frame, slot);
        }
    }

    @Override
    Method.MethodVersion getMethodVersion() {
        return this.methodVersion;
    }

    private ObjectKlass getDeclaringKlass() {
        return this.methodVersion.getDeclaringKlass();
    }

    private EspressoRootNode getRoot() {
        if (this.rootNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.rootNode = (EspressoRootNode)this.getRootNode();
        }
        return this.rootNode;
    }

    @Override
    public int getBci(Frame frame) {
        return EspressoFrame.getBCI(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        InstrumentationSupport info = this.instrumentation;
        if (info == null && materializedTags.contains(StandardTags.StatementTag.class)) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                info = this.instrumentation;
                if (info == null) {
                    this.generifyBytecodeLevelInlining();
                    this.instrumentation = info = (InstrumentationSupport)this.insert(new InstrumentationSupport(this.getMethodVersion()));
                    this.notifyInserted(info);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this;
    }

    private static boolean takeBranchRef1(StaticObject operand, int opcode) {
        assert (198 <= opcode && opcode <= 199);
        switch (opcode) {
            case 198: {
                return StaticObject.isNull(operand);
            }
            case 199: {
                return StaticObject.notNull(operand);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expected IFNULL or IFNONNULL bytecode");
    }

    private static boolean takeBranchPrimitive1(int operand, int opcode) {
        assert (153 <= opcode && opcode <= 158);
        switch (opcode) {
            case 153: {
                return operand == 0;
            }
            case 154: {
                return operand != 0;
            }
            case 155: {
                return operand < 0;
            }
            case 156: {
                return operand >= 0;
            }
            case 157: {
                return operand > 0;
            }
            case 158: {
                return operand <= 0;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IFEQ,IFNE,IFLT,IFGE,IFGT,IFLE");
    }

    private static boolean takeBranchPrimitive2(int operand1, int operand2, int opcode) {
        assert (159 <= opcode && opcode <= 164);
        switch (opcode) {
            case 159: {
                return operand1 == operand2;
            }
            case 160: {
                return operand1 != operand2;
            }
            case 161: {
                return operand1 > operand2;
            }
            case 162: {
                return operand1 <= operand2;
            }
            case 163: {
                return operand1 < operand2;
            }
            case 164: {
                return operand1 >= operand2;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IF_ICMPEQ,IF_ICMPNE,IF_ICMPLT,IF_ICMPGE,IF_ICMPGT,IF_ICMPLE");
    }

    private boolean takeBranchRef2(StaticObject operand1, StaticObject operand2, int opcode) {
        assert (165 <= opcode && opcode <= 166);
        if (this.noForeignObjects.isValid()) {
            switch (opcode) {
                case 165: {
                    return operand1 == operand2;
                }
                case 166: {
                    return operand1 != operand2;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("expecting IF_ACMPEQ,IF_ACMPNE");
        }
        boolean equal = InterpreterToVM.referenceIdentityEqual(operand1, operand2, this.getLanguage());
        switch (opcode) {
            case 165: {
                return equal;
            }
            case 166: {
                return !equal;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IF_ACMPEQ,IF_ACMPNE");
    }

    private void arrayLength(VirtualFrame frame, int top, int curBCI) {
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoFrame.putInt((Frame)frame, top - 1, InterpreterToVM.arrayLength(array, this.getLanguage()));
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putObject((Frame)frame, top - 1, array);
            this.quickenArrayLength(frame, top, curBCI);
        }
    }

    private void arrayLoad(VirtualFrame frame, int top, int curBCI, int loadOpcode) {
        assert (46 <= loadOpcode && loadOpcode <= 53);
        CompilerAsserts.partialEvaluationConstant((int)loadOpcode);
        int index = EspressoFrame.popInt((Frame)frame, top - 1);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 2));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoLanguage language = this.getLanguage();
            switch (loadOpcode) {
                case 51: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayByte(language, index, array, this));
                    break;
                }
                case 53: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayShort(language, index, array, this));
                    break;
                }
                case 52: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayChar(language, index, array, this));
                    break;
                }
                case 46: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayInt(language, index, array, this));
                    break;
                }
                case 48: {
                    EspressoFrame.putFloat((Frame)frame, top - 2, this.getInterpreterToVM().getArrayFloat(language, index, array, this));
                    break;
                }
                case 47: {
                    EspressoFrame.putLong((Frame)frame, top - 2, this.getInterpreterToVM().getArrayLong(language, index, array, this));
                    break;
                }
                case 49: {
                    EspressoFrame.putDouble((Frame)frame, top - 2, this.getInterpreterToVM().getArrayDouble(language, index, array, this));
                    break;
                }
                case 50: {
                    EspressoFrame.putObject((Frame)frame, top - 2, this.getInterpreterToVM().getArrayObject(language, index, array, this));
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putInt((Frame)frame, top - 1, index);
            EspressoFrame.putObject((Frame)frame, top - 2, array);
            this.quickenArrayLoad(frame, top, curBCI, loadOpcode);
        }
    }

    private void arrayStore(VirtualFrame frame, int top, int curBCI, int storeOpcode) {
        assert (79 <= storeOpcode && storeOpcode <= 86);
        CompilerAsserts.partialEvaluationConstant((int)storeOpcode);
        int offset = storeOpcode == 80 || storeOpcode == 82 ? 2 : 1;
        int index = EspressoFrame.popInt((Frame)frame, top - 1 - offset);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 2 - offset));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoLanguage language = this.getLanguage();
            switch (storeOpcode) {
                case 84: {
                    this.getInterpreterToVM().setArrayByte(language, (byte)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 86: {
                    this.getInterpreterToVM().setArrayShort(language, (short)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 85: {
                    this.getInterpreterToVM().setArrayChar(language, (char)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 79: {
                    this.getInterpreterToVM().setArrayInt(language, EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 81: {
                    this.getInterpreterToVM().setArrayFloat(language, EspressoFrame.popFloat((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 80: {
                    this.getInterpreterToVM().setArrayLong(language, EspressoFrame.popLong((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 82: {
                    this.getInterpreterToVM().setArrayDouble(language, EspressoFrame.popDouble((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 83: {
                    this.referenceArrayStore(frame, top, index, array);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putInt((Frame)frame, top - 1 - offset, index);
            EspressoFrame.putObject((Frame)frame, top - 2 - offset, array);
            this.quickenArrayStore(frame, top, curBCI, storeOpcode);
        }
    }

    private void referenceArrayStore(VirtualFrame frame, int top, int index, StaticObject array) {
        if (this.refArrayStoreNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.atomic(() -> {
                if (this.refArrayStoreNode == null) {
                    this.refArrayStoreNode = (EspressoReferenceArrayStoreNode)this.insert(new EspressoReferenceArrayStoreNode());
                }
            });
        }
        this.refArrayStoreNode.arrayStore(this.getLanguage(), this.getMethod().getMeta(), EspressoFrame.popObject((Frame)frame, top - 1), index, array);
    }

    private int beforeJumpChecks(VirtualFrame frame, int curBCI, int targetBCI, int top, int statementIndex, InstrumentationSupport instrument, Counter loopCount, boolean skipLivenessActions) {
        int nextStatementIndex;
        CompilerAsserts.partialEvaluationConstant((int)targetBCI);
        int n = nextStatementIndex = instrument == null ? -1 : instrument.getStatementIndexAfterJump(statementIndex, curBCI, targetBCI);
        if (nextStatementIndex != statementIndex) {
            instrument.notifyStatementChange(frame, statementIndex, nextStatementIndex, targetBCI);
        }
        if (targetBCI <= curBCI) {
            TruffleSafepoint.poll((Node)this);
            if (CompilerDirectives.hasNextTier() && ++loopCount.value >= 256) {
                LoopNode.reportLoopCount((Node)this, (int)256);
                loopCount.value = 0;
            }
            if (CompilerDirectives.inInterpreter() && BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)this)) {
                Object osrResult;
                this.livenessAnalysis.catchUpOSR(frame, targetBCI, skipLivenessActions);
                try {
                    osrResult = BytecodeOSRNode.tryOSR((BytecodeOSRNode)this, (int)targetBCI, (Object)new EspressoOSRInterpreterState(top, nextStatementIndex), null, (VirtualFrame)frame);
                }
                catch (Throwable any) {
                    throw new EspressoOSRReturnException(any);
                }
                if (osrResult != null) {
                    throw new EspressoOSRReturnException(osrResult);
                }
            }
        }
        this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI, skipLivenessActions);
        return nextStatementIndex;
    }

    @ExplodeLoop
    private ExceptionHandler resolveExceptionHandlers(int bci, StaticObject ex) {
        CompilerAsserts.partialEvaluationConstant((int)bci);
        ExceptionHandler[] handlers = this.getMethodVersion().getExceptionHandlers();
        ExceptionHandler resolved = null;
        for (ExceptionHandler toCheck : handlers) {
            if (!toCheck.covers(bci)) continue;
            Klass catchType = null;
            if (!toCheck.isCatchAll()) {
                catchType = this.resolveType(193, (char)toCheck.catchTypeCPI());
            }
            if (catchType != null && !InterpreterToVM.instanceOf(ex, catchType)) continue;
            resolved = toCheck;
            break;
        }
        return resolved;
    }

    private void putPoolConstant(VirtualFrame frame, int top, char cpi, int opcode) {
        assert (opcode == 18 || opcode == 19 || opcode == 20);
        RuntimeConstantPool pool = this.getConstantPool();
        PoolConstant constant = pool.at(cpi);
        if (constant instanceof IntegerConstant) {
            assert (opcode == 18 || opcode == 19);
            EspressoFrame.putInt((Frame)frame, top, ((IntegerConstant)constant).value());
        } else if (constant instanceof LongConstant) {
            assert (opcode == 20);
            EspressoFrame.putLong((Frame)frame, top, ((LongConstant)constant).value());
        } else if (constant instanceof DoubleConstant) {
            assert (opcode == 20);
            EspressoFrame.putDouble((Frame)frame, top, ((DoubleConstant)constant).value());
        } else if (constant instanceof FloatConstant) {
            assert (opcode == 18 || opcode == 19);
            EspressoFrame.putFloat((Frame)frame, top, ((FloatConstant)constant).value());
        } else if (constant instanceof StringConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject internedString = pool.resolvedStringAt(cpi);
            EspressoFrame.putObject((Frame)frame, top, internedString);
        } else if (constant instanceof ClassConstant) {
            assert (opcode == 18 || opcode == 19);
            Klass klass = pool.resolvedKlassAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, klass.mirror());
        } else if (constant instanceof MethodHandleConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject methodHandle = pool.resolvedMethodHandleAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, methodHandle);
        } else if (constant instanceof MethodTypeConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject methodType = pool.resolvedMethodTypeAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, methodType);
        } else if (constant instanceof DynamicConstant) {
            ResolvedDynamicConstant dynamicConstant = pool.resolvedDynamicConstantAt(this.getDeclaringKlass(), cpi);
            dynamicConstant.putResolved(frame, top, this);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.unimplemented(constant.toString());
        }
    }

    protected RuntimeConstantPool getConstantPool() {
        return this.getMethodVersion().getPool();
    }

    @CompilerDirectives.TruffleBoundary
    private BootstrapMethodsAttribute getBootstrapMethods() {
        return (BootstrapMethodsAttribute)this.getDeclaringKlass().getAttribute(BootstrapMethodsAttribute.NAME);
    }

    private char readCPI(int curBCI) {
        assert (!Bytecodes.isQuickenable(this.bs.currentBC(curBCI)) || this.lockIsHeld()) : "Reading the CPI for a quickenable bytecode must be done under the BytecodeNode lock. Please obtain the lock, or use readOriginalCPI.";
        return this.bs.readCPI(curBCI);
    }

    private char readOriginalCPI(int curBCI) {
        return BytecodeStream.readCPI(this.getMethodVersion().getOriginalCode(), curBCI);
    }

    private char addQuickNode(BaseQuickNode node) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(node);
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        int nodeIndex = this.nodes.length - 1;
        this.nodes[nodeIndex] = (BaseQuickNode)this.insert(node);
        return (char)nodeIndex;
    }

    private void addSlimQuickNode(BaseQuickNode node, int curBCI) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(node);
        if (this.sparseNodes == QuickNode.EMPTY_ARRAY) {
            this.sparseNodes = new QuickNode[this.code.length];
        }
        this.sparseNodes[curBCI] = (BaseQuickNode)this.insert(node);
    }

    private void patchBci(int bci, byte opcode, char nodeIndex) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isQuickened(opcode));
        byte oldBC = this.code[bci];
        if (opcode == -53) {
            this.code[bci + 1] = (byte)(nodeIndex >> 8 & 0xFF);
            this.code[bci + 2] = (byte)(nodeIndex & 0xFF);
        }
        for (int i = Bytecodes.lengthOf(opcode); i < Bytecodes.lengthOf(oldBC); ++i) {
            this.code[bci + i] = 0;
        }
        VolatileArrayAccess.volatileWrite(this.code, bci, opcode);
    }

    private BaseQuickNode injectQuick(int curBCI, BaseQuickNode quick, int opcode) {
        QUICKENED_BYTECODES.inc();
        CompilerAsserts.neverPartOfCompilation();
        if (opcode == 204) {
            this.addSlimQuickNode(quick, curBCI);
            this.patchBci(curBCI, (byte)-52, '\u0000');
        } else {
            char nodeIndex = this.addQuickNode(quick);
            this.patchBci(curBCI, (byte)-53, nodeIndex);
        }
        return quick;
    }

    private <T> BaseQuickNode tryPatchQuick(int curBCI, QuickNodeResolver<T> resolver, QuickNodeFactory<T> newQuickNode) {
        Object found = this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 203) {
                return this.nodes[this.readCPI(curBCI)];
            }
            return Character.valueOf(this.readCPI(curBCI));
        });
        if (found instanceof BaseQuickNode) {
            return (BaseQuickNode)found;
        }
        char cpi = ((Character)found).charValue();
        Object resolved = resolver.get(cpi);
        return (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 203) {
                return this.nodes[this.readCPI(curBCI)];
            }
            return this.injectQuick(curBCI, newQuickNode.get(resolved), 203);
        });
    }

    private BaseQuickNode tryPatchQuick(int curBCI, QuickNodeSupplier newQuickNode) {
        return this.tryPatchQuick(curBCI, cpi -> null, unused -> newQuickNode.get());
    }

    private int quickenCheckCast(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (opcode == 192);
        BaseQuickNode quick = this.tryPatchQuick(curBCI, cpi -> this.resolveType(192, cpi), k -> new CheckCastQuickNode((Klass)k, top, curBCI));
        quick.execute(frame, false);
        assert (Bytecodes.stackEffectOf(opcode) == 0);
        return 0;
    }

    private int quickenInstanceOf(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (opcode == 193);
        BaseQuickNode quick = this.tryPatchQuick(curBCI, cpi -> this.resolveType(193, cpi), k -> new InstanceOfQuickNode((Klass)k, top, curBCI));
        quick.execute(frame, false);
        assert (Bytecodes.stackEffectOf(opcode) == 0);
        return 0;
    }

    private int quickenInvoke(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex) {
        InvokeQuickNode quick = this.quickenInvoke(top, curBCI, opcode, statementIndex);
        if (opcode == 184 && quick instanceof InvokeStaticQuickNode) {
            InvokeStaticQuickNode invokeStaticQuickNode = (InvokeStaticQuickNode)quick;
            try (EspressoLanguage.DisableSingleStepping ignored = this.getLanguage().disableStepping();){
                invokeStaticQuickNode.initializeResolvedKlass();
            }
        }
        return quick.execute(frame, false) - Bytecodes.stackEffectOf(opcode);
    }

    private InvokeQuickNode quickenInvoke(int top, int curBCI, int opcode, int statementIndex) {
        QUICKENED_INVOKES.inc();
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (Bytecodes.isInvoke(opcode));
        InvokeQuickNode quick = (InvokeQuickNode)this.tryPatchQuick(curBCI, cpi -> this.getResolvedInvoke(opcode, cpi), resolvedInvoke -> this.dispatchQuickened(top, curBCI, opcode, statementIndex, (ResolvedInvoke)resolvedInvoke, this.getMethod().getContext().getEspressoEnv().bytecodeLevelInlining));
        return quick;
    }

    public int reQuickenInvoke(VirtualFrame frame, int top, int opcode, int curBCI, int statementIndex) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isInvoke(opcode));
        BaseQuickNode invoke = this.generifyInlinedMethodNode(top, opcode, curBCI, statementIndex);
        return invoke.execute(frame, false);
    }

    public int replaceQuickAt(VirtualFrame frame, int opcode, int curBCI, BaseQuickNode old, BaseQuickNode replacement) {
        BaseQuickNode invoke = this.replaceQuickAt(opcode, curBCI, old, replacement);
        return invoke.execute(frame, false);
    }

    private BaseQuickNode replaceQuickAt(int opcode, int curBCI, BaseQuickNode old, BaseQuickNode replacement) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isInvoke(opcode) || opcode == 203);
        BaseQuickNode invoke = (BaseQuickNode)this.atomic(() -> {
            assert (this.bs.currentBC(curBCI) == 203);
            char nodeIndex = this.readCPI(curBCI);
            BaseQuickNode currentQuick = this.nodes[nodeIndex];
            if (currentQuick != old) {
                return currentQuick;
            }
            this.nodes[nodeIndex] = (BaseQuickNode)currentQuick.replace(replacement);
            return replacement;
        });
        return invoke;
    }

    public BaseQuickNode generifyInlinedMethodNode(int top, int opcode, int curBCI, int statementIndex) {
        CompilerAsserts.neverPartOfCompilation();
        ResolvedInvoke resolvedInvoke = this.getResolvedInvoke(opcode, this.readOriginalCPI(curBCI));
        return (BaseQuickNode)this.atomic(() -> {
            assert (this.bs.currentBC(curBCI) == 203);
            char nodeIndex = this.readCPI(curBCI);
            BaseQuickNode currentQuick = this.nodes[nodeIndex];
            if (!(currentQuick instanceof InlinedMethodNode)) {
                return currentQuick;
            }
            InvokeQuickNode invoke = this.dispatchQuickened(top, curBCI, opcode, statementIndex, resolvedInvoke, false);
            this.nodes[nodeIndex] = (BaseQuickNode)currentQuick.replace(invoke);
            return invoke;
        });
    }

    private void generifyBytecodeLevelInlining() {
        this.atomic(() -> {
            for (BaseQuickNode quick : this.nodes) {
                if (!(quick instanceof InlinedMethodNode)) continue;
                this.notifyInserted(((InlinedMethodNode)quick).revertToGeneric(this));
            }
        });
    }

    public int quickenGetField(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex, Field field) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (opcode == 180);
        BaseQuickNode getField = this.tryPatchQuick(curBCI, () -> new QuickenedGetFieldNode(top, curBCI, statementIndex, field));
        return getField.execute(frame, false) - Bytecodes.stackEffectOf(opcode);
    }

    public int quickenPutField(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex, Field field) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (opcode == 181);
        BaseQuickNode putField = this.tryPatchQuick(curBCI, () -> new QuickenedPutFieldNode(top, curBCI, field, statementIndex));
        return putField.execute(frame, false) - Bytecodes.stackEffectOf(opcode);
    }

    private int quickenArrayLength(VirtualFrame frame, int top, int curBCI) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        BaseQuickNode arrayLengthNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, new ArrayLengthQuickNode(top, curBCI), 204);
        });
        return arrayLengthNode.execute(frame, false) - Bytecodes.stackEffectOf(190);
    }

    private int quickenArrayLoad(VirtualFrame frame, int top, int curBCI, int loadOpcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (46 <= loadOpcode && loadOpcode <= 53);
        BaseQuickNode arrayLoadNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, switch (loadOpcode) {
                case 51 -> new ByteArrayLoadQuickNode(top, curBCI);
                case 53 -> new ShortArrayLoadQuickNode(top, curBCI);
                case 52 -> new CharArrayLoadQuickNode(top, curBCI);
                case 46 -> new IntArrayLoadQuickNode(top, curBCI);
                case 48 -> new FloatArrayLoadQuickNode(top, curBCI);
                case 47 -> new LongArrayLoadQuickNode(top, curBCI);
                case 49 -> new DoubleArrayLoadQuickNode(top, curBCI);
                case 50 -> new ReferenceArrayLoadQuickNode(top, curBCI);
                default -> {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("unexpected kind");
                }
            }, 204);
        });
        return arrayLoadNode.execute(frame, false) - Bytecodes.stackEffectOf(loadOpcode);
    }

    private int quickenArrayStore(VirtualFrame frame, int top, int curBCI, int storeOpcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (79 <= storeOpcode && storeOpcode <= 86);
        BaseQuickNode arrayStoreNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, switch (storeOpcode) {
                case 84 -> new ByteArrayStoreQuickNode(top, curBCI);
                case 86 -> new ShortArrayStoreQuickNode(top, curBCI);
                case 85 -> new CharArrayStoreQuickNode(top, curBCI);
                case 79 -> new IntArrayStoreQuickNode(top, curBCI);
                case 81 -> new FloatArrayStoreQuickNode(top, curBCI);
                case 80 -> new LongArrayStoreQuickNode(top, curBCI);
                case 82 -> new DoubleArrayStoreQuickNode(top, curBCI);
                case 83 -> new ReferenceArrayStoreQuickNode(top, curBCI);
                default -> {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("unexpected kind");
                }
            }, 204);
        });
        return arrayStoreNode.execute(frame, false) - Bytecodes.stackEffectOf(storeOpcode);
    }

    private InvokeQuickNode dispatchQuickened(int top, int curBCI, int opcode, int statementIndex, ResolvedInvoke resolvedInvoke, boolean allowBytecodeInlining) {
        InlinedMethodNode node;
        boolean tryBytecodeLevelInlining;
        ResolvedCall resolvedCall = resolvedInvoke.resolvedCall();
        Method resolved = resolvedCall.getResolvedMethod();
        CallKind callKind = resolvedCall.getCallKind();
        assert (this.lockIsHeld());
        boolean bl = tryBytecodeLevelInlining = this.instrumentation == null && allowBytecodeInlining;
        if (tryBytecodeLevelInlining && (node = InlinedMethodNode.createFor(resolvedCall, top, opcode, curBCI, statementIndex)) != null) {
            return node;
        }
        if (resolved.isPolySignatureIntrinsic()) {
            return new InvokeHandleNode(resolved, resolvedInvoke.invoker(), top, curBCI);
        }
        return switch (callKind) {
            default -> throw new IncompatibleClassChangeError();
            case CallKind.STATIC -> new InvokeStaticQuickNode(resolved, top, curBCI);
            case CallKind.ITABLE_LOOKUP -> new InvokeInterfaceQuickNode(resolved, top, curBCI);
            case CallKind.VTABLE_LOOKUP -> new InvokeVirtualQuickNode(resolved, top, curBCI);
            case CallKind.DIRECT -> new InvokeSpecialQuickNode(resolved, top, curBCI);
        };
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass) {
        throw this.getMeta().throwException(exceptionKlass);
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass, String message) {
        throw this.getMeta().throwExceptionWithMessage(exceptionKlass, message);
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass, String messageFormat, Object ... args) {
        throw this.getMeta().throwExceptionWithMessage(exceptionKlass, String.format(Locale.ENGLISH, messageFormat, args));
    }

    private int quickenInvokeDynamic(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (opcode == 186);
        BaseQuickNode quick = this.tryPatchQuick(curBCI, cpi -> this.getConstantPool().linkInvokeDynamic(this.getMethod().getDeclaringKlass(), cpi, curBCI, this.getMethod()), link -> new InvokeDynamicCallSiteNode(link.getMemberName(), link.getUnboxedAppendix(), link.getParsedSignature(), this.getMethod().getMeta(), top, curBCI));
        return quick.execute(frame, false) - Bytecodes.stackEffectOf(opcode);
    }

    public Klass resolveType(int opcode, char cpi) {
        assert (opcode == 193 || opcode == 192 || opcode == 187 || opcode == 189 || opcode == 197);
        return this.getConstantPool().resolvedKlassAt(this.getDeclaringKlass(), cpi);
    }

    private Field resolveField(int opcode, char cpi) {
        assert (opcode == 180 || opcode == 178 || opcode == 181 || opcode == 179);
        Field field = this.getConstantPool().resolvedFieldAt(this.getMethod().getDeclaringKlass(), cpi);
        if (field.needsReResolution()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMethod().getContext().getClassRedefinition().check();
            field = this.getConstantPool().resolveFieldAndUpdate(this.getMethod().getDeclaringKlass(), cpi, field);
        }
        return field;
    }

    private ResolvedInvoke reResolvedInvoke(int opcode, char cpi) {
        this.getConstantPool().resolveMethodAndUpdate(this.getDeclaringKlass(), cpi);
        return this.getResolvedInvoke(opcode, cpi);
    }

    private ResolvedInvoke getResolvedInvoke(int opcode, char cpi) {
        assert (!this.lockIsHeld());
        MethodRefConstant methodRefConstant = this.getConstantPool().resolvedMethodRefAt(this.getDeclaringKlass(), cpi);
        Method resolutionSeed = (Method)((Resolvable.ResolvedConstant)((Object)methodRefConstant)).value();
        Klass symbolicRef = Resolution.getResolvedHolderKlass((MethodRefConstant.Indexes)this.getConstantPool().methodAt(cpi), this.getConstantPool(), this.getDeclaringKlass());
        ResolvedCall resolvedCall = LinkResolver.resolveCallSite(this.getMeta(), this.getDeclaringKlass(), resolutionSeed, CallSiteType.fromOpCode(opcode), symbolicRef);
        MHInvokeGenericNode.MethodHandleInvoker invoker = null;
        if (methodRefConstant instanceof ResolvedWithInvokerClassMethodRefConstant) {
            ResolvedWithInvokerClassMethodRefConstant withInvoker = (ResolvedWithInvokerClassMethodRefConstant)methodRefConstant;
            invoker = withInvoker.invoker();
            assert (invoker == null || (opcode == 182 || opcode == 183) && resolvedCall.getResolvedMethod().isInvokeIntrinsic());
        }
        return new ResolvedInvoke(resolvedCall, invoker);
    }

    @ExplodeLoop
    private int allocateMultiArray(VirtualFrame frame, int top, Klass klass, int allocatedDimensions) {
        assert (klass.isArray());
        CompilerAsserts.partialEvaluationConstant((int)allocatedDimensions);
        CompilerAsserts.partialEvaluationConstant((Object)klass);
        int[] dimensions = new int[allocatedDimensions];
        for (int i = 0; i < allocatedDimensions; ++i) {
            dimensions[i] = EspressoFrame.popInt((Frame)frame, top - allocatedDimensions + i);
        }
        Klass component = ((ArrayKlass)klass).getComponentType();
        GuestAllocator.AllocationChecks.checkCanAllocateMultiArray(this.getMethod().getMeta(), component, dimensions, this);
        StaticObject value = this.getAllocator().createNewMultiArray(component, dimensions);
        EspressoFrame.putObject((Frame)frame, top - allocatedDimensions, value);
        return -allocatedDimensions;
    }

    private boolean stackIntToBoolean(int result) {
        return this.getJavaVersion().java9OrLater() ? (result & 1) != 0 : result != 0;
    }

    private static int divInt(int divisor, int dividend) {
        return dividend / divisor;
    }

    private static long divLong(long divisor, long dividend) {
        return dividend / divisor;
    }

    private static float divFloat(float divisor, float dividend) {
        return dividend / divisor;
    }

    private static double divDouble(double divisor, double dividend) {
        return dividend / divisor;
    }

    private static int remInt(int divisor, int dividend) {
        return dividend % divisor;
    }

    private static long remLong(long divisor, long dividend) {
        return dividend % divisor;
    }

    private static float remFloat(float divisor, float dividend) {
        return dividend % divisor;
    }

    private static double remDouble(double divisor, double dividend) {
        return dividend % divisor;
    }

    private static int shiftLeftInt(int bits, int value) {
        return value << bits;
    }

    private static long shiftLeftLong(int bits, long value) {
        return value << bits;
    }

    private static int shiftRightSignedInt(int bits, int value) {
        return value >> bits;
    }

    private static long shiftRightSignedLong(int bits, long value) {
        return value >> bits;
    }

    private static int shiftRightUnsignedInt(int bits, int value) {
        return value >>> bits;
    }

    private static long shiftRightUnsignedLong(int bits, long value) {
        return value >>> bits;
    }

    private static int compareLong(long y, long x) {
        return Long.compare(x, y);
    }

    private static int compareFloatGreater(float y, float x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareFloatLess(float y, float x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    private static int compareDoubleGreater(double y, double x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareDoubleLess(double y, double x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    public void enterImplicitExceptionProfile() {
        if (!this.implicitExceptionProfile) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.implicitExceptionProfile = true;
        }
    }

    public void enterLinkageExceptionProfile() {
        if (!this.linkageExceptionProfile) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.linkageExceptionProfile = true;
        }
    }

    private StaticObject nullCheck(StaticObject value) {
        if (!StaticObject.isNull(value)) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.getMethod().getMeta().throwNullPointerException();
    }

    private int checkNonZero(int value) {
        if (value != 0) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.throwBoundary(this.getMethod().getMeta().java_lang_ArithmeticException, "/ by zero");
    }

    private long checkNonZero(long value) {
        if (value != 0L) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.throwBoundary(this.getMethod().getMeta().java_lang_ArithmeticException, "/ by zero");
    }

    private int putField(VirtualFrame frame, int top, Field field, int curBCI, int opcode, int statementIndex, FieldAccessType mode) {
        StaticObject receiver;
        int slotCount;
        assert (opcode == 181 || opcode == 179);
        CompilerAsserts.partialEvaluationConstant((Object)field);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)mode));
        LinkResolver.resolveFieldAccess(this.getMeta(), this.getDeclaringKlass(), this.getMethod(), field, mode);
        byte typeHeader = field.getType().byteAt(0);
        int n = slotCount = typeHeader == 74 || typeHeader == 68 ? 2 : 1;
        assert (slotCount == field.getKind().getSlotCount());
        int slot = top - slotCount - 1;
        if (mode.isStatic()) {
            receiver = this.initializeAndGetStatics(field);
        } else if (!this.noForeignObjects.isValid()) {
            receiver = this.nullCheck(EspressoFrame.peekObject((Frame)frame, slot));
            if (receiver.isForeignObject()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                EspressoFrame.putObject((Frame)frame, slot, receiver);
                return this.quickenPutField(frame, top, curBCI, opcode, statementIndex, field);
            }
            EspressoFrame.popObject((Frame)frame, slot);
        } else {
            receiver = this.nullCheck(EspressoFrame.popObject((Frame)frame, slot));
        }
        switch (typeHeader) {
            case 90: {
                boolean booleanValue = this.stackIntToBoolean(EspressoFrame.popInt((Frame)frame, top - 1));
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, booleanValue);
                }
                InterpreterToVM.setFieldBoolean(booleanValue, receiver, field);
                break;
            }
            case 66: {
                byte byteValue = (byte)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, byteValue);
                }
                InterpreterToVM.setFieldByte(byteValue, receiver, field);
                break;
            }
            case 67: {
                char charValue = (char)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, Character.valueOf(charValue));
                }
                InterpreterToVM.setFieldChar(charValue, receiver, field);
                break;
            }
            case 83: {
                short shortValue = (short)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, shortValue);
                }
                InterpreterToVM.setFieldShort(shortValue, receiver, field);
                break;
            }
            case 73: {
                int intValue = EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, intValue);
                }
                InterpreterToVM.setFieldInt(intValue, receiver, field);
                break;
            }
            case 68: {
                double doubleValue = EspressoFrame.popDouble((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, doubleValue);
                }
                InterpreterToVM.setFieldDouble(doubleValue, receiver, field);
                break;
            }
            case 70: {
                float floatValue = EspressoFrame.popFloat((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, Float.valueOf(floatValue));
                }
                InterpreterToVM.setFieldFloat(floatValue, receiver, field);
                break;
            }
            case 74: {
                long longValue = EspressoFrame.popLong((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, longValue);
                }
                InterpreterToVM.setFieldLong(longValue, receiver, field);
                break;
            }
            case 76: 
            case 91: {
                StaticObject value = EspressoFrame.popObject((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, value);
                }
                InterpreterToVM.setFieldObject(value, receiver, field);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("unexpected kind");
            }
        }
        return -slotCount;
    }

    private int getField(VirtualFrame frame, int top, Field field, int curBCI, int opcode, int statementIndex, FieldAccessType mode) {
        int slotCount;
        StaticObject receiver;
        assert (opcode == 180 || opcode == 178);
        CompilerAsserts.partialEvaluationConstant((Object)field);
        LinkResolver.resolveFieldAccess(this.getMeta(), this.getDeclaringKlass(), this.getMethod(), field, mode);
        int slot = top - 1;
        if (mode.isStatic()) {
            receiver = this.initializeAndGetStatics(field);
        } else if (!this.noForeignObjects.isValid()) {
            receiver = this.nullCheck(EspressoFrame.peekObject((Frame)frame, slot));
            if (receiver.isForeignObject()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                EspressoFrame.putObject((Frame)frame, slot, receiver);
                return this.quickenGetField(frame, top, curBCI, opcode, statementIndex, field);
            }
            EspressoFrame.popObject((Frame)frame, slot);
        } else {
            receiver = this.nullCheck(EspressoFrame.popObject((Frame)frame, slot));
        }
        if (this.instrumentation != null) {
            this.instrumentation.notifyFieldAccess(frame, statementIndex, field, receiver);
        }
        int resultAt = mode.isStatic() ? top : top - 1;
        byte typeHeader = field.getType().byteAt(0);
        switch (typeHeader) {
            case 90: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldBoolean(receiver, field) ? 1 : 0);
                break;
            }
            case 66: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldByte(receiver, field));
                break;
            }
            case 67: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldChar(receiver, field));
                break;
            }
            case 83: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldShort(receiver, field));
                break;
            }
            case 73: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldInt(receiver, field));
                break;
            }
            case 68: {
                EspressoFrame.putDouble((Frame)frame, resultAt, InterpreterToVM.getFieldDouble(receiver, field));
                break;
            }
            case 70: {
                EspressoFrame.putFloat((Frame)frame, resultAt, InterpreterToVM.getFieldFloat(receiver, field));
                break;
            }
            case 74: {
                EspressoFrame.putLong((Frame)frame, resultAt, InterpreterToVM.getFieldLong(receiver, field));
                break;
            }
            case 76: 
            case 91: {
                StaticObject value = InterpreterToVM.getFieldObject(receiver, field);
                EspressoFrame.putObject((Frame)frame, resultAt, value);
                this.checkNoForeignObjectAssumption(value);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("unexpected kind");
            }
        }
        int n = slotCount = typeHeader == 74 || typeHeader == 68 ? 2 : 1;
        assert (slotCount == field.getKind().getSlotCount());
        return slotCount;
    }

    private StaticObject initializeAndGetStatics(Field field) {
        ObjectKlass declaringKlass = field.getDeclaringKlass();
        if (!declaringKlass.isInitialized()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try (EspressoLanguage.DisableSingleStepping ignored = this.getLanguage().disableStepping();){
                declaringKlass.safeInitialize();
            }
        }
        return declaringKlass.getStatics();
    }

    public String toString() {
        return this.getRootNode().getQualifiedName();
    }

    public void notifyFieldModification(VirtualFrame frame, int index, Field field, StaticObject receiver, Object value) {
        if (this.instrumentation != null && (this.noForeignObjects.isValid() || receiver.isEspressoObject())) {
            this.instrumentation.notifyFieldModification(frame, index, field, receiver, value);
        }
    }

    public void notifyFieldAccess(VirtualFrame frame, int index, Field field, StaticObject receiver) {
        if (this.instrumentation != null && (this.noForeignObjects.isValid() || receiver.isEspressoObject())) {
            this.instrumentation.notifyFieldAccess(frame, index, field, receiver);
        }
    }

    private boolean lockIsHeld() {
        return ((ReentrantLock)this.getLock()).isHeldByCurrentThread();
    }

    private boolean trivialBytecodes() {
        if (this.getMethod().isSynchronized()) {
            return false;
        }
        byte[] originalCode = this.getMethodVersion().getOriginalCode();
        BytecodeStream stream = new BytecodeStream(originalCode);
        int bci = 0;
        while (bci < stream.endBCI()) {
            int dest;
            int bc = stream.currentBC(bci);
            if (Bytecodes.isInvoke(bc)) {
                return false;
            }
            if (171 == bc || 170 == bc) {
                return false;
            }
            if (194 == bc || 195 == bc) {
                return false;
            }
            if (189 == bc || 197 == bc) {
                return false;
            }
            if (Bytecodes.isBranch(bc) && (dest = stream.readBranchDest(bci)) <= bci) {
                return false;
            }
            bci = stream.nextBCI(bci);
        }
        return true;
    }

    @Override
    protected boolean isTrivial() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.noForeignObjects.isValid() || this.implicitExceptionProfile) {
            return false;
        }
        if (this.instrumentation != null) {
            return false;
        }
        if (this.trivialBytecodesCache == -1) {
            this.trivialBytecodesCache = this.trivialBytecodes() ? (byte)1 : 0;
        }
        return this.trivialBytecodesCache == 1;
    }

    static {
        assert (Integer.bitCount(256) == 1) : "must be a power of 2";
    }

    static final class InstrumentationSupport
    extends EspressoNode {
        static final int NO_STATEMENT = -1;
        @Node.Children
        private final EspressoBaseStatementNode[] statementNodes;
        @Node.Child
        private MapperBCI hookBCIToNodeIndex;
        private final EspressoContext context;
        private final Method.MethodVersion method;

        InstrumentationSupport(Method.MethodVersion method) {
            this.method = method;
            this.context = method.getMethod().getContext();
            LineNumberTableAttribute table = method.getLineNumberTableAttribute();
            if (table != LineNumberTableAttribute.EMPTY) {
                List<LineNumberTableAttribute.Entry> entries = table.getEntries();
                int[] seenLines = new int[entries.size()];
                Arrays.fill(seenLines, -1);
                int maxSeenLine = -1;
                this.statementNodes = new EspressoBaseStatementNode[entries.size()];
                this.hookBCIToNodeIndex = new MapperBCI(table);
                for (int i = 0; i < entries.size(); ++i) {
                    boolean checkSeen;
                    LineNumberTableAttribute.Entry entry = entries.get(i);
                    int lineNumber = entry.getLineNumber();
                    boolean seen = false;
                    boolean bl = checkSeen = maxSeenLine >= lineNumber;
                    if (checkSeen) {
                        for (int seenLine : seenLines) {
                            if (seenLine != lineNumber) continue;
                            seen = true;
                            break;
                        }
                    }
                    if (seen) continue;
                    this.statementNodes[this.hookBCIToNodeIndex.initIndex((int)i, (int)entry.getBCI())] = new EspressoStatementNode(entry.getBCI(), lineNumber);
                    seenLines[i] = lineNumber;
                    maxSeenLine = Math.max(maxSeenLine, lineNumber);
                }
            } else {
                this.statementNodes = null;
                this.hookBCIToNodeIndex = null;
            }
        }

        void notifyStatementChange(VirtualFrame frame, int statementIndex, int nextStatementIndex, int targetBci) {
            assert (statementIndex != nextStatementIndex);
            this.notifyStatementExit(frame, statementIndex);
            EspressoFrame.setBCI((Frame)frame, targetBci);
            this.notifyStatementEnter(frame, nextStatementIndex);
        }

        void notifyStatementEnter(VirtualFrame frame, int statementIndex) {
            CompilerAsserts.partialEvaluationConstant((int)statementIndex);
            this.enterAt(frame, statementIndex);
        }

        void notifyStatementResume(VirtualFrame frame, int statementIndex) {
            CompilerAsserts.partialEvaluationConstant((int)statementIndex);
            this.resumeAt(frame, statementIndex);
        }

        void notifyStatementExit(VirtualFrame frame, int statementIndex) {
            CompilerAsserts.partialEvaluationConstant((int)statementIndex);
            this.exitAt(frame, statementIndex, StaticObject.NULL);
        }

        public void notifyEntry(VirtualFrame frame, AbstractInstrumentableBytecodeNode instrumentableNode) {
            if (this.context.shouldReportVMEvents() && this.method.hasActiveHook()) {
                this.context.reportOnMethodEntry(this.method, instrumentableNode.getScope((Frame)frame, true));
            }
        }

        public void notifyResume(VirtualFrame frame, AbstractInstrumentableBytecodeNode instrumentableNode) {
            if (this.context.shouldReportVMEvents() && this.method.hasActiveHook()) {
                this.context.reportOnMethodEntry(this.method, instrumentableNode.getScope((Frame)frame, true));
            }
        }

        public void notifyReturn(VirtualFrame frame, int statementIndex, Object returnValue) {
            if (this.context.shouldReportVMEvents() && this.method.hasActiveHook() && this.context.reportOnMethodReturn(this.method, returnValue)) {
                this.exitAt(frame, statementIndex, returnValue);
            }
        }

        void notifyExceptionAt(VirtualFrame frame, Throwable t, int statementIndex) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(statementIndex);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            probeNode.onReturnExceptionalOrUnwind(frame, t, false);
        }

        void notifyYieldAt(VirtualFrame frame, Object o, int statementIndex) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(statementIndex);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            probeNode.onYield(frame, o);
        }

        public void notifyFieldModification(VirtualFrame frame, int index, Field field, StaticObject receiver, Object value) {
            if (this.context.shouldReportVMEvents() && field.hasActiveBreakpoint() && this.context.reportOnFieldModification(field, receiver, value)) {
                this.enterAt(frame, index);
            }
        }

        public void notifyFieldAccess(VirtualFrame frame, int index, Field field, StaticObject receiver) {
            if (this.context.shouldReportVMEvents() && field.hasActiveBreakpoint() && this.context.reportOnFieldAccess(field, receiver)) {
                this.enterAt(frame, index);
            }
        }

        private void enterAt(VirtualFrame frame, int index) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(index);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            try {
                probeNode.onEnter(frame);
            }
            catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, false);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException();
                }
                if (result != null) {
                    return;
                }
                throw t;
            }
        }

        private void resumeAt(VirtualFrame frame, int index) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(index);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            try {
                probeNode.onResume(frame);
            }
            catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, false);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException();
                }
                if (result != null) {
                    return;
                }
                throw t;
            }
        }

        private void exitAt(VirtualFrame frame, int index, Object returnValue) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(index);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            try {
                probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, true);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException();
                }
                if (result != null) {
                    return;
                }
                throw t;
            }
        }

        int getStatementIndexAfterJump(int statementIndex, int curBCI, int targetBCI) {
            if (this.hookBCIToNodeIndex == null) {
                return -1;
            }
            return this.hookBCIToNodeIndex.lookup(statementIndex, curBCI, targetBCI);
        }

        int getNextStatementIndex(int statementIndex, int nextBCI) {
            if (this.hookBCIToNodeIndex == null) {
                return -1;
            }
            return this.hookBCIToNodeIndex.checkNext(statementIndex, nextBCI);
        }

        int getStartStatementIndex(int startBci) {
            if (this.hookBCIToNodeIndex == null) {
                return -1;
            }
            if (startBci == 0) {
                assert (this.hookBCIToNodeIndex.lookupBucket(0) == 0);
                return 0;
            }
            return this.hookBCIToNodeIndex.lookupBucket(startBci);
        }

        private InstrumentableNode.WrapperNode getWrapperAt(int index) {
            if (this.statementNodes == null || index < 0) {
                return null;
            }
            EspressoBaseStatementNode node = this.statementNodes[index];
            if (!(node instanceof InstrumentableNode.WrapperNode)) {
                return null;
            }
            CompilerAsserts.partialEvaluationConstant((Object)node);
            return (InstrumentableNode.WrapperNode)node;
        }
    }

    private static final class EspressoOSRInterpreterState {
        final int top;
        final int statementIndex;

        EspressoOSRInterpreterState(int top, int statementIndex) {
            this.top = top;
            this.statementIndex = statementIndex;
        }
    }

    private static final class Counter {
        int value;

        private Counter() {
        }
    }

    private static final class ThrowOutOfInterpreterLoop
    extends ControlFlowException {
        private static final long serialVersionUID = 774753014650104744L;
        private final RuntimeException exception;

        private ThrowOutOfInterpreterLoop(RuntimeException exception) {
            this.exception = exception;
        }

        RuntimeException reThrow() {
            throw this.exception;
        }
    }

    public static final class EspressoOSRReturnException
    extends ControlFlowException
    implements GenerateWrapper.YieldException {
        private final Object result;
        private final Throwable throwable;

        EspressoOSRReturnException(Object result) {
            this.result = result;
            this.throwable = null;
        }

        public EspressoOSRReturnException(Throwable throwable) {
            this.result = null;
            this.throwable = throwable;
        }

        Object getResultOrRethrow() {
            if (this.throwable != null) {
                throw EspressoOSRReturnException.sneakyThrow(this.throwable);
            }
            return this.result;
        }

        private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
            throw ex;
        }

        public Object getYieldValue() {
            return null;
        }
    }

    private record ResolvedInvoke(ResolvedCall resolvedCall, MHInvokeGenericNode.MethodHandleInvoker invoker) {
    }

    @FunctionalInterface
    private static interface QuickNodeResolver<T> {
        public T get(char var1);
    }

    @FunctionalInterface
    private static interface QuickNodeFactory<T> {
        public BaseQuickNode get(T var1);
    }

    @FunctionalInterface
    private static interface QuickNodeSupplier {
        public BaseQuickNode get();
    }
}

