/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.continuation.HostFrameRecord;

public class ContinuableMethodWithBytecode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    AbstractInstrumentableBytecodeNode bytecodeNode;
    private final int bci;
    private final EspressoFrameDescriptor fd;

    public ContinuableMethodWithBytecode(AbstractInstrumentableBytecodeNode bytecodeNode, int bci, EspressoFrameDescriptor fd) {
        super(bytecodeNode.getMethodVersion());
        this.bci = bci;
        this.fd = fd;
        this.bytecodeNode = bytecodeNode;
    }

    @Override
    Object execute(VirtualFrame frame) {
        return this.bytecodeNode.resumeContinuation(frame, this.bci, this.fd.top());
    }

    @Override
    public final int getBci(Frame frame) {
        return EspressoFrame.getBCI(frame);
    }

    public final EspressoFrameDescriptor getFD() {
        return this.fd;
    }

    public final HostFrameRecord getFrameRecords(VirtualFrame frame) {
        assert (frame.getArguments().length == 1 && frame.getArguments()[0] instanceof HostFrameRecord);
        HostFrameRecord records = (HostFrameRecord)frame.getArguments()[0];
        assert (records.methodVersion == this.getMethodVersion());
        return records;
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + "-Cont@" + this.bci;
    }

    @GenerateInline(value=false)
    public static abstract class ResumeNextContinuationNode
    extends EspressoNode {
        static final int LIMIT = 3;

        public abstract Object execute(HostFrameRecord var1);

        @Specialization(guards={"isLastRecord(records)"})
        Object doLast(HostFrameRecord records) {
            assert (records == null);
            assert (((EspressoRootNode)this.getRootNode()).getMethod() == this.getMeta().continuum.org_graalvm_continuations_ContinuationImpl_suspend);
            this.getLanguage().getThreadLocalState().enableSingleStepping();
            return StaticObject.NULL;
        }

        @Specialization(guards={"!isLastRecord(records)", "sameCachedRecord(records, cachedMethod, cachedBci)"}, limit="LIMIT")
        Object doCached(HostFrameRecord records, @Cached(value="records.methodVersion") Method.MethodVersion cachedMethod, @Cached(value="records.bci()") int cachedBci, @Cached(value="create(cachedMethod.getContinuableCallTarget(cachedBci))") DirectCallNode callNode) {
            assert (ResumeNextContinuationNode.sameCachedRecord(records, cachedMethod, cachedBci));
            return callNode.call(new Object[]{records});
        }

        @Specialization(replaces={"doCached"})
        Object doUncached(HostFrameRecord records, @Cached IndirectCallNode callNode) {
            return callNode.call(records.methodVersion.getContinuableCallTarget(records.bci()), new Object[]{records});
        }

        static boolean sameCachedRecord(HostFrameRecord records, Method.MethodVersion method, int cachedBci) {
            return records.methodVersion == method && records.bci() == cachedBci;
        }

        static boolean isLastRecord(HostFrameRecord records) {
            return records == null;
        }
    }
}

