/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNode;

abstract class EspressoInstrumentableRootNodeImpl
extends EspressoInstrumentableRootNode {
    private final Method.MethodVersion methodVersion;
    private volatile SourceSection sourceSection;

    EspressoInstrumentableRootNodeImpl(Method.MethodVersion methodVersion) {
        this.methodVersion = methodVersion;
    }

    @Override
    final Method.MethodVersion getMethodVersion() {
        return this.methodVersion;
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public EspressoInstrumentableRootNode split() {
        throw EspressoError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public final SourceSection getSourceSection() {
        Source s = this.getSource();
        if (s == null) {
            return null;
        }
        if (this.sourceSection == null) {
            SourceSection localSourceSection = this.methodVersion.getWholeMethodSourceSection();
            EspressoInstrumentableRootNodeImpl espressoInstrumentableRootNodeImpl = this;
            synchronized (espressoInstrumentableRootNodeImpl) {
                if (this.sourceSection == null) {
                    this.sourceSection = localSourceSection;
                }
            }
        }
        return this.sourceSection;
    }

    public final Source getSource() {
        return this.getMethodVersion().getSource();
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.RootTag.class) {
            return true;
        }
        return tag == StandardTags.RootBodyTag.class;
    }

    @Override
    public String toString() {
        return String.valueOf(this.methodVersion.getDeclaringKlass().getType()) + "." + String.valueOf(this.methodVersion.getName()) + String.valueOf(this.methodVersion.getRawSignature());
    }
}

