/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.nodes.SubstitutionScope;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;
import com.oracle.truffle.espresso.vm.VM;
import java.util.Arrays;

@ExportLibrary(value=NodeLibrary.class)
public final class IntrinsicSubstitutorNode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    private JavaSubstitution substitution;
    private final DebugCounter nbSplits;

    IntrinsicSubstitutorNode(Method.MethodVersion methodVersion, JavaSubstitution.Factory factory) {
        super(methodVersion);
        this.substitution = factory.create();
        EspressoError.guarantee(!this.substitution.isTrivial() || !methodVersion.isSynchronized(), "Substitution for synchronized method cannot be marked as trivial", methodVersion);
        this.nbSplits = this.substitution.canSplit() ? DebugCounter.create("Splits for: " + Arrays.toString(factory.getMethodNames())) : null;
    }

    private IntrinsicSubstitutorNode(IntrinsicSubstitutorNode toSplit) {
        super(toSplit.getMethodVersion());
        assert (toSplit.substitution.canSplit());
        this.substitution = toSplit.substitution.split();
        this.nbSplits = toSplit.nbSplits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object execute(VirtualFrame frame) {
        EspressoThreadLocalState tls = this.getContext().getLanguage().getThreadLocalState();
        tls.blockContinuationSuspension();
        try {
            Object object = this.substitution.invoke(frame.getArguments());
            return object;
        }
        finally {
            tls.unblockContinuationSuspension();
        }
    }

    @Override
    public boolean canSplit() {
        return this.substitution.canSplit();
    }

    @Override
    public IntrinsicSubstitutorNode split() {
        this.nbSplits.inc();
        return new IntrinsicSubstitutorNode(this);
    }

    public Node copy() {
        return this.split();
    }

    @Override
    boolean isTrivial() {
        return this.substitution.isTrivial();
    }

    @Override
    public int getBci(Frame frame) {
        if (this.getMethodVersion().isMethodNative()) {
            return VM.EspressoStackElement.NATIVE_BCI;
        }
        return 0;
    }

    @ExportMessage
    public boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public Object getScope(Frame frame, boolean nodeEnter) {
        return new SubstitutionScope(frame.getArguments(), this.getMethodVersion());
    }
}

