/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.nodes.SubstitutionScope;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.VM;

@ExportLibrary(value=NodeLibrary.class)
final class NativeMethodNode
extends EspressoInstrumentableRootNodeImpl {
    private final JniEnv env;
    private final TruffleObject boundNative;
    @Node.Child
    InteropLibrary executeNative;
    @CompilerDirectives.CompilationFinal
    boolean throwsException;
    private static final DebugCounter NATIVE_METHOD_CALLS = DebugCounter.create("Native method calls");

    NativeMethodNode(JniEnv env, TruffleObject boundNative, Method.MethodVersion method) {
        super(method);
        this.env = env;
        this.boundNative = boundNative;
        this.executeNative = (InteropLibrary)InteropLibrary.getFactory().create((Object)boundNative);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object toObjectHandle(JNIHandles handles, Object arg) {
        assert (arg instanceof StaticObject);
        return (long)handles.createLocal((StaticObject)arg);
    }

    @ExplodeLoop
    private Object[] preprocessArgs(JNIHandles handles, Object[] args) {
        Symbol<Symbol.Type>[] parsedSignature = this.getMethodVersion().getMethod().getParsedSignature();
        int paramCount = Signatures.parameterCount(parsedSignature);
        Object[] nativeArgs = new Object[2 + paramCount];
        assert (!InteropLibrary.getUncached().isNull((Object)this.env.getNativePointer()));
        nativeArgs[0] = this.env.getNativePointer();
        nativeArgs[1] = this.getMethodVersion().isStatic() ? NativeMethodNode.toObjectHandle(handles, this.getMethodVersion().getDeclaringKlass().mirror()) : NativeMethodNode.toObjectHandle(handles, args[0]);
        int skipReceiver = this.getMethodVersion().isStatic() ? 0 : 1;
        for (int i = 0; i < paramCount; ++i) {
            Symbol<Symbol.Type> paramType = Signatures.parameterType(parsedSignature, i);
            nativeArgs[i + 2] = Types.isReference(paramType) ? NativeMethodNode.toObjectHandle(handles, args[i + skipReceiver]) : args[i + skipReceiver];
        }
        return nativeArgs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JNIHandles handles = this.getContext().getHandles();
        int nativeFrame = handles.pushFrame();
        NATIVE_METHOD_CALLS.inc();
        EspressoThreadLocalState tls = this.getLanguage().getThreadLocalState();
        tls.blockContinuationSuspension();
        try {
            Object[] nativeArgs = this.preprocessArgs(handles, frame.getArguments());
            Object result = this.executeNative.execute((Object)this.boundNative, nativeArgs);
            Object object = this.processResult(handles, result);
            return object;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        finally {
            tls.unblockContinuationSuspension();
            handles.popFramesIncluding(nativeFrame);
        }
    }

    private void enterThrowsException() {
        if (!this.throwsException) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.throwsException = true;
        }
    }

    private void maybeThrowAndClearPendingException(EspressoLanguage language) {
        EspressoException ex = language.getPendingEspressoException();
        if (ex != null) {
            this.enterThrowsException();
            language.clearPendingException();
            throw ex;
        }
    }

    private Object processResult(JNIHandles handles, Object result) {
        this.maybeThrowAndClearPendingException(EspressoLanguage.get(this));
        Symbol<Symbol.Type> returnType = Signatures.returnType(this.getMethodVersion().getMethod().getParsedSignature());
        if (Types.isReference(returnType)) {
            long addr;
            if (result instanceof Long) {
                addr = (Long)result;
            } else {
                assert (result instanceof TruffleObject);
                addr = NativeUtils.interopAsPointer((TruffleObject)result);
            }
            return handles.get(Math.toIntExact(addr));
        }
        assert (returnType != Symbol.Type._void || result == StaticObject.NULL);
        return result;
    }

    @Override
    public int getBci(Frame frame) {
        return VM.EspressoStackElement.NATIVE_BCI;
    }

    @ExportMessage
    public boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public Object getScope(Frame frame, boolean nodeEnter) {
        return new SubstitutionScope(frame.getArguments(), this.getMethodVersion());
    }
}

