/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.MethodParametersAttribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;

@ExportLibrary(value=InteropLibrary.class)
final class SubstitutionScope
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] args;
    private final Method method;
    private String[] paramNames;

    SubstitutionScope(Object[] arguments, Method.MethodVersion method) {
        this.args = arguments;
        this.method = method.getMethod();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return EspressoLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        try {
            int index = Integer.parseInt(member);
            if (index < 0 || index >= this.args.length) {
                throw UnknownIdentifierException.create((String)member);
            }
            return this.args[index];
        }
        catch (NumberFormatException e) {
            String[] names = this.paramNames;
            if (names == null) {
                names = this.paramNames = this.fetchNames();
            }
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(member)) continue;
                return this.args[i];
            }
            throw UnknownIdentifierException.create((String)member);
        }
    }

    private String[] fetchNames() {
        MethodParametersAttribute methodParameters = (MethodParametersAttribute)this.method.getAttribute(Symbol.Name.MethodParameters);
        if (methodParameters == null) {
            return new String[0];
        }
        MethodParametersAttribute.Entry[] entries = methodParameters.getEntries();
        int cpLength = this.method.getConstantPool().length();
        for (MethodParametersAttribute.Entry entry : entries) {
            int nameIndex = entry.getNameIndex();
            if (nameIndex < 0 || nameIndex >= cpLength) {
                return new String[0];
            }
            if (nameIndex == 0 || this.method.getConstantPool().tagAt(nameIndex) == ConstantPool.Tag.UTF8) continue;
            return new String[0];
        }
        String[] result = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            MethodParametersAttribute.Entry entry = entries[i];
            String name = entry.getNameIndex() != 0 ? this.method.getConstantPool().symbolAt(entry.getNameIndex(), "parameter name").toString() : "";
            result[i] = name;
        }
        return result;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        try {
            int index = Integer.parseInt(member);
            return 0 <= index && index < this.args.length;
        }
        catch (NumberFormatException e) {
            String[] names = this.paramNames;
            if (names == null) {
                names = this.paramNames = this.fetchNames();
            }
            for (String name : names) {
                if (!name.equals(member)) continue;
                return true;
            }
            return false;
        }
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.method.getNameAsString();
    }
}

