/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.ByteArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="boolean[] BASTORE")
@GenerateUncached
public abstract class BooleanArrayStore
extends EspressoNode {
    public abstract void execute(StaticObject var1, int var2, byte var3);

    @Specialization
    void doWithNullCheck(StaticObject array, int index, byte value, @Cached NullCheck nullCheck, @Cached ByteArrayStore.WithoutNullCheck byteArrayStore) {
        byteArrayStore.execute(nullCheck.execute(array), index, value);
    }

    @NodeInfo(shortName="boolean[] BASTORE !nullcheck")
    @GenerateUncached
    @ImportStatic(value={Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        static final int LIMIT = 2;

        public abstract void execute(StaticObject var1, int var2, byte var3);

        @Specialization(guards={"array.isEspressoObject()"})
        void doEspresso(StaticObject array, int index, byte value) {
            assert (!StaticObject.isNull(array));
            assert (array.getKlass() == EspressoContext.get((Node)this).getMeta()._boolean_array);
            this.getContext().getInterpreterToVM().setArrayByte(this.getLanguage(), value, index, array);
        }

        @Specialization(guards={"array.isForeignObject()", "isArrayLike(interop, array.rawForeignObject(language))"})
        void doArrayLike(StaticObject array, int index, byte value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getLanguage()") EspressoLanguage language, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            assert (array.getKlass() == this.getMeta()._boolean_array);
            boolean booleanValue = value != 0;
            ForeignArrayUtils.writeForeignArrayElement(array, index, booleanValue, language, this.getMeta(), interop, exceptionProfile);
        }
    }
}

