/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="BALOAD")
@GenerateUncached
public abstract class ByteArrayLoad
extends EspressoNode {
    public abstract byte execute(StaticObject var1, int var2);

    @Specialization
    byte doWithNullCheck(StaticObject array, int index, @Cached NullCheck nullCheck, @Cached WithoutNullCheck byteArrayLoad) {
        return byteArrayLoad.execute(nullCheck.execute(array), index);
    }

    @NodeInfo(shortName="BALOAD !nullcheck")
    @GenerateUncached
    @ImportStatic(value={Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract byte execute(StaticObject var1, int var2);

        @Specialization(guards={"array.isEspressoObject()"})
        byte doEspresso(StaticObject array, int index) {
            assert (!StaticObject.isNull(array));
            return this.getContext().getInterpreterToVM().getArrayByte(this.getLanguage(), index, array);
        }

        @Specialization(guards={"array.isForeignObject()", "isBufferLikeByteArray(language, meta, interop, array)"})
        byte doBufferLike(StaticObject array, int index, @Bind(value="getLanguage()") EspressoLanguage language, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile outOfBoundsProfile) {
            assert (!StaticObject.isNull(array));
            try {
                return interop.readBufferByte(array.rawForeignObject(language), (long)index);
            }
            catch (InvalidBufferOffsetException e) {
                outOfBoundsProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, e.getMessage());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Specialization(guards={"array.isForeignObject()", "!isBufferLikeByteArray(language, meta, arrayInterop, array)", "isArrayLike(arrayInterop, array.rawForeignObject(language))"})
        byte doArrayLike(StaticObject array, int index, @Bind(value="getLanguage()") EspressoLanguage language, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary arrayInterop, @CachedLibrary(limit="LIMIT") InteropLibrary elemInterop, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isByteArrayProfile) {
            assert (!StaticObject.isNull(array));
            Object result = ForeignArrayUtils.readForeignArrayElement(array, index, language, meta, arrayInterop, exceptionProfile);
            if (isByteArrayProfile.profile(array.getKlass() == meta._byte_array)) {
                try {
                    return elemInterop.asByte(result);
                }
                catch (UnsupportedMessageException e) {
                    exceptionProfile.enter();
                    throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the foreign array element to byte");
                }
            }
            assert (array.getKlass() == meta._boolean_array);
            try {
                boolean element = elemInterop.asBoolean(result);
                return (byte)(element ? 1 : 0);
            }
            catch (UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the foreign array element to boolean");
            }
        }
    }
}

