/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="BASTORE")
@GenerateUncached
public abstract class ByteArrayStore
extends EspressoNode {
    public abstract void execute(StaticObject var1, int var2, byte var3);

    @Specialization
    void doWithNullCheck(StaticObject array, int index, byte value, @Cached NullCheck nullCheck, @Cached WithoutNullCheck byteArrayStore) {
        byteArrayStore.execute(nullCheck.execute(array), index, value);
    }

    @NodeInfo(shortName="BASTORE !nullcheck")
    @GenerateUncached
    @ImportStatic(value={Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        static final int LIMIT = 2;

        public abstract void execute(StaticObject var1, int var2, byte var3);

        @Specialization(guards={"array.isEspressoObject()"})
        void doEspresso(StaticObject array, int index, byte value) {
            assert (!StaticObject.isNull(array));
            this.getContext().getInterpreterToVM().setArrayByte(this.getLanguage(), value, index, array);
        }

        @Specialization(guards={"array.isForeignObject()", "isBufferLikeByteArray(language, meta, interop, array)"})
        void doBufferLike(StaticObject array, int index, byte value, @Bind(value="getLanguage()") EspressoLanguage language, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile outOfBoundsProfile, @Cached BranchProfile readOnlyProfile) {
            assert (!StaticObject.isNull(array));
            try {
                interop.writeBufferByte(array.rawForeignObject(language), (long)index, value);
            }
            catch (InvalidBufferOffsetException e) {
                outOfBoundsProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, e.getMessage());
            }
            catch (UnsupportedMessageException e) {
                readOnlyProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ArrayStoreException, e.getMessage());
            }
        }

        @Specialization(guards={"array.isForeignObject()", "!isBufferLikeByteArray(language, meta, interop, array)", "isArrayLike(interop, array.rawForeignObject(language))"})
        void doArrayLike(StaticObject array, int index, byte value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getLanguage()") EspressoLanguage language, @Bind(value="getMeta()") Meta meta, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isByteArrayProfile) {
            assert (!StaticObject.isNull(array));
            if (isByteArrayProfile.profile(array.getKlass() == meta._byte_array)) {
                ForeignArrayUtils.writeForeignArrayElement(array, index, value, language, meta, interop, exceptionProfile);
            } else {
                assert (array.getKlass() == meta._boolean_array);
                boolean booleanValue = value != 0;
                ForeignArrayUtils.writeForeignArrayElement(array, index, booleanValue, language, meta, interop, exceptionProfile);
            }
        }
    }
}

