/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractSetFieldNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

abstract class CharSetFieldNode
extends AbstractSetFieldNode {
    CharSetFieldNode(Field f) {
        super(f);
        assert (f.getKind() == JavaKind.Char);
    }

    @Override
    public void setField(VirtualFrame frame, BytecodeNode root, StaticObject receiver, int top, int statementIndex) {
        char value = (char)EspressoFrame.popInt((Frame)frame, top - 1);
        root.notifyFieldModification(frame, statementIndex, this.field, receiver, Character.valueOf(value));
        this.executeSetField(receiver, value);
    }

    abstract void executeSetField(StaticObject var1, char var2);

    @Specialization(guards={"receiver.isEspressoObject()"})
    void doEspresso(StaticObject receiver, char value) {
        this.field.setChar(receiver, value);
    }

    @Specialization(guards={"receiver.isForeignObject()"}, limit="CACHED_LIBRARY_LIMIT")
    void doForeign(StaticObject receiver, char fieldValue, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(value="receiver.rawForeignObject(language)") InteropLibrary interopLibrary, @Cached BranchProfile error) {
        this.setForeignField(receiver, Character.valueOf(fieldValue), interopLibrary, language, this.getContext(), error);
    }
}

