/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractGetFieldNode;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

abstract class ObjectGetFieldNode
extends AbstractGetFieldNode {
    final Klass typeKlass;

    ObjectGetFieldNode(Field f) {
        super(f);
        this.typeKlass = f.resolveTypeKlass();
        assert (f.getKind() == JavaKind.Object);
    }

    @Override
    public int getField(VirtualFrame frame, BytecodeNode root, StaticObject receiver, int at, int statementIndex) {
        root.notifyFieldAccess(frame, statementIndex, this.getField(), receiver);
        StaticObject result = this.executeGetField(receiver);
        root.checkNoForeignObjectAssumption(result);
        EspressoFrame.putObject((Frame)frame, at, result);
        return this.slotCount;
    }

    abstract StaticObject executeGetField(StaticObject var1);

    ToReference createToEspressoNode() {
        return ToReference.createToReference(this.typeKlass, this.typeKlass.getMeta());
    }

    @Specialization(guards={"receiver.isEspressoObject()"})
    StaticObject doEspresso(StaticObject receiver) {
        return this.field.getObject(receiver);
    }

    @Specialization(guards={"receiver.isForeignObject()"})
    StaticObject doForeign(StaticObject receiver, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="CACHED_LIBRARY_LIMIT") InteropLibrary interopLibrary, @Cached(value="createToEspressoNode()") ToReference toEspressoNode, @Cached BranchProfile error) {
        Meta meta = this.getMeta();
        Object value = this.getForeignField(receiver, interopLibrary, language, meta, error);
        try {
            return toEspressoNode.execute(value);
        }
        catch (UnsupportedTypeException e) {
            error.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Foreign field %s cannot be cast to %s", this.fieldName, this.typeKlass.getName());
        }
    }
}

