/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractSetFieldNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

abstract class ShortSetFieldNode
extends AbstractSetFieldNode {
    ShortSetFieldNode(Field f) {
        super(f);
        assert (f.getKind() == JavaKind.Short);
    }

    @Override
    public void setField(VirtualFrame frame, BytecodeNode root, StaticObject receiver, int top, int statementIndex) {
        short value = (short)EspressoFrame.popInt((Frame)frame, top - 1);
        root.notifyFieldModification(frame, statementIndex, this.field, receiver, value);
        this.executeSetField(receiver, value);
    }

    abstract void executeSetField(StaticObject var1, short var2);

    @Specialization(guards={"receiver.isEspressoObject()"})
    void doEspresso(StaticObject receiver, short value) {
        this.field.setShort(receiver, value);
    }

    @Specialization(guards={"receiver.isForeignObject()"}, limit="CACHED_LIBRARY_LIMIT")
    void doForeign(StaticObject receiver, short fieldValue, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(value="receiver.rawForeignObject(language)") InteropLibrary interopLibrary, @Cached BranchProfile error) {
        this.setForeignField(receiver, fieldValue, interopLibrary, language, this.getContext(), error);
    }
}

