/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.nodes.interop.AbstractLookupNode;

@GenerateUncached
public abstract class LookupDeclaredMethod
extends AbstractLookupNode {
    static final int LIMIT = 2;

    public abstract Method[] execute(Klass var1, String var2, boolean var3, boolean var4, int var5) throws ArityException, UnknownIdentifierException;

    public boolean isInvocable(Klass klass, String key, boolean isStatic) {
        return this.isInvocable(klass, key, true, isStatic);
    }

    @Specialization(guards={"klass.equals(cachedKlass.getKlass())", "key.equals(cachedMethodName)", "publicOnly == cachedPublicOnly", "isStatic == cachedIsStatic", "arity == cachedArity", "method != null"}, limit="LIMIT", assumptions={"cachedKlass.getAssumption()"})
    Method[] doCached(ObjectKlass klass, String key, boolean publicOnly, boolean isStatic, int arity, @Cached(value="klass.getKlassVersion()") ObjectKlass.KlassVersion cachedKlass, @Cached(value="key") String cachedMethodName, @Cached(value="publicOnly") boolean cachedPublicOnly, @Cached(value="isStatic") boolean cachedIsStatic, @Cached(value="arity") int cachedArity, @Cached(value="doGeneric(klass, key, publicOnly, isStatic, arity)") Method[] method) {
        return method;
    }

    @Specialization(replaces={"doCached"})
    Method[] doGeneric(Klass klass, String key, boolean publicOnly, boolean isStatic, int arity) throws ArityException, UnknownIdentifierException {
        return this.doLookup(klass, key, publicOnly, isStatic, arity);
    }

    @Override
    Method.MethodVersion[] getMethodArray(Klass k) {
        return k.getDeclaredMethodVersions();
    }
}

